/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.handler;

import com.ebay.sdk.handler.BaseHandler;
import com.ebay.sdk.logging.MetricsLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricsLogHandler
extends BaseHandler<LogicalMessageContext>
implements LogicalHandler<LogicalMessageContext> {
    public boolean handleMessage(LogicalMessageContext lmc) {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return true;
        }
        Boolean request = (Boolean)lmc.get((Object)"javax.xml.ws.handler.message.outbound");
        if (request.booleanValue()) {
            MetricsLogger.startSdkJAXBCallInvoke();
            HashMap<String, List<String>> http_req_headers = (HashMap<String, List<String>>)lmc.get((Object)"javax.xml.ws.http.request.headers");
            if (http_req_headers == null) {
                http_req_headers = new HashMap<String, List<String>>();
            }
            http_req_headers.put("X-EBAY-API-METRICS", Collections.singletonList("true"));
            lmc.put((Object)"javax.xml.ws.http.request.headers", http_req_headers);
        } else {
            Object value;
            MetricsLogger.endSdkJAXBCallInvoke();
            Map http_resp_headers = (Map)lmc.get((Object)"javax.xml.ws.http.response.headers");
            if (http_resp_headers != null && (value = http_resp_headers.get("X-EBAY-API-PROCESS-TIME")) != null) {
                String sTime = value.toString();
                sTime = this.removeChars(sTime, '[', ']');
                long lTime = this.convertProcessingTime(sTime);
                MetricsLogger.recordServerProcessingTime(lTime);
            }
        }
        return true;
    }

    public String removeChars(String s, char c1, char c2) {
        StringBuffer r = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c1 || s.charAt(i) == c2) continue;
            r.append(s.charAt(i));
        }
        return r.toString();
    }

    private long convertProcessingTime(String val) {
        if (val == null) {
            return 0L;
        }
        long retval = 0L;
        try {
            retval = (long)Float.parseFloat(val);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return retval;
    }
}

