/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.handler;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiLogging;
import com.ebay.sdk.handler.BaseHandler;
import com.ebay.sdk.handler.HandlerUtil;
import com.ebay.sdk.util.ApiLoggingHelper;
import java.util.Map;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPHeaderLoggingHandler
extends BaseHandler<LogicalMessageContext>
implements LogicalHandler<LogicalMessageContext> {
    private static final String HANDLER_NAME = "HTTPHeaderLoggingHandler";

    public HTTPHeaderLoggingHandler() {
        super.setHandlerName(HANDLER_NAME);
    }

    public boolean handleMessage(LogicalMessageContext smc) {
        Boolean request = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
        if (!request.booleanValue()) {
            ApiContext apiContext = (ApiContext)smc.get((Object)"api_context");
            ApiLogging apiLogging = apiContext.getApiLogging();
            if (!ApiLoggingHelper.isLogHTTPHeaders(apiLogging)) {
                return true;
            }
            Log log = ApiLoggingHelper.getLog(apiLogging);
            Map http_req_headers = (Map)smc.get((Object)"javax.xml.ws.http.request.headers");
            Map http_resp_headers = (Map)smc.get((Object)"javax.xml.ws.http.response.headers");
            log.info((Object)"---[HTTP Request Headers]---");
            if (http_req_headers != null) {
                log.info((Object)HandlerUtil.outputMap(http_req_headers));
            } else {
                log.info((Object)"HTTP Request Headers is not available!");
            }
            log.info((Object)"---[HTTP Response Headers]---");
            if (http_resp_headers != null) {
                log.info((Object)HandlerUtil.outputMap(http_resp_headers));
            } else {
                log.info((Object)"HTTP Response Headers is not available!");
            }
        }
        return true;
    }
}

