/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.handler;

import com.ebay.sdk.ApiAccount;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiLogging;
import com.ebay.sdk.eBayAccount;
import com.ebay.sdk.handler.BaseHandler;
import com.ebay.sdk.util.ApiLoggingHelper;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientAuthenticationHandler
extends BaseHandler<SOAPMessageContext>
implements SOAPHandler<SOAPMessageContext> {
    private final String HANDLER_NAME = "ClientAuthenticationHandler";

    public ClientAuthenticationHandler() {
        super.setHandlerName("ClientAuthenticationHandler");
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        boolean request = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
        if (request) {
            ApiContext apiContext = (ApiContext)smc.get((Object)"api_context");
            boolean enableFullCredentials = false;
            Object obj = smc.get((Object)"full_credentials");
            if (obj != null) {
                enableFullCredentials = (Boolean)obj;
            }
            boolean needApiAccountOnly = false;
            obj = smc.get((Object)"api_account_only");
            if (obj != null) {
                needApiAccountOnly = (Boolean)obj;
            }
            try {
                SOAPMessage msg = smc.getMessage();
                SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
                SOAPHeader header = env.getHeader();
                if (header == null) {
                    header = env.addHeader();
                }
                this.addSecurityHeader(header, apiContext, enableFullCredentials, needApiAccountOnly);
            }
            catch (SOAPException e) {
                ApiLogging apiLogging = apiContext.getApiLogging();
                if (ApiLoggingHelper.isLogExceptions(apiLogging)) {
                    Log log = ApiLoggingHelper.getLog(apiLogging);
                    log.error((Object)"ClientAuthenticationHandler : fail to add security headers.");
                    log.error((Object)e.getMessage());
                }
                e.printStackTrace();
            }
        }
        return true;
    }

    private void addSecurityHeader(SOAPHeader header, ApiContext apiContext, boolean enableFullCredentials, boolean needApiAccountOnly) throws SOAPException {
        SOAPElement reqCred = header.addChildElement("RequesterCredentials", "ebl", "urn:ebay:apis:eBLBaseComponents");
        ((SOAPHeaderElement)reqCred).setMustUnderstand(false);
        reqCred.addNamespaceDeclaration("ebl", "urn:ebay:apis:eBLBaseComponents");
        String tokenString = apiContext.getApiCredential().geteBayToken();
        if (enableFullCredentials) {
            SOAPElement credNode = reqCred.addChildElement("Credentials", "ebl");
            ApiAccount ac = apiContext.getApiCredential().getApiAccount();
            credNode.addChildElement("AppId", "ebl").addTextNode(ac.getApplication());
            credNode.addChildElement("DevId", "ebl").addTextNode(ac.getDeveloper());
            credNode.addChildElement("AuthCert", "ebl").addTextNode(ac.getCertificate());
            reqCred.addChildElement("eBayAuthToken", "ebl").addTextNode(tokenString);
            return;
        }
        if (needApiAccountOnly) {
            SOAPElement credNode = reqCred.addChildElement("Credentials", "ebl");
            ApiAccount ac = apiContext.getApiCredential().getApiAccount();
            credNode.addChildElement("AppId", "ebl").addTextNode(ac.getApplication());
            credNode.addChildElement("DevId", "ebl").addTextNode(ac.getDeveloper());
            credNode.addChildElement("AuthCert", "ebl").addTextNode(ac.getCertificate());
            eBayAccount ec = apiContext.getApiCredential().geteBayAccount();
            if (ec != null && ec.getUsername() != null) {
                credNode.addChildElement("Username", "ebl").addTextNode(ec.getUsername());
            }
            return;
        }
        if (tokenString == null || tokenString.length() == 0) {
            SOAPElement credNode = reqCred.addChildElement("Credentials", "ebl");
            ApiAccount ac = apiContext.getApiCredential().getApiAccount();
            credNode.addChildElement("AppId", "ebl").addTextNode(ac.getApplication());
            credNode.addChildElement("DevId", "ebl").addTextNode(ac.getDeveloper());
            credNode.addChildElement("AuthCert", "ebl").addTextNode(ac.getCertificate());
        } else {
            reqCred.addChildElement("eBayAuthToken", "ebl").addTextNode(tokenString);
        }
    }

    public Set<QName> getHeaders() {
        return null;
    }
}

