/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk;

import com.ebay.sdk.SdkException;
import com.ebay.sdk.util.XmlUtil;
import com.ebay.soap.eBLBaseComponents.ErrorType;
import com.ebay.soap.eBLBaseComponents.SeverityCodeType;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Node;

public class SdkSoapException
extends SdkException {
    private ErrorType errorType;

    public static SdkSoapException fromSOAPFaultException(SOAPFaultException sfe) {
        ErrorType errorType = new ErrorType();
        SOAPFault sf = sfe.getFault();
        errorType.setShortMessage(sf.getFaultString());
        Detail elem = sf.getDetail();
        if (elem != null) {
            try {
                String s = XmlUtil.getChildString((Node)elem, "//Severity");
                if (s != null && s.length() > 0) {
                    errorType.setSeverityCode(SeverityCodeType.fromValue(s));
                }
                if ((s = XmlUtil.getChildString((Node)elem, "//ErrorCode")) != null && s.length() > 0) {
                    errorType.setErrorCode(s);
                }
                if ((s = XmlUtil.getChildString((Node)elem, "//DetailedMessage")) != null && s.length() > 0) {
                    errorType.setLongMessage(s);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new SdkSoapException(errorType, (Exception)sfe);
    }

    protected SdkSoapException(ErrorType errorType, Exception innerException) {
        super(innerException);
        this.errorType = errorType;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public String getMessage() {
        String txt = this.errorType.getLongMessage();
        if (txt != null) {
            return txt;
        }
        txt = this.errorType.getShortMessage();
        if (txt != null) {
            return txt;
        }
        return this.errorType.getErrorCode().toString();
    }

    public boolean containsErrorCode(String errorCode) {
        return this.errorType.getErrorCode().toString().equals(errorCode);
    }
}

