/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.RequestContext;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.handler.EBayServiceHandlerResolver;
import com.ebay.soap.eBLBaseComponents.EBayAPIInterface;
import com.ebay.soap.eBLBaseComponents.EBayAPIInterfaceService;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.helpers.Loader;

public class SdkAPIInterfaceServiceLocator {
    private static final ArrayList<EBayAPIInterface> apiPool = new ArrayList();
    private static final String EBAY_WSDL = "eBaySvc.wsdl";
    private static final String EBAY_SERVICE_NAME = "eBayAPIInterfaceService";
    private static final String READ_TIMEOUT = "com.sun.xml.ws.request.timeout";
    private static final Integer lock = new Integer(0);
    private static EBayAPIInterfaceService service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EBayAPIInterface getEBayAPI(ApiContext apiContext, RequestContext reqContext) {
        EBayAPIInterface api = null;
        Integer n = lock;
        synchronized (n) {
            api = apiPool.isEmpty() ? service.getEBayAPI() : apiPool.remove(0);
        }
        SdkAPIInterfaceServiceLocator.initRequestContext(api, apiContext, reqContext);
        return api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseEBayAPI(EBayAPIInterface api) {
        if (api != null) {
            Integer n = lock;
            synchronized (n) {
                apiPool.add(api);
            }
        }
    }

    private static void initRequestContext(EBayAPIInterface api, ApiContext apiContext, RequestContext reqContext) {
        if (api == null) {
            return;
        }
        Map requestContext = ((BindingProvider)api).getRequestContext();
        requestContext.put("api_context", apiContext);
        int timeout = apiContext.getTimeout();
        if (timeout > 0) {
            requestContext.put("com.sun.xml.ws.connect.timeout", timeout);
            requestContext.put(READ_TIMEOUT, timeout);
        } else {
            if (requestContext.containsKey("com.sun.xml.ws.connect.timeout")) {
                requestContext.remove("com.sun.xml.ws.connect.timeout");
            }
            if (requestContext.containsKey(READ_TIMEOUT)) {
                requestContext.remove(READ_TIMEOUT);
            }
        }
        boolean isEnableHTTPCompression = reqContext.isHttpCompressionEnabled();
        if (isEnableHTTPCompression) {
            HashMap<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
            httpHeaders.put("Accept-Encoding", Collections.singletonList("gzip"));
            requestContext.put("javax.xml.ws.http.request.headers", httpHeaders);
        } else if (requestContext.containsKey("javax.xml.ws.http.request.headers")) {
            requestContext.remove("javax.xml.ws.http.request.headers");
        }
        requestContext.put("javax.xml.ws.service.endpoint.address", reqContext.getEndPointAddress());
        boolean isEnabledFullCredentials = reqContext.isFullCredentialsEnabled();
        requestContext.put("full_credentials", isEnabledFullCredentials ? Boolean.TRUE : Boolean.FALSE);
        boolean needApiAccountOnly = reqContext.isApiAccountOnly();
        requestContext.put("api_account_only", needApiAccountOnly ? Boolean.TRUE : Boolean.FALSE);
    }

    static {
        try {
            URL url = Loader.getResource((String)EBAY_WSDL);
            if (url == null) {
                throw new SdkException("fail to load ebay wsdl");
            }
            QName qn = new QName("urn:ebay:apis:eBLBaseComponents", EBAY_SERVICE_NAME);
            System.out.println("loading wsdl : " + url.toString());
            service = new EBayAPIInterfaceService(url, qn);
            System.out.println("wsdl loaded and service initialized.");
            EBayServiceHandlerResolver ccResolver = new EBayServiceHandlerResolver();
            service.setHandlerResolver(ccResolver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

