/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk;

import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkHTTPException;
import com.ebay.sdk.SdkSoapException;
import com.ebay.soap.eBLBaseComponents.ErrorType;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ExceptionFilter {
    private String[] triggerApiErrorCodes;
    private int[] triggerHTTPErrorCodes;
    private Class[] triggerExceptions;

    public ExceptionFilter() {
    }

    public ExceptionFilter(String errorCodes, String exceptions, String httpStatusCodes) {
        this.triggerApiErrorCodes = this.parseTriggerErrorCodes(errorCodes);
        this.triggerHTTPErrorCodes = this.parseTriggerHttpStatusCodes(httpStatusCodes);
        this.triggerExceptions = this.parseTriggerExceptions(exceptions);
    }

    private Class[] parseTriggerExceptions(String exceptions) {
        if (exceptions == null || exceptions.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(exceptions, ";");
        ArrayList<Class> outList = new ArrayList<Class>();
        while (st.hasMoreTokens()) {
            String exceptionName = st.nextToken();
            Class c = ExceptionFilter.getClassFromName(exceptionName);
            outList.add(c);
        }
        Class[] ret = new Class[outList.size()];
        for (int i = 0; i < outList.size(); ++i) {
            ret[i] = (Class)outList.get(i);
        }
        return ret;
    }

    private static Class getClassFromName(String name) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private int[] parseTriggerHttpStatusCodes(String httpStatusCodes) {
        if (httpStatusCodes == null || httpStatusCodes.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(httpStatusCodes, ";");
        int[] outCodes = new int[st.countTokens()];
        for (int i = 0; i < outCodes.length; ++i) {
            String statusCode = st.nextToken();
            outCodes[i] = Integer.parseInt(statusCode);
        }
        return outCodes;
    }

    private String[] parseTriggerErrorCodes(String errorCodes) {
        if (errorCodes == null || errorCodes.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(errorCodes, ";");
        ArrayList<String> outList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String errCode = st.nextToken();
            outList.add(errCode);
        }
        return (String[])outList.toArray();
    }

    public Class[] getTriggerExceptions() {
        return this.triggerExceptions;
    }

    public void setTriggerExceptions(Class[] triggerExceptions) {
        this.triggerExceptions = triggerExceptions;
    }

    public String[] getTriggerApiErrorCodes() {
        return this.triggerApiErrorCodes;
    }

    public void setTriggerApiErrorCodes(String[] triggerApiErrorCodes) {
        this.triggerApiErrorCodes = triggerApiErrorCodes;
    }

    public int[] getTriggerHTTPErrorCodes() {
        return this.triggerHTTPErrorCodes;
    }

    public void setTriggerHTTPErrorCodes(int[] triggerHTTPErrorCodes) {
        this.triggerHTTPErrorCodes = triggerHTTPErrorCodes;
    }

    private boolean containsErrorCode(String errorCode, ErrorType[] errors) {
        for (int i = 0; i < errors.length; ++i) {
            String errCode = errors[i].getErrorCode();
            if (errCode == null || !errCode.equals(errorCode)) continue;
            return true;
        }
        return false;
    }

    private boolean containsException(Class[] exceptionList, Class exception) {
        for (int i = 0; i < exceptionList.length; ++i) {
            if (!exceptionList[i].getName().equals(exception.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean containsInt(int[] exceptionList, int code) {
        for (int i = 0; i < exceptionList.length; ++i) {
            if (exceptionList[i] != code) continue;
            return true;
        }
        return false;
    }

    public boolean matches(Exception exception) {
        SdkHTTPException se;
        if (exception == null) {
            return false;
        }
        if (this.triggerExceptions == null ? this.triggerApiErrorCodes == null && this.triggerHTTPErrorCodes == null : this.containsException(this.triggerExceptions, exception.getClass())) {
            return true;
        }
        if (this.triggerApiErrorCodes != null) {
            ErrorType[] apiErrors = null;
            if (exception instanceof ApiException) {
                ApiException ae = (ApiException)exception;
                apiErrors = ae.getErrors();
            } else if (exception instanceof SdkSoapException) {
                SdkSoapException se2 = (SdkSoapException)exception;
                apiErrors = new ErrorType[]{se2.getErrorType()};
            }
            if (apiErrors != null) {
                for (int i = 0; i < this.triggerApiErrorCodes.length; ++i) {
                    if (!this.containsErrorCode(this.triggerApiErrorCodes[i], apiErrors)) continue;
                    return true;
                }
            }
        }
        return this.triggerHTTPErrorCodes != null && exception instanceof SdkHTTPException && this.containsInt(this.triggerHTTPErrorCodes, (se = (SdkHTTPException)exception).getErrorCode());
    }
}

