/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiCredential;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.SiteIDUtil;
import com.ebay.sdk.util.XmlUtil;
import com.ebay.sdk.util.eBayUtil;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ApiSchemaBasedXmlPoster {
    private ApiContext apiContext;

    public ApiContext getApiContext() {
        return this.apiContext;
    }

    public void setApiContext(ApiContext apiContext) {
        this.apiContext = apiContext;
    }

    public String postXmlText(int sideId, String requestXml) throws SAXException, IOException, ParserConfigurationException, TransformerException, SdkException {
        Document reqDom = XmlUtil.createDom(requestXml);
        Node request = reqDom.getFirstChild();
        String requestName = request.getNodeName();
        String verb = requestName.substring(0, requestName.length() - 7);
        if (verb.length() == 0) {
            throw new SdkException("No <Verb> found in request Xml.");
        }
        String version = XmlUtil.getChildStringByName(request, "Version", "");
        if (version.length() == 0) {
            throw new SdkException("No <Version> found in request Xml.");
        }
        HttpURLConnection conn = this.openConnection();
        conn.setRequestProperty("X-EBAY-API-COMPATIBILITY-LEVEL", version);
        conn.setRequestProperty("X-EBAY-API-CALL-NAME", verb);
        conn.setRequestProperty("X-EBAY-API-SITEID", String.valueOf(SiteIDUtil.toNumericalID(this.apiContext.getSite())));
        OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream());
        osw.write(requestXml);
        osw.flush();
        osw.close();
        return eBayUtil.convertInputStreamToString(conn.getInputStream());
    }

    private HttpURLConnection openConnection() throws MalformedURLException, IOException {
        ApiCredential ac = this.apiContext.getApiCredential();
        URL url = new URL(this.apiContext.getApiServerUrl());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Content-Type", "text/xml");
        conn.setRequestProperty("X-EBAY-API-COMPATIBILITY-LEVEL", this.apiContext.getWSDLVersion());
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        return conn;
    }
}

