/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk;

import com.ebay.sdk.SdkException;
import com.ebay.soap.eBLBaseComponents.ErrorType;
import com.ebay.soap.eBLBaseComponents.SeverityCodeType;

public class ApiException
extends SdkException {
    private ErrorType[] errors;

    public ApiException() {
    }

    public ApiException(ErrorType[] errors) {
        this.errors = errors;
    }

    public ErrorType[] getErrors() {
        return this.errors;
    }

    public void setErrors(ErrorType[] errors) {
        this.errors = errors;
    }

    private int countErrors(String token) {
        int count = 0;
        for (int i = 0; i < this.errors.length; ++i) {
            SeverityCodeType severity = this.errors[i].getSeverityCode();
            if (severity == null || !severity.value().equals(token)) continue;
            ++count;
        }
        return count;
    }

    public int getSeverityErrorCount() {
        return this.countErrors(SeverityCodeType.ERROR.value());
    }

    public int getSeverityWarningCount() {
        return this.countErrors(SeverityCodeType.WARNING.value());
    }

    public String getMessage() {
        String message = "";
        if (this.errors != null) {
            for (int i = 0; i < this.errors.length; ++i) {
                String s;
                if (i > 0) {
                    message = message + "\n";
                }
                if (!((s = this.errors[i].getLongMessage()) != null && s.length() != 0 || (s = this.errors[i].getShortMessage()) != null && s.length() != 0)) {
                    String errorCode = this.errors[i].getErrorCode();
                    s = errorCode != null ? errorCode : "";
                }
                message = message + s;
            }
        }
        return message;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public boolean containsErrorCode(String errorCode) {
        for (int i = 0; i < this.errors.length; ++i) {
            String errCode = this.errors[i].getErrorCode();
            if (errCode == null || !errCode.equals(errorCode)) continue;
            return true;
        }
        return false;
    }
}

