/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk;

import com.ebay.sdk.ApiAccount;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiCredential;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.ApiLogging;
import com.ebay.sdk.CallRetry;
import com.ebay.sdk.ExceptionFilter;
import com.ebay.sdk.RequestContext;
import com.ebay.sdk.SdkAPIInterfaceServiceLocator;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.SdkHTTPException;
import com.ebay.sdk.SdkSoapException;
import com.ebay.sdk.SendApiRequestListener;
import com.ebay.sdk.SiteIDUtil;
import com.ebay.sdk.logging.MetricsLogger;
import com.ebay.sdk.util.ApiLoggingHelper;
import com.ebay.sdk.util.eBayUtil;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.AbstractResponseType;
import com.ebay.soap.eBLBaseComponents.BotBlockRequestType;
import com.ebay.soap.eBLBaseComponents.DetailLevelCodeType;
import com.ebay.soap.eBLBaseComponents.EBayAPIInterface;
import com.ebay.soap.eBLBaseComponents.ErrorHandlingCodeType;
import com.ebay.soap.eBLBaseComponents.ErrorType;
import com.ebay.soap.eBLBaseComponents.SiteCodeType;
import com.ebay.soap.eBLBaseComponents.WarningLevelCodeType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.event.EventListenerList;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.logging.Log;

public class ApiCall {
    private SiteCodeType site = null;
    private ApiContext apiContext;
    private DetailLevelCodeType[] detailLevel = new DetailLevelCodeType[0];
    private CallRetry callRetry;
    private AbstractResponseType response = null;
    private String[] outputSelector = new String[0];
    protected EventListenerList sendReqListeners = new EventListenerList();
    private String messageID = null;
    private String endUserIP = null;
    private ErrorHandlingCodeType errorHandling;
    private String invocationID = null;
    private WarningLevelCodeType warningLevel = null;
    private BotBlockRequestType botBlock = null;
    private boolean enableHTTPCompression = true;
    private String[] callsNeedFullCredentials = new String[]{"GetTokenStatus", "RevokeToken"};
    private String[] callsNeedApiAccountOnly = new String[]{"GetSessionID", "FetchToken"};
    protected ApiException apiException;

    public ApiCall() {
    }

    private boolean isFullCredentials(String apiName) {
        for (String name : this.callsNeedFullCredentials) {
            if (!name.equalsIgnoreCase(apiName)) continue;
            return true;
        }
        return false;
    }

    private boolean isApiAccountOnly(String apiName) {
        for (String name : this.callsNeedApiAccountOnly) {
            if (!name.equalsIgnoreCase(apiName)) continue;
            return true;
        }
        return false;
    }

    public ApiCall(ApiContext apiContext) {
        this.apiContext = apiContext;
    }

    public ApiContext getApiContext() {
        return this.apiContext;
    }

    public void setApiContext(ApiContext apiContext) {
        this.apiContext = apiContext;
    }

    public void addSendRequestListener(SendApiRequestListener l) {
        if (l != null) {
            this.sendReqListeners.add(SendApiRequestListener.class, l);
        }
    }

    public void removeSendRequestListener(SendApiRequestListener l) {
        if (l != null) {
            this.sendReqListeners.remove(SendApiRequestListener.class, l);
        }
    }

    public DetailLevelCodeType[] getDetailLevel() {
        return this.detailLevel;
    }

    public void setDetailLevel(DetailLevelCodeType[] detailLevel) {
        this.detailLevel = detailLevel == null ? new DetailLevelCodeType[0] : detailLevel;
    }

    public void addDetailLevel(DetailLevelCodeType detail) {
        int newLen = this.detailLevel != null ? this.detailLevel.length : 0;
        DetailLevelCodeType[] ndl = new DetailLevelCodeType[++newLen];
        if (this.detailLevel != null) {
            for (int i = 0; i < this.detailLevel.length; ++i) {
                ndl[i] = this.detailLevel[i];
            }
        }
        ndl[newLen - 1] = detail;
        this.detailLevel = ndl;
    }

    public CallRetry getCallRetry() {
        return this.callRetry;
    }

    public void setCallRetry(CallRetry callRetry) {
        this.callRetry = callRetry;
    }

    public ApiException getApiException() {
        return this.apiException;
    }

    public boolean hasWarning() {
        return this.apiException != null && this.apiException.getSeverityWarningCount() > 0;
    }

    public boolean hasError() {
        return this.apiException != null && this.apiException.getSeverityErrorCount() > 0;
    }

    public String getRequestXml() {
        return this.apiContext.getRequestXml();
    }

    public String getResponseXml() {
        return this.apiContext.getResponseXml();
    }

    public SiteCodeType getSite() {
        return this.site;
    }

    public boolean getEnableCompression() {
        return this.enableHTTPCompression;
    }

    public void setSite(SiteCodeType site) {
        this.site = site;
    }

    public void setEnableCompression(boolean enableCompression) {
        this.enableHTTPCompression = enableCompression;
    }

    public AbstractResponseType getResponseObject() {
        return this.response;
    }

    private AbstractResponseType callSOAP(EBayAPIInterface api, String apiName, AbstractRequestType request) throws Exception {
        Method method;
        Object objRet = null;
        try {
            StringBuffer sb = new StringBuffer(apiName);
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            method = api.getClass().getMethod(sb.toString(), request.getClass());
        }
        catch (Exception e) {
            throw new SdkException("ApiCall - call method not found: " + e.getMessage(), e);
        }
        objRet = method.invoke((Object)api, request);
        return (AbstractResponseType)objRet;
    }

    public AbstractResponseType execute(AbstractRequestType request) throws ApiException, SdkSoapException, SdkException {
        String s = request.getClass().getName();
        int start = s.lastIndexOf(46);
        int end = s.indexOf("RequestType");
        if (start == -1 || end == -1) {
            throw new SdkException("Invalid AbstractRequestType parameter.");
        }
        String apiName = s.substring(++start, end);
        return this.executeByApiName(apiName, request);
    }

    void checkProperties(String apiName) throws SdkException {
        if (this.apiContext == null) {
            throw new SdkException("Please set valid ApiContext property");
        }
        ApiCredential cred = this.apiContext.getApiCredential();
        if (cred == null) {
            throw new SdkException("Please set valid ApiContext.ApiCredential property");
        }
        if (this.isFullCredentials(apiName)) {
            if (!this.isValidFullCredentials(cred)) {
                throw new SdkException("This api call needs full credentials, both eBay token and ApiAccount are needed");
            }
        } else {
            String token = cred.geteBayToken();
            if (token == null || token.length() == 0) {
                ApiAccount ac = cred.getApiAccount();
                if (ac == null) {
                    throw new SdkException("Please either eBay token or ApiAccount plus eBayAccount as credential.");
                }
                if (ac.getDeveloper() == null) {
                    throw new SdkException("Please set the API developer (ApiAccount.setDeveloper()).");
                }
                if (ac.getApplication() == null) {
                    throw new SdkException("Please set the API application (ApiAccount.setApplication()).");
                }
                if (ac.getCertificate() == null) {
                    throw new SdkException("Please set the API certificate (ApiAccount.setCertificate()).");
                }
            }
        }
    }

    private boolean isValidFullCredentials(ApiCredential cred) {
        String token = cred.geteBayToken();
        if (token == null || token.length() == 0) {
            return false;
        }
        ApiAccount ac = cred.getApiAccount();
        if (ac == null) {
            return false;
        }
        if (ac.getDeveloper() == null) {
            return false;
        }
        if (ac.getApplication() == null) {
            return false;
        }
        return ac.getCertificate() != null;
    }

    private String getDstUrl(String apiName) {
        SiteCodeType siteID = this.site != null ? this.site : this.apiContext.getSite();
        String rtStr = this.apiContext.getRouting() == null ? "" : "&routing=" + this.apiContext.getRouting();
        String dstUrl = MessageFormat.format("{0}?siteid={1}{2}&callname={3}&client=java", this.apiContext.getApiServerUrl(), new Integer(SiteIDUtil.toNumericalID(siteID)), rtStr, apiName);
        String appID = "";
        ApiAccount ac = this.apiContext.getApiCredential().getApiAccount();
        if (ac != null) {
            appID = ac.getApplication();
        }
        if (appID != null && appID.length() > 0) {
            dstUrl = dstUrl + "&appid=" + appID;
        }
        return dstUrl;
    }

    private RequestContext getRequestContext(String apiName, String dstUrl) {
        RequestContext reqContext = new RequestContext();
        reqContext.setEndPointAddress(dstUrl);
        reqContext.setHttpCompressionEnabled(this.enableHTTPCompression);
        if (this.isFullCredentials(apiName)) {
            reqContext.setFullCredentialsEnabled(true);
        }
        if (this.isApiAccountOnly(apiName)) {
            reqContext.setApiAccountOnly(true);
        }
        return reqContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractResponseType executeByApiName(String apiName, AbstractRequestType request) throws ApiException, SdkSoapException, SdkException {
        try {
            MetricsLogger.startRecordingSingleCallMetrics(apiName);
            this.checkProperties(apiName);
            AbstractResponseType resp = null;
            request.setVersion(this.apiContext.getWSDLVersion());
            ApiLogging apiLogging = this.apiContext.getApiLogging();
            Log log = ApiLoggingHelper.getLog(apiLogging);
            boolean logExceptions = ApiLoggingHelper.isLogExceptions(apiLogging);
            EBayAPIInterface api = null;
            try {
                Exception callException;
                String dstUrl = this.getDstUrl(apiName);
                RequestContext reqContext = this.getRequestContext(apiName, dstUrl);
                api = SdkAPIInterfaceServiceLocator.getEBayAPI(this.apiContext, reqContext);
                int retries = 0;
                int maxRetries = 0;
                CallRetry cr = this.getCallRetry();
                if (cr == null) {
                    cr = this.apiContext.getCallRetry();
                }
                if (cr != null) {
                    maxRetries = cr.getMaximumRetries();
                }
                request.setDetailLevel(this.getDetailLevel());
                request.setErrorLanguage(this.getApiContext().getErrorLanguage());
                request.setOutputSelector(this.getOutputSelector());
                request.setMessageID(this.getMessageID());
                request.setEndUserIP(this.getEndUserIP());
                request.setErrorHandling(this.getErrorHandling());
                request.setInvocationID(this.getInvocationID());
                request.setWarningLevel(this.getWarningLevel());
                request.setBotBlock(this.getBotBlock());
                this.fireSendRequestEvent(request);
                do {
                    ApiException apiExp;
                    resp = null;
                    callException = null;
                    try {
                        if (log != null) {
                            log.info((Object)("Sending SOAP request to: " + dstUrl));
                        }
                        this.response = resp = this.callSOAP(api, apiName, request);
                        this.apiContext.incrementTotalCalls();
                        this.apiException = this.getApiException(resp);
                        this.checkHardExpirationWarning(log, resp);
                    }
                    catch (Exception e) {
                        if (e instanceof InvocationTargetException) {
                            Throwable trb = ((InvocationTargetException)e).getTargetException();
                            e = trb instanceof Exception ? (Exception)trb : new SdkException(trb);
                        }
                        callException = e instanceof HTTPException ? SdkHTTPException.fromHTTPException((HTTPException)e) : (e instanceof SOAPFaultException ? SdkSoapException.fromSOAPFaultException((SOAPFaultException)e) : e);
                    }
                    if (callException == null && (apiExp = this.getApiException(resp)) != null && apiExp.getSeverityErrorCount() > 0) {
                        callException = apiExp;
                    }
                    if (callException == null) continue;
                    if (cr == null || retries >= maxRetries || !cr.shouldRetry(callException)) {
                        throw callException;
                    }
                    Thread.sleep(cr.getDelayTime());
                    ++retries;
                    if (!logExceptions || log == null) continue;
                    log.error((Object)callException.toString());
                    log.info((Object)("Retry " + apiName + " #" + retries + " ..."));
                } while (callException != null && retries <= maxRetries);
            }
            catch (Exception e) {
                try {
                    if (e instanceof InvocationTargetException) {
                        InvocationTargetException ite = (InvocationTargetException)e;
                        e = (Exception)ite.getTargetException();
                    }
                    if (logExceptions && log != null) {
                        ExceptionFilter filter = apiLogging.getMessageLoggingFilter();
                        if (filter != null && filter.matches(e)) {
                            log.info((Object)"Exception based logging enabled.");
                            this.logMessage(log, "Request", this.apiContext.getRequestXml());
                            this.logMessage(log, "Response", this.apiContext.getResponseXml());
                        }
                        log.error((Object)e.toString());
                    }
                    if (e instanceof ApiException) {
                        throw (ApiException)e;
                    }
                    if (e instanceof SdkSoapException) {
                        throw (SdkSoapException)e;
                    }
                    if (e instanceof SdkException) {
                        throw (SdkException)e;
                    }
                    throw new SdkException("ApiCall.execute() - " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    SdkAPIInterfaceServiceLocator.releaseEBayAPI(api);
                    throw throwable;
                }
            }
            SdkAPIInterfaceServiceLocator.releaseEBayAPI(api);
            AbstractResponseType abstractResponseType = resp;
            return abstractResponseType;
        }
        finally {
            MetricsLogger.endRecordingSingleCallMetrics();
        }
    }

    private ApiException getApiException(AbstractResponseType resp) {
        if (resp == null) {
            return null;
        }
        ApiException apiExp = null;
        ErrorType[] errors = resp.getErrors();
        if (errors != null && errors.length > 0) {
            apiExp = new ApiException(errors);
        }
        return apiExp;
    }

    private void checkHardExpirationWarning(Log log, AbstractResponseType resp) throws ParseException {
        if (resp == null) {
            return;
        }
        String hardExpirationWarning = resp.getHardExpirationWarning();
        if (hardExpirationWarning != null && hardExpirationWarning.length() > 0) {
            if (log != null) {
                log.info((Object)"eBay token hard expiration warning received.");
            }
            Date expDate = eBayUtil.fromAPITimeString(hardExpirationWarning);
            ApiCredential ac = this.apiContext.getApiCredential();
            ac.fireWarnTokenHardExpiration(expDate);
        }
    }

    private void logMessage(Log log, String msgName, String msgStr) {
        if (msgStr == null) {
            return;
        }
        String hs = MessageFormat.format("{0} Message: Length={1}", msgName, new Integer(msgStr.length()));
        log.info((Object)hs);
        log.info((Object)msgStr);
    }

    void fireSendRequestEvent(AbstractRequestType request) throws SdkException {
        SendApiRequestListener[] ls = (SendApiRequestListener[])this.sendReqListeners.getListeners(SendApiRequestListener.class);
        if (ls != null) {
            for (int i = ls.length - 1; i >= 0; --i) {
                ls[i].FilterApiRequest(request);
            }
        }
    }

    public String[] getOutputSelector() {
        return this.outputSelector;
    }

    public void setOutputSelector(String[] outputSelector) {
        this.outputSelector = outputSelector;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public String getEndUserIP() {
        return this.endUserIP;
    }

    public void setEndUserIP(String endUserIP) {
        this.endUserIP = endUserIP;
    }

    public String getInvocationID() {
        return this.invocationID;
    }

    public void setInvocationID(String invocationID) {
        this.invocationID = invocationID;
    }

    public WarningLevelCodeType getWarningLevel() {
        return this.warningLevel;
    }

    public void setWarningLevel(WarningLevelCodeType warningLevel) {
        this.warningLevel = warningLevel;
    }

    public BotBlockRequestType getBotBlock() {
        return this.botBlock;
    }

    public void setBotBlock(BotBlockRequestType botBlock) {
        this.botBlock = botBlock;
    }

    public ErrorHandlingCodeType getErrorHandling() {
        return this.errorHandling;
    }

    public void setErrorHandling(ErrorHandlingCodeType errorHandling) {
        this.errorHandling = errorHandling;
    }
}

