/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.optional;

import java.util.Hashtable;
import java.util.Iterator;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.ReflectUtil;
import org.apache.tools.ant.util.ScriptRunnerBase;

public class ScriptRunner
extends ScriptRunnerBase {
    private BSFEngine engine;
    private BSFManager manager;

    public String getManagerName() {
        return "bsf";
    }

    public boolean supportsLanguage() {
        Hashtable table = (Hashtable)ReflectUtil.getField((Object)new BSFManager(), (String)"registeredEngines");
        String engineClassName = (String)table.get(this.getLanguage());
        if (engineClassName == null) {
            this.getProject().log("This is no BSF engine class for language '" + this.getLanguage() + "'", 3);
            return false;
        }
        try {
            this.getScriptClassLoader().loadClass(engineClassName);
            return true;
        }
        catch (Throwable ex) {
            this.getProject().log("unable to create BSF engine class for language '" + this.getLanguage() + "'", ex, 3);
            return false;
        }
    }

    public void executeScript(String execName) throws BuildException {
        this.checkLanguage();
        ClassLoader origLoader = this.replaceContextLoader();
        try {
            BSFManager m = this.createManager();
            this.declareBeans(m);
            if (this.engine == null) {
                m.exec(this.getLanguage(), execName, 0, 0, (Object)this.getScript());
            } else {
                this.engine.exec(execName, 0, 0, (Object)this.getScript());
            }
        }
        catch (BSFException be) {
            throw this.getBuildException(be);
        }
        finally {
            this.restoreContextLoader(origLoader);
        }
    }

    public Object evaluateScript(String execName) throws BuildException {
        this.checkLanguage();
        ClassLoader origLoader = this.replaceContextLoader();
        try {
            BSFManager m = this.createManager();
            this.declareBeans(m);
            if (this.engine == null) {
                Object object = m.eval(this.getLanguage(), execName, 0, 0, (Object)this.getScript());
                return object;
            }
            Object object = this.engine.eval(execName, 0, 0, (Object)this.getScript());
            return object;
        }
        catch (BSFException be) {
            throw this.getBuildException(be);
        }
        finally {
            this.restoreContextLoader(origLoader);
        }
    }

    private BuildException getBuildException(BSFException be) {
        BSFException t = be;
        Throwable te = be.getTargetException();
        if (te instanceof BuildException) {
            return (BuildException)te;
        }
        return new BuildException(te == null ? t : te);
    }

    private void declareBeans(BSFManager m) throws BSFException {
        Iterator i = this.getBeans().keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = this.getBeans().get(key);
            if (value != null) {
                m.declareBean(key, value, value.getClass());
                continue;
            }
            m.undeclareBean(key);
        }
    }

    private BSFManager createManager() throws BSFException {
        if (this.manager != null) {
            return this.manager;
        }
        BSFManager m = new BSFManager();
        m.setClassLoader(this.getScriptClassLoader());
        if (this.getKeepEngine()) {
            BSFEngine e = this.manager.loadScriptingEngine(this.getLanguage());
            this.manager = m;
            this.engine = e;
        }
        return m;
    }

    static {
        BSFManager.registerScriptingEngine((String)"groovy", (String)"org.codehaus.groovy.bsf.GroovyEngine", (String[])new String[]{"groovy", "gy"});
    }
}

