/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.TimeFilter;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.DisputeArrayType;
import com.ebay.soap.eBLBaseComponents.DisputeFilterCountType;
import com.ebay.soap.eBLBaseComponents.DisputeFilterTypeCodeType;
import com.ebay.soap.eBLBaseComponents.DisputeSortTypeCodeType;
import com.ebay.soap.eBLBaseComponents.GetUserDisputesRequestType;
import com.ebay.soap.eBLBaseComponents.GetUserDisputesResponseType;
import com.ebay.soap.eBLBaseComponents.PaginationResultType;
import com.ebay.soap.eBLBaseComponents.PaginationType;

public class GetUserDisputesCall
extends ApiCall {
    private DisputeFilterTypeCodeType disputeFilterType = null;
    private DisputeSortTypeCodeType disputeSortType = null;
    private TimeFilter timeFilter = null;
    private PaginationType pagination = null;
    private String returnedStartingDisputeID = null;
    private String returnedEndingDisputeID = null;
    private DisputeArrayType returnedDisputeArray = null;
    private Integer returnedItemsPerPage = null;
    private Integer returnedPageNumber = null;
    private DisputeFilterCountType[] returnedDisputeFilterCount = null;
    private PaginationResultType returnedPaginationResult = null;

    public GetUserDisputesCall() {
    }

    public GetUserDisputesCall(ApiContext apiContext) {
        super(apiContext);
    }

    public GetUserDisputesResponseType getUserDisputes() throws ApiException, SdkException, Exception {
        GetUserDisputesRequestType req = new GetUserDisputesRequestType();
        req.setDetailLevel(this.getDetailLevel());
        if (this.disputeFilterType != null) {
            req.setDisputeFilterType(this.disputeFilterType);
        }
        if (this.disputeSortType != null) {
            req.setDisputeSortType(this.disputeSortType);
        }
        if (this.timeFilter != null) {
            req.setModTimeFrom(this.timeFilter.getTimeFrom());
            req.setModTimeTo(this.timeFilter.getTimeTo());
        }
        if (this.pagination != null) {
            req.setPagination(this.pagination);
        }
        GetUserDisputesResponseType resp = (GetUserDisputesResponseType)this.execute((AbstractRequestType)req);
        this.returnedStartingDisputeID = resp.getStartingDisputeID();
        this.returnedEndingDisputeID = resp.getEndingDisputeID();
        this.returnedDisputeArray = resp.getDisputeArray();
        this.returnedItemsPerPage = resp.getItemsPerPage();
        this.returnedPageNumber = resp.getPageNumber();
        this.returnedDisputeFilterCount = resp.getDisputeFilterCount();
        this.returnedPaginationResult = resp.getPaginationResult();
        return resp;
    }

    public DisputeFilterTypeCodeType getDisputeFilterType() {
        return this.disputeFilterType;
    }

    public void setDisputeFilterType(DisputeFilterTypeCodeType disputeFilterType) {
        this.disputeFilterType = disputeFilterType;
    }

    public DisputeSortTypeCodeType getDisputeSortType() {
        return this.disputeSortType;
    }

    public void setDisputeSortType(DisputeSortTypeCodeType disputeSortType) {
        this.disputeSortType = disputeSortType;
    }

    public PaginationType getPagination() {
        return this.pagination;
    }

    public void setPagination(PaginationType pagination) {
        this.pagination = pagination;
    }

    public TimeFilter getTimeFilter() {
        return this.timeFilter;
    }

    public void setTimeFilter(TimeFilter timeFilter) {
        this.timeFilter = timeFilter;
    }

    public DisputeArrayType getReturnedDisputeArray() {
        return this.returnedDisputeArray;
    }

    public DisputeFilterCountType[] getReturnedDisputeFilterCount() {
        return this.returnedDisputeFilterCount;
    }

    public String getReturnedEndingDisputeID() {
        return this.returnedEndingDisputeID;
    }

    public Integer getReturnedItemsPerPage() {
        return this.returnedItemsPerPage;
    }

    public Integer getReturnedPageNumber() {
        return this.returnedPageNumber;
    }

    public PaginationResultType getReturnedPaginationResult() {
        return this.returnedPaginationResult;
    }

    public String getReturnedStartingDisputeID() {
        return this.returnedStartingDisputeID;
    }
}

