/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.CategoryType;
import com.ebay.soap.eBLBaseComponents.GetPopularKeywordsRequestType;
import com.ebay.soap.eBLBaseComponents.GetPopularKeywordsResponseType;
import com.ebay.soap.eBLBaseComponents.PaginationResultType;
import com.ebay.soap.eBLBaseComponents.PaginationType;

public class GetPopularKeywordsCall
extends ApiCall {
    private String[] categoryID = null;
    private Boolean includeChildCategories = null;
    private Integer maxKeywordsRetrieved = null;
    private PaginationType pagination = null;
    private PaginationResultType returnedPaginationResult = null;
    private CategoryType[] returnedPopularKeywords = null;
    private Boolean returnedHasMore = null;

    public GetPopularKeywordsCall() {
    }

    public GetPopularKeywordsCall(ApiContext apiContext) {
        super(apiContext);
    }

    public void getPopularKeywords() throws ApiException, SdkException, Exception {
        GetPopularKeywordsRequestType req = new GetPopularKeywordsRequestType();
        if (this.categoryID != null) {
            req.setCategoryID(this.categoryID);
        }
        if (this.includeChildCategories != null) {
            req.setIncludeChildCategories(this.includeChildCategories);
        }
        if (this.maxKeywordsRetrieved != null) {
            req.setMaxKeywordsRetrieved(this.maxKeywordsRetrieved);
        }
        if (this.pagination != null) {
            req.setPagination(this.pagination);
        }
        GetPopularKeywordsResponseType resp = (GetPopularKeywordsResponseType)this.execute((AbstractRequestType)req);
        this.returnedPaginationResult = resp.getPaginationResult();
        this.returnedPopularKeywords = resp.getCategoryArray() == null ? null : resp.getCategoryArray().getCategory();
        this.returnedHasMore = resp.isHasMore();
    }

    public String[] getCategoryID() {
        return this.categoryID;
    }

    public void setCategoryID(String[] categoryID) {
        this.categoryID = categoryID;
    }

    public Boolean getIncludeChildCategories() {
        return this.includeChildCategories;
    }

    public void setIncludeChildCategories(Boolean includeChildCategories) {
        this.includeChildCategories = includeChildCategories;
    }

    public Integer getMaxKeywordsRetrieved() {
        return this.maxKeywordsRetrieved;
    }

    public void setMaxKeywordsRetrieved(Integer maxKeywordsRetrieved) {
        this.maxKeywordsRetrieved = maxKeywordsRetrieved;
    }

    public PaginationType getPagination() {
        return this.pagination;
    }

    public void setPagination(PaginationType pagination) {
        this.pagination = pagination;
    }

    public Boolean getReturnedHasMore() {
        return this.returnedHasMore;
    }

    public PaginationResultType getReturnedPaginationResult() {
        return this.returnedPaginationResult;
    }

    public CategoryType[] getReturnedPopularKeywords() {
        return this.returnedPopularKeywords;
    }
}

