/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.TimeFilter;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.GetItemTransactionsRequestType;
import com.ebay.soap.eBLBaseComponents.GetItemTransactionsResponseType;
import com.ebay.soap.eBLBaseComponents.ItemType;
import com.ebay.soap.eBLBaseComponents.PaginationResultType;
import com.ebay.soap.eBLBaseComponents.PaginationType;
import com.ebay.soap.eBLBaseComponents.TransactionPlatformCodeType;
import com.ebay.soap.eBLBaseComponents.TransactionType;

public class GetItemTransactionsCall
extends ApiCall {
    private String itemID = null;
    private TimeFilter modifiedTimeFilter = null;
    private String transactionID = null;
    private PaginationType pagination = null;
    private Boolean includeFinalValueFee = null;
    private Boolean includeContainingOrder = null;
    private TransactionPlatformCodeType platform = null;
    private Integer numberOfDays = null;
    private Boolean includeVariations = null;
    private PaginationResultType paginationResult = null;
    private boolean hasMoreTransactions = false;
    private Integer returnedTransactionsPerPage = null;
    private Integer returnedPageNumber = null;
    private int returnedTransactionCountActual = 0;
    private ItemType item = null;
    private TransactionType[] returnedTransactions = null;
    private boolean payPalPreferred = false;

    public GetItemTransactionsCall() {
    }

    public GetItemTransactionsCall(ApiContext apiContext) {
        super(apiContext);
    }

    public TransactionType[] getItemTransactions() throws ApiException, SdkException, Exception {
        GetItemTransactionsRequestType req = new GetItemTransactionsRequestType();
        if (this.itemID == null) {
            throw new SdkException("ItemID property is not set.");
        }
        if (this.modifiedTimeFilter == null) {
            throw new SdkException("ModifiedTimeFilter property is not set.");
        }
        req.setDetailLevel(this.getDetailLevel());
        if (this.itemID != null) {
            req.setItemID(this.itemID);
        }
        if (this.modifiedTimeFilter != null) {
            req.setModTimeFrom(this.modifiedTimeFilter.getTimeFrom());
            req.setModTimeTo(this.modifiedTimeFilter.getTimeTo());
        }
        if (this.transactionID != null) {
            req.setTransactionID(this.transactionID);
        }
        if (this.pagination != null) {
            req.setPagination(this.pagination);
        }
        if (this.includeFinalValueFee != null) {
            req.setIncludeFinalValueFee(this.includeFinalValueFee);
        }
        if (this.includeContainingOrder != null) {
            req.setIncludeContainingOrder(this.includeContainingOrder);
        }
        if (this.platform != null) {
            req.setPlatform(this.platform);
        }
        if (this.numberOfDays != null) {
            req.setNumberOfDays(this.numberOfDays);
        }
        if (this.includeVariations != null) {
            req.setIncludeVariations(this.includeVariations);
        }
        GetItemTransactionsResponseType resp = (GetItemTransactionsResponseType)this.execute((AbstractRequestType)req);
        this.paginationResult = resp.getPaginationResult();
        this.hasMoreTransactions = resp.isHasMoreTransactions() == null ? false : resp.isHasMoreTransactions();
        this.returnedTransactionsPerPage = resp.getTransactionsPerPage();
        this.returnedPageNumber = resp.getPageNumber();
        this.returnedTransactionCountActual = resp.getReturnedTransactionCountActual() == null ? 0 : resp.getReturnedTransactionCountActual();
        this.item = resp.getItem();
        this.returnedTransactions = resp.getTransactionArray() == null ? null : resp.getTransactionArray().getTransaction();
        this.payPalPreferred = resp.isPayPalPreferred() == null ? false : resp.isPayPalPreferred();
        return this.getReturnedTransactions();
    }

    public Boolean getIncludeContainingOrder() {
        return this.includeContainingOrder;
    }

    public void setIncludeContainingOrder(Boolean includeContainingOrder) {
        this.includeContainingOrder = includeContainingOrder;
    }

    public Boolean getIncludeFinalValueFee() {
        return this.includeFinalValueFee;
    }

    public void setIncludeFinalValueFee(Boolean includeFinalValueFee) {
        this.includeFinalValueFee = includeFinalValueFee;
    }

    public Boolean getIncludeVariations() {
        return this.includeVariations;
    }

    public void setIncludeVariations(Boolean includeVariations) {
        this.includeVariations = includeVariations;
    }

    public String getItemID() {
        return this.itemID;
    }

    public void setItemID(String itemID) {
        this.itemID = itemID;
    }

    public TimeFilter getModifiedTimeFilter() {
        return this.modifiedTimeFilter;
    }

    public void setModifiedTimeFilter(TimeFilter modifiedTimeFilter) {
        this.modifiedTimeFilter = modifiedTimeFilter;
    }

    public Integer getNumberOfDays() {
        return this.numberOfDays;
    }

    public void setNumberOfDays(Integer numberOfDays) {
        this.numberOfDays = numberOfDays;
    }

    public PaginationType getPagination() {
        return this.pagination;
    }

    public void setPagination(PaginationType pagination) {
        this.pagination = pagination;
    }

    public TransactionPlatformCodeType getPlatform() {
        return this.platform;
    }

    public void setPlatform(TransactionPlatformCodeType platform) {
        this.platform = platform;
    }

    public String getTransactionID() {
        return this.transactionID;
    }

    public void setTransactionID(String transactionID) {
        this.transactionID = transactionID;
    }

    public TransactionType[] getEntireItemTransactions() throws ApiException, SdkException, Exception {
        if (this.itemID == null) {
            throw new SdkException("ItemID is not set.");
        }
        if (this.modifiedTimeFilter == null) {
            throw new SdkException("ModifiedTimeFilter is not set.");
        }
        return this.getEntireItemTransactions();
    }

    public TransactionType[] getItemTransactions(String itemID, TimeFilter modifiedTimeFilter) throws ApiException, SdkException, Exception {
        GetItemTransactionsResponseType resp;
        GetItemTransactionsRequestType req = new GetItemTransactionsRequestType();
        req.setItemID(itemID);
        req.setModTimeFrom(modifiedTimeFilter.getTimeFrom());
        req.setModTimeTo(modifiedTimeFilter.getTimeTo());
        if (null != this.includeContainingOrder) {
            req.setIncludeContainingOrder(this.includeContainingOrder);
        }
        if (null != this.includeFinalValueFee) {
            req.setIncludeFinalValueFee(this.includeFinalValueFee);
        }
        if (this.pagination != null) {
            req.setPagination(this.pagination);
        }
        if (this.transactionID != null && this.transactionID.length() > 0) {
            req.setTransactionID(this.transactionID);
        }
        this.returnedTransactions = (resp = (GetItemTransactionsResponseType)this.execute((AbstractRequestType)req)).getTransactionArray() == null ? null : resp.getTransactionArray().getTransaction();
        this.paginationResult = resp.getPaginationResult();
        this.item = resp.getItem();
        if (resp.isHasMoreTransactions() != null) {
            this.hasMoreTransactions = resp.isHasMoreTransactions();
        }
        if (resp.isPayPalPreferred() != null) {
            this.payPalPreferred = resp.isPayPalPreferred();
        }
        if (resp.getReturnedTransactionCountActual() != null) {
            this.returnedTransactionCountActual = resp.getReturnedTransactionCountActual();
        }
        if (this.pagination == null) {
            this.pagination = new PaginationType();
        }
        if (resp.getTransactionsPerPage() != null) {
            this.pagination.setEntriesPerPage(resp.getTransactionsPerPage());
        }
        if (resp.getPageNumber() != null) {
            this.pagination.setPageNumber(resp.getPageNumber());
        }
        return this.returnedTransactions;
    }

    public void setIncludeFinalValueFe(Boolean includeFinalValueFee) {
        this.includeFinalValueFee = includeFinalValueFee;
    }

    public boolean getHasMoreTransactions() {
        return this.hasMoreTransactions;
    }

    public ItemType getItem() {
        return this.item;
    }

    public PaginationResultType getPaginationResult() {
        return this.paginationResult;
    }

    public boolean getPayPalPreferred() {
        return this.payPalPreferred;
    }

    public Integer getReturnedPageNumber() {
        return this.returnedPageNumber;
    }

    public int getReturnedTransactionCountActual() {
        return this.returnedTransactionCountActual;
    }

    public TransactionType[] getReturnedTransactions() {
        return this.returnedTransactions;
    }

    public Integer getReturnedTransactionsPerPage() {
        return this.returnedTransactionsPerPage;
    }
}

