/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.util.XPathUtil;
import com.ebay.sdk.util.XmlUtil;
import com.ebay.sdk.util.eBayUtil;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.GetAttributesCSRequestType;
import com.ebay.soap.eBLBaseComponents.GetAttributesCSResponseType;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GetAttributesCSCall
extends ApiCall {
    private String attributeSystemVersion = null;
    private int[] attributeSetIDs = null;
    private Boolean includeCategoryMappingDetails = null;
    private String returnedattributeSystemVersion = null;
    private String attributeData = null;
    static final String XmlDeclaration = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
    static final String eBay_Start = "<eBay>";
    static final String eBay_End = "</eBay>";
    private String styleXsl = "";
    public static final String OverridesName = "API.XSL.Overrides";
    public static final String GlobalSettingsName = "GlobalSettings";
    public static final String SELECT_AS = "//Attributes/AttributeSet[@id=\"{0}\"]";
    public static final String SELECT_CS = "//Characteristics/CharacteristicsSet[@id=\"{0}\"]";
    public static final String SELECT_OVERRIDES = "//API.XSL.Overrides";
    public static final String SELECT_VERSION = "//Version";
    public static final String SELECT_GLOBALSETTINGS = "//GlobalSettings";

    public GetAttributesCSCall() {
    }

    public GetAttributesCSCall(ApiContext apiContext) {
        super(apiContext);
    }

    public String getAttributesCS() throws ApiException, SdkException, Exception {
        GetAttributesCSRequestType request = new GetAttributesCSRequestType();
        if (this.attributeSetIDs != null) {
            request.setAttributeSetID(this.attributeSetIDs);
        }
        if (this.attributeSystemVersion != null) {
            request.setAttributeSystemVersion(this.attributeSystemVersion);
        }
        if (this.includeCategoryMappingDetails != null) {
            request.setIncludeCategoryMappingDetails(this.includeCategoryMappingDetails);
        }
        GetAttributesCSResponseType resp = (GetAttributesCSResponseType)this.execute((AbstractRequestType)request);
        this.returnedattributeSystemVersion = resp.getAttributeSystemVersion();
        String csXml = null;
        if (resp.getAttributeData() != null) {
            csXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\n" + resp.getAttributeData();
        }
        if (csXml != null && this.styleXsl != null) {
            String styleXslToUse = this.styleXsl == null || this.styleXsl.length() == 0 ? GetAttributesCSCall.getDefaultStyleXsl() : this.styleXsl;
            csXml = GetAttributesCSCall.fixAttributesXml(csXml, styleXslToUse);
        }
        return csXml;
    }

    public int[] getAttributeSetIDs() {
        return this.attributeSetIDs;
    }

    public void setAttributeSetIDs(int[] attributeSetIDs) {
        this.attributeSetIDs = attributeSetIDs;
    }

    public String getAttributeSystemVersion() {
        return this.attributeSystemVersion;
    }

    public void setAttributeSystemVersion(String attributeSystemVersion) {
        this.attributeSystemVersion = attributeSystemVersion;
    }

    public Boolean getIncludeCategoryMappingDetails() {
        return this.includeCategoryMappingDetails;
    }

    public void setIncludeCategoryMappingDetails(Boolean includeCategoryMappingDetails) {
        this.includeCategoryMappingDetails = includeCategoryMappingDetails;
    }

    public static Document extractCSFromXml(Document allCSXml, int csId, boolean copyOverrides, String fromPath, Document outputXml) throws TransformerException, ParserConfigurationException, SAXException, IOException, SdkException {
        int[] csIds = null;
        if (csId != 0) {
            csIds = new int[]{csId};
        }
        return GetAttributesCSCall.extractMultiCSFromXml(allCSXml, csIds, copyOverrides, fromPath, outputXml);
    }

    public static Document extractMultiCSFromXml(Document allCSXml, int[] csIds, boolean copyOverrides, String fromPath, Document outputXml) throws TransformerException, ParserConfigurationException, SAXException, IOException, SdkException {
        Document retXml = null;
        if (csIds == null || csIds.length == 0) {
            retXml = allCSXml;
        } else {
            Node fromNode;
            Node oldNode;
            Node verNode;
            Node csNode;
            retXml = outputXml == null ? XmlUtil.createDom((String)"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\n<eBay>\n</eBay>") : outputXml;
            Node eBayNode = XmlUtil.getChildByName((Node)retXml, (String)"eBay");
            Node asNode = XmlUtil.getChildByName((Node)eBayNode, (String)"Attributes");
            if (asNode == null) {
                asNode = XmlUtil.appendChildNode((Document)retXml, (Node)eBayNode, (String)"Attributes");
            }
            if ((csNode = XmlUtil.getChildByName((Node)eBayNode, (String)"Characteristics")) == null) {
                csNode = XmlUtil.appendChildNode((Document)retXml, (Node)eBayNode, (String)"Characteristics");
            }
            if ((verNode = XPathUtil.selectSingleNode((String)(fromPath + SELECT_VERSION), (Node)allCSXml)) != null && (oldNode = XmlUtil.getChildByName((Node)eBayNode, (String)"Version")) == null) {
                eBayNode.appendChild(retXml.importNode(verNode, true));
            }
            for (int i = 0; i < csIds.length; ++i) {
                int csId = csIds[i];
                String xp = MessageFormat.format(fromPath + SELECT_AS, String.valueOf(csId));
                fromNode = XPathUtil.selectSingleNode((String)xp, (Node)allCSXml);
                if (fromNode == null) {
                    String expMsg = "extractMultiCSFromXml: Unable to find source Attributes node the given CSId: " + csId + ".\r\n";
                    expMsg = expMsg + "There is error in the attributes meta-data, please check if the category is \r\n";
                    expMsg = expMsg + "item specifics enabled(using GetCategoryFeatures) and use eBay item specifics related API instead.\r\n";
                    expMsg = expMsg + "You may also contact eBay and report the error.";
                    throw new SdkException(expMsg);
                }
                asNode.appendChild(retXml.importNode(fromNode, true));
                xp = MessageFormat.format(fromPath + SELECT_CS, String.valueOf(csId));
                fromNode = XPathUtil.selectSingleNode((String)xp, (Node)allCSXml);
                if (fromNode == null) {
                    throw new SdkException("extractMultiCSFromXml: Unable to find source Characteristics node the given CSId: " + csId);
                }
                csNode.appendChild(retXml.importNode(fromNode, true));
            }
            if (copyOverrides) {
                Node oldNode2;
                fromNode = XPathUtil.selectSingleNode((String)(fromPath + SELECT_OVERRIDES), (Node)allCSXml);
                if (fromNode != null && (oldNode2 = XmlUtil.getChildByName((Node)eBayNode, (String)OverridesName)) == null) {
                    eBayNode.appendChild(retXml.importNode(fromNode, true));
                }
                if ((fromNode = XPathUtil.selectSingleNode((String)(fromPath + SELECT_GLOBALSETTINGS), (Node)allCSXml)) != null && (oldNode = XmlUtil.getChildByName((Node)eBayNode, (String)GlobalSettingsName)) == null) {
                    eBayNode.appendChild(retXml.importNode(fromNode, true));
                }
            }
        }
        return retXml;
    }

    public static String fixAttributesXml(String attrXmlDoc, String styleXsl) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        String fixed = null;
        try {
            Document srcDoc = XmlUtil.createDom((String)attrXmlDoc);
            Document srcXslDoc = XmlUtil.createDom((String)styleXsl);
            fixed = XmlUtil.xslTransform((Document)srcDoc, (Document)srcXslDoc);
        }
        catch (Exception ex) {
            String t = "";
        }
        return fixed;
    }

    public static String getDefaultStyleXsl() throws IOException {
        InputStream strm = GetAttributesCSCall.class.getResourceAsStream("Attributes_Style.xsl");
        return eBayUtil.convertInputStreamToString((InputStream)strm);
    }

    public String getStyleXsl() {
        return this.styleXsl;
    }

    public void setStyleXsl(String styleXsl) {
        this.styleXsl = styleXsl;
    }

    public String getAttributeData() {
        return this.attributeData;
    }

    public String getReturnedattributeSystemVersion() {
        return this.returnedattributeSystemVersion;
    }
}

