/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.AddSecondChanceItemRequestType;
import com.ebay.soap.eBLBaseComponents.AddSecondChanceItemResponseType;
import com.ebay.soap.eBLBaseComponents.AmountType;
import com.ebay.soap.eBLBaseComponents.SecondChanceOfferDurationCodeType;
import com.ebay.soap.eBLBaseComponents.VerifyAddSecondChanceItemRequestType;
import com.ebay.soap.eBLBaseComponents.VerifyAddSecondChanceItemResponseType;
import java.util.Calendar;

public class AddSecondChanceItemCall
extends ApiCall {
    private String recipientBidderUserID = null;
    private AmountType buyItNowPrice = null;
    private SecondChanceOfferDurationCodeType duration = null;
    private String itemID = null;
    private String sellerMessage = null;
    private String returnedItemID = null;
    private Calendar returnedStartTime = null;
    private Calendar returnedEndTime = null;

    public AddSecondChanceItemCall() {
    }

    public AddSecondChanceItemCall(ApiContext apiContext) {
        super(apiContext);
    }

    public String addSecondChanceItem() throws ApiException, SdkException, Exception {
        AddSecondChanceItemRequestType req = new AddSecondChanceItemRequestType();
        if (this.recipientBidderUserID == null) {
            throw new SdkException("RecipientBidderUserID property is not set.");
        }
        if (this.itemID == null) {
            throw new SdkException("ItemID should be set to the original item ID that you want to make an offer for.");
        }
        if (this.recipientBidderUserID != null) {
            req.setRecipientBidderUserID(this.recipientBidderUserID);
        }
        if (this.buyItNowPrice != null) {
            req.setBuyItNowPrice(this.buyItNowPrice);
        }
        if (this.duration != null) {
            req.setDuration(this.duration);
        }
        if (this.itemID != null) {
            req.setItemID(this.itemID);
        }
        if (this.sellerMessage != null) {
            req.setSellerMessage(this.sellerMessage);
        }
        AddSecondChanceItemResponseType resp = (AddSecondChanceItemResponseType)this.execute((AbstractRequestType)req);
        this.returnedItemID = resp.getItemID();
        this.returnedStartTime = resp.getStartTime();
        this.returnedEndTime = resp.getEndTime();
        return this.getReturnedItemID();
    }

    public AmountType getBuyItNowPrice() {
        return this.buyItNowPrice;
    }

    public void setBuyItNowPrice(AmountType buyItNowPrice) {
        this.buyItNowPrice = buyItNowPrice;
    }

    public SecondChanceOfferDurationCodeType getDuration() {
        return this.duration;
    }

    public void setDuration(SecondChanceOfferDurationCodeType duration) {
        this.duration = duration;
    }

    public String getItemID() {
        return this.itemID;
    }

    public void setItemID(String itemID) {
        this.itemID = itemID;
    }

    public String getRecipientBidderUserID() {
        return this.recipientBidderUserID;
    }

    public void setRecipientBidderUserID(String recipientBidderUserID) {
        this.recipientBidderUserID = recipientBidderUserID;
    }

    public String getSellerMessage() {
        return this.sellerMessage;
    }

    public void setSellerMessage(String sellerMessage) {
        this.sellerMessage = sellerMessage;
    }

    public void verifyAddSecondChanceItem() throws ApiException, SdkException, Exception {
        VerifyAddSecondChanceItemRequestType req = new VerifyAddSecondChanceItemRequestType();
        if (this.recipientBidderUserID == null) {
            throw new SdkException("RecipientBidderUserID is not set.");
        }
        req.setRecipientBidderUserID(this.recipientBidderUserID);
        if (this.itemID == null) {
            throw new SdkException("ItemID should be set to the original item ID that you want to make offer for.");
        }
        req.setItemID(this.itemID);
        if (null != this.sellerMessage) {
            req.setSellerMessage(this.sellerMessage);
        }
        if (this.buyItNowPrice != null) {
            req.setBuyItNowPrice(this.buyItNowPrice);
        }
        if (this.duration != null) {
            req.setDuration(this.duration);
        }
        VerifyAddSecondChanceItemResponseType resp = (VerifyAddSecondChanceItemResponseType)this.execute((AbstractRequestType)req);
    }

    public Calendar getReturnedEndTime() {
        return this.returnedEndTime;
    }

    public String getReturnedItemID() {
        return this.returnedItemID;
    }

    public Calendar getReturnedStartTime() {
        return this.returnedStartTime;
    }
}

