/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javolution.Javolution;
import javolution.context.PersistentContext;
import javolution.lang.ClassInitializer;
import javolution.lang.Configurable;
import javolution.lang.Reflection;
import javolution.text.CharArray;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.text.TextFormat;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.util.Index;
import javolution.xml.QName;
import javolution.xml.XMLBinding;
import javolution.xml.XMLReferenceResolver;
import javolution.xml.sax.Attributes;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReader;
import javolution.xml.stream.XMLStreamReaderImpl;
import javolution.xml.stream.XMLStreamWriter;
import javolution.xml.stream.XMLStreamWriterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLFormat<T> {
    private static final String NULL = "Null";
    private static final FastMap CLASS_TO_FORMAT = new FastMap().setShared(true);
    private final Class<T> _class;
    protected static final XMLFormat<Object> OBJECT_XML = new XMLFormat(Object.class){

        public void read(InputElement xml, Object obj) {
        }

        public void write(Object obj, OutputElement xml) {
        }
    };
    protected static final XMLFormat<Class> CLASS_XML = new XMLFormat(Class.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            CharArray name = xml.getAttribute("name");
            if (name == null) {
                throw new XMLStreamException("Attribute 'name' missing");
            }
            Class clazz = Reflection.getInstance().getClass(name);
            if (clazz == null) {
                throw new XMLStreamException("Class " + clazz + " not found (see javolution.lang.Reflection)");
            }
            return clazz;
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            xml.setAttribute("name", ((Class)obj).getName());
        }
    };
    protected static final XMLFormat<String> STRING_XML = new XMLFormat(String.class){

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            return xml.getAttribute("value", "");
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (String)obj);
        }
    };
    protected static final XMLFormat<Appendable> APPENDABLE_XML = new XMLFormat(Appendable.class){

        public void read(InputElement xml, Object obj) throws XMLStreamException {
            CharArray csq = xml.getAttribute("value");
            if (csq != null) {
                try {
                    ((Appendable)obj).append(csq);
                }
                catch (IOException e) {
                    throw new XMLStreamException(e);
                }
            }
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            if (obj instanceof CharSequence) {
                xml.setAttribute("value", (CharSequence)obj);
            } else {
                xml.setAttribute("value", obj.toString());
            }
        }
    };
    protected static final XMLFormat<Collection> COLLECTION_XML = new XMLFormat(Collection.class){

        public void read(InputElement xml, Object obj) throws XMLStreamException {
            Collection collection = (Collection)obj;
            while (xml.hasNext()) {
                collection.add(xml.getNext());
            }
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            Collection collection = (Collection)obj;
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                xml.add(i.next());
            }
        }
    };
    protected static final XMLFormat<Map> MAP_XML = new XMLFormat(Map.class){

        public void read(InputElement xml, Object obj) throws XMLStreamException {
            Map map = (Map)obj;
            while (xml.hasNext()) {
                Object key = xml.get("Key");
                Object value = xml.get("Value");
                map.put(key, value);
            }
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                xml.add(entry.getKey(), "Key");
                xml.add(entry.getValue(), "Value");
            }
        }
    };
    protected static final XMLFormat<Object[]> OBJECT_ARRAY_XML = new XMLFormat((Class)new Object[0].getClass()){

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            Class<?> componentType = cls.getComponentType();
            int length = xml.getAttribute("length", 0);
            return Array.newInstance(componentType, length);
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
            Object[] array = (Object[])obj;
            for (int i = 0; i < array.length; ++i) {
                array[i] = xml.getNext();
            }
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            Object[] array = (Object[])obj;
            xml.setAttribute("length", array.length);
            for (int i = 0; i < array.length; ++i) {
                xml.add(array[i]);
            }
        }
    };
    protected static final XMLFormat<Boolean> BOOLEAN_XML = new XMLFormat(Boolean.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            return xml.getAttribute("value", false) ? Boolean.TRUE : Boolean.FALSE;
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Boolean)obj);
        }
    };
    protected static final XMLFormat<Byte> BYTE_XML = new XMLFormat(Byte.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            return new Byte((byte)xml.getAttribute("value", 0));
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Byte)obj);
        }
    };
    protected static final XMLFormat<Character> CHARACTER_XML = new XMLFormat(Character.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            CharArray csq = xml.getAttribute("value");
            if (csq == null || csq.length() != 1) {
                throw new XMLStreamException("Missing or invalid value attribute");
            }
            return new Character(csq.charAt(0));
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", Text.valueOf(((Character)obj).charValue()));
        }
    };
    protected static final XMLFormat<Short> SHORT_XML = new XMLFormat(Short.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            return new Short((short)xml.getAttribute("value", 0));
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Short)obj);
        }
    };
    protected static final XMLFormat<Integer> INTEGER_XML = new XMLFormat(Integer.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            return new Integer(xml.getAttribute("value", 0));
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Integer)obj);
        }
    };
    protected static final XMLFormat<Long> LONG_XML = new XMLFormat(Long.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            return new Long(xml.getAttribute("value", 0L));
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Long)obj);
        }
    };
    protected static final XMLFormat<Float> FLOAT_XML = new XMLFormat(Float.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            return new Float(xml.getAttribute("value", 0.0f));
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", ((Float)obj).floatValue());
        }
    };
    protected static final XMLFormat<Double> DOUBLE_XML = new XMLFormat(Double.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            return new Double(xml.getAttribute("value", 0.0));
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Double)obj);
        }
    };
    protected static final XMLFormat<Text> TEXT_XML = new XMLFormat(Text.class){

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            CharArray csq = xml.getAttribute("value");
            return csq != null ? Text.valueOf(csq) : Text.EMPTY;
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Text)obj);
        }
    };
    protected static final XMLFormat<FastMap> FAST_MAP_XML = new XMLFormat(FastMap.class){

        public void read(InputElement xml, Object obj) throws XMLStreamException {
            FastComparator valueComparator;
            FastMap fm = (FastMap)obj;
            fm.setShared(xml.getAttribute("shared", false));
            FastComparator keyComparator = (FastComparator)xml.get("KeyComparator");
            if (keyComparator != null) {
                fm.setKeyComparator(keyComparator);
            }
            if ((valueComparator = (FastComparator)xml.get("ValueComparator")) != null) {
                fm.setValueComparator(valueComparator);
            }
            while (xml.hasNext()) {
                Object key = xml.get("Key");
                Object value = xml.get("Value");
                fm.put(key, value);
            }
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            FastMap fm = (FastMap)obj;
            if (fm.isShared()) {
                xml.setAttribute("shared", true);
            }
            if (fm.getKeyComparator() != FastComparator.DEFAULT) {
                xml.add(fm.getKeyComparator(), "KeyComparator");
            }
            if (fm.getValueComparator() != FastComparator.DEFAULT) {
                xml.add(fm.getValueComparator(), "ValueComparator");
            }
            FastCollection.Record e = fm.head();
            FastMap.Entry end = fm.tail();
            while ((e = ((FastMap.Entry)e).getNext()) != end) {
                xml.add(((FastMap.Entry)e).getKey(), "Key");
                xml.add(((FastMap.Entry)e).getValue(), "Value");
            }
        }
    };
    protected static final XMLFormat<FastCollection> FAST_COLLECTION_XML = new XMLFormat(FastCollection.class){

        public void read(InputElement xml, Object obj) throws XMLStreamException {
            FastCollection fc = (FastCollection)obj;
            while (xml.hasNext()) {
                fc.add(xml.getNext());
            }
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            FastCollection fc = (FastCollection)obj;
            FastCollection.Record r = fc.head();
            FastCollection.Record end = fc.tail();
            while ((r = r.getNext()) != end) {
                xml.add(fc.valueOf(r));
            }
        }
    };
    protected static final XMLFormat<FastComparator> FAST_COMPARATOR_XML = new XMLFormat(FastComparator.class){

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            if (cls == FastComparator.DEFAULT.getClass()) {
                return FastComparator.DEFAULT;
            }
            if (cls == FastComparator.DIRECT.getClass()) {
                return FastComparator.DIRECT;
            }
            if (cls == FastComparator.IDENTITY.getClass()) {
                return FastComparator.IDENTITY;
            }
            if (cls == FastComparator.LEXICAL.getClass()) {
                return FastComparator.LEXICAL;
            }
            if (cls == FastComparator.REHASH.getClass()) {
                return FastComparator.REHASH;
            }
            if (cls == FastComparator.STRING.getClass()) {
                return FastComparator.STRING;
            }
            return super.newInstance(cls, xml);
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
        }
    };
    protected static final XMLFormat<Index> INDEX_XML = new XMLFormat(Index.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            return Index.valueOf(xml.getAttribute("value", 0));
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", ((Index)obj).intValue());
        }
    };
    protected static final XMLFormat<PersistentContext> PERSISTENT_CONTEXT_XML = new XMLFormat(PersistentContext.class){

        public void read(InputElement xml, Object obj) throws XMLStreamException {
            PersistentContext ctx = (PersistentContext)obj;
            ctx.getIdToValue().putAll((FastMap)xml.get("References"));
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            PersistentContext ctx = (PersistentContext)obj;
            xml.add(ctx.getIdToValue(), "References");
        }
    };
    protected static final XMLFormat<Configurable> CONFIGURABLE_XML = new XMLFormat(Configurable.class){

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            return Configurable.getInstance(xml.getAttribute("name", ""));
        }

        public void write(Object c, OutputElement xml) throws XMLStreamException {
            Configurable cfg = (Configurable)c;
            xml.setAttribute("name", cfg.getName());
            xml.add(cfg.get(), "Value");
        }

        public void read(InputElement xml, Object c) throws XMLStreamException {
            Object value = xml.get("Value");
            if (value == null) {
                return;
            }
            Configurable.configure((Configurable)c, value);
        }
    };
    protected static final XMLFormat<QName> QNAME_XML = new XMLFormat(QName.class){

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            CharArray namespaceURI = xml.getAttribute("namespaceURI");
            CharArray localName = xml.getAttribute("localName");
            return QName.valueOf(namespaceURI, localName);
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            QName qName = (QName)obj;
            xml.setAttribute("namespaceURI", qName.getNamespaceURI());
            xml.setAttribute("localName", qName.getLocalName());
        }
    };

    protected XMLFormat(Class<T> cls) {
        this._class = cls;
        if (cls == null) {
            return;
        }
        if (CLASS_TO_FORMAT.containsKey(cls)) {
            throw new IllegalArgumentException("Existing static binding for class " + cls + " can only be overriden through custom XMLBinding" + " (see XMLFormat(Class) documentation)");
        }
        CLASS_TO_FORMAT.put(cls, this);
    }

    public static <T> XMLFormat<T> getDefault(Class<? extends T> forClass) {
        XMLFormat format = (XMLFormat)CLASS_TO_FORMAT.get(forClass);
        if (format != null) {
            return format;
        }
        ClassInitializer.initialize(forClass);
        return XMLFormat.searchDefaultFormat(forClass);
    }

    private static XMLFormat searchDefaultFormat(Class forClass) {
        XMLFormat format = (XMLFormat)CLASS_TO_FORMAT.get(forClass);
        if (format != null) {
            return format;
        }
        Class[] interfaces = Reflection.getInstance().getInterfaces(forClass);
        for (int i = 0; i < interfaces.length; ++i) {
            format = (XMLFormat)CLASS_TO_FORMAT.get(interfaces[i]);
            if (format == null) continue;
            return format;
        }
        Class parentClass = Reflection.getInstance().getSuperclass(forClass);
        return parentClass != null ? XMLFormat.searchDefaultFormat(parentClass) : null;
    }

    public final Class<T> getBoundClass() {
        return this._class;
    }

    public boolean isReferenceable() {
        return true;
    }

    public T newInstance(Class<T> cls, InputElement xml) throws XMLStreamException {
        try {
            return cls.newInstance();
        }
        catch (InstantiationException e) {
            throw new XMLStreamException(e);
        }
        catch (IllegalAccessException e) {
            throw new XMLStreamException(e);
        }
    }

    public abstract void write(T var1, OutputElement var2) throws XMLStreamException;

    public abstract void read(InputElement var1, T var2) throws XMLStreamException;

    public String toString() {
        Class<T> boundClass = this.getBoundClass();
        return boundClass != null ? "Default XMLFormat for " + boundClass.getName() : "Dynamic XMLtFormat (" + this.hashCode() + ")";
    }

    private static CharSequence toCsq(Object str) {
        return Javolution.j2meToCharSeq(str);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OutputElement {
        final XMLStreamWriterImpl _writer = new XMLStreamWriterImpl();
        private XMLBinding _binding;
        private XMLReferenceResolver _referenceResolver;
        private TextBuilder _tmpTextBuilder = new TextBuilder();

        OutputElement() {
            this.reset();
        }

        public XMLStreamWriter getStreamWriter() {
            return this._writer;
        }

        public void add(Object obj) throws XMLStreamException {
            if (obj == null) {
                this._writer.writeEmptyElement(XMLFormat.toCsq(XMLFormat.NULL));
                return;
            }
            Class<?> cls = obj.getClass();
            this._binding.writeClass(obj.getClass(), this._writer, false);
            XMLFormat xmlFormat = this._binding.getFormat(cls);
            if (xmlFormat.isReferenceable() && this.writeReference(obj)) {
                return;
            }
            xmlFormat.write(obj, this);
            this._writer.writeEndElement();
        }

        public void add(Object obj, String name) throws XMLStreamException {
            if (obj == null) {
                return;
            }
            this._writer.writeStartElement(XMLFormat.toCsq(name));
            Class<?> cls = obj.getClass();
            this._binding.writeClass(cls, this._writer, true);
            XMLFormat xmlFormat = this._binding.getFormat(cls);
            if (xmlFormat.isReferenceable() && this.writeReference(obj)) {
                return;
            }
            xmlFormat.write(obj, this);
            this._writer.writeEndElement();
        }

        public void add(Object obj, String localName, String uri) throws XMLStreamException {
            if (obj == null) {
                return;
            }
            this._writer.writeStartElement(XMLFormat.toCsq(uri), XMLFormat.toCsq(localName));
            Class<?> cls = obj.getClass();
            this._binding.writeClass(cls, this._writer, true);
            XMLFormat xmlFormat = this._binding.getFormat(cls);
            if (xmlFormat.isReferenceable() && this.writeReference(obj)) {
                return;
            }
            xmlFormat.write(obj, this);
            this._writer.writeEndElement();
        }

        public <T> void add(T obj, String name, Class<T> cls) throws XMLStreamException {
            if (obj == null) {
                return;
            }
            this._writer.writeStartElement(XMLFormat.toCsq(name));
            XMLFormat xmlFormat = this._binding.getFormat(cls);
            if (xmlFormat.isReferenceable() && this.writeReference(obj)) {
                return;
            }
            xmlFormat.write(obj, this);
            this._writer.writeEndElement();
        }

        public <T> void add(T obj, String localName, String uri, Class<T> cls) throws XMLStreamException {
            if (obj == null) {
                return;
            }
            this._writer.writeStartElement(XMLFormat.toCsq(uri), XMLFormat.toCsq(localName));
            XMLFormat xmlFormat = this._binding.getFormat(cls);
            if (xmlFormat.isReferenceable() && this.writeReference(obj)) {
                return;
            }
            xmlFormat.write(obj, this);
            this._writer.writeEndElement();
        }

        private boolean writeReference(Object obj) throws XMLStreamException {
            if (this._referenceResolver == null || !this._referenceResolver.writeReference(obj, this)) {
                return false;
            }
            this._writer.writeEndElement();
            return true;
        }

        public void addText(CharSequence text) throws XMLStreamException {
            this._writer.writeCharacters(text);
        }

        public void addText(String text) throws XMLStreamException {
            this._writer.writeCharacters(XMLFormat.toCsq(text));
        }

        public void setAttribute(String name, CharSequence value) throws XMLStreamException {
            if (value == null) {
                return;
            }
            this._writer.writeAttribute(XMLFormat.toCsq(name), value);
        }

        public void setAttribute(String name, String value) throws XMLStreamException {
            if (value == null) {
                return;
            }
            this._writer.writeAttribute(XMLFormat.toCsq(name), XMLFormat.toCsq(value));
        }

        public void setAttribute(String name, boolean value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, char value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, byte value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, short value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, int value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, long value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, float value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, double value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, Object value) throws XMLStreamException {
            if (value == null) {
                return;
            }
            Class<?> type = value.getClass();
            TextFormat<?> format = TextFormat.getInstance(type);
            if (format == null) {
                throw new XMLStreamException("No TextFormat instance for " + type);
            }
            this.setAttribute(name, (TextBuilder)format.format(value, this._tmpTextBuilder.clear()));
        }

        void setBinding(XMLBinding xmlBinding) {
            this._binding = xmlBinding;
        }

        void setReferenceResolver(XMLReferenceResolver xmlReferenceResolver) {
            this._referenceResolver = xmlReferenceResolver;
        }

        void reset() {
            this._binding = XMLBinding.DEFAULT;
            this._writer.reset();
            this._writer.setRepairingNamespaces(true);
            this._writer.setAutomaticEmptyElements(true);
            this._referenceResolver = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class InputElement {
        final XMLStreamReaderImpl _reader = new XMLStreamReaderImpl();
        private XMLBinding _binding;
        private XMLReferenceResolver _referenceResolver;
        private boolean _isReaderAtNext;

        InputElement() {
            this.reset();
        }

        public XMLStreamReader getStreamReader() {
            return this._reader;
        }

        public boolean hasNext() throws XMLStreamException {
            if (!this._isReaderAtNext) {
                this._isReaderAtNext = true;
                this._reader.nextTag();
            }
            return this._reader.getEventType() == 1;
        }

        public <T> T getNext() throws XMLStreamException {
            if (!this.hasNext()) {
                throw new XMLStreamException("No more element to read", this._reader.getLocation());
            }
            if (this._reader.getLocalName().equals(XMLFormat.NULL)) {
                if (this._reader.next() != 2) {
                    throw new XMLStreamException("Non Empty Null Element");
                }
                this._isReaderAtNext = false;
                return null;
            }
            Object ref = this.readReference();
            if (ref != null) {
                return (T)ref;
            }
            Class cls = this._binding.readClass(this._reader, false);
            return (T)this.readInstanceOf(cls);
        }

        public <T> T get(String name) throws XMLStreamException {
            if (!this.hasNext() || !this._reader.getLocalName().equals(name)) {
                return null;
            }
            Object ref = this.readReference();
            if (ref != null) {
                return (T)ref;
            }
            Class cls = this._binding.readClass(this._reader, true);
            return (T)this.readInstanceOf(cls);
        }

        public <T> T get(String localName, String uri) throws XMLStreamException {
            if (uri == null) {
                return this.get(localName);
            }
            if (!(this.hasNext() && this._reader.getLocalName().equals(localName) && this._reader.getNamespaceURI().equals(uri))) {
                return null;
            }
            Object ref = this.readReference();
            if (ref != null) {
                return (T)ref;
            }
            Class cls = this._binding.readClass(this._reader, true);
            return (T)this.readInstanceOf(cls);
        }

        public <T> T get(String name, Class<T> cls) throws XMLStreamException {
            if (!this.hasNext() || !this._reader.getLocalName().equals(name)) {
                return null;
            }
            Object ref = this.readReference();
            if (ref != null) {
                return (T)ref;
            }
            return (T)this.readInstanceOf(cls);
        }

        public <T> T get(String localName, String uri, Class<T> cls) throws XMLStreamException {
            if (uri == null) {
                return this.get(localName, cls);
            }
            if (!(this.hasNext() && this._reader.getLocalName().equals(localName) && this._reader.getNamespaceURI().equals(uri))) {
                return null;
            }
            Object ref = this.readReference();
            if (ref != null) {
                return (T)ref;
            }
            return (T)this.readInstanceOf(cls);
        }

        private Object readReference() throws XMLStreamException {
            if (this._referenceResolver == null) {
                return null;
            }
            Object ref = this._referenceResolver.readReference(this);
            if (ref == null) {
                return null;
            }
            if (this._reader.next() != 2) {
                throw new XMLStreamException("Non Empty Reference Element");
            }
            this._isReaderAtNext = false;
            return ref;
        }

        private Object readInstanceOf(Class cls) throws XMLStreamException {
            XMLFormat xmlFormat = this._binding.getFormat(cls);
            this._isReaderAtNext = false;
            Object obj = xmlFormat.newInstance(cls, this);
            if (this._referenceResolver != null) {
                this._referenceResolver.createReference(obj, this);
            }
            xmlFormat.read(this, obj);
            if (this.hasNext()) {
                throw new XMLStreamException("Incomplete element reading", this._reader.getLocation());
            }
            this._isReaderAtNext = false;
            return obj;
        }

        public CharArray getText() throws XMLStreamException {
            CharArray txt = this._reader.getElementText();
            this._isReaderAtNext = true;
            return txt;
        }

        public Attributes getAttributes() throws XMLStreamException {
            if (this._isReaderAtNext) {
                throw new XMLStreamException("Attributes should be read before content");
            }
            return this._reader.getAttributes();
        }

        public CharArray getAttribute(String name) throws XMLStreamException {
            if (this._isReaderAtNext) {
                throw new XMLStreamException("Attributes should be read before reading content");
            }
            return this._reader.getAttributeValue(null, XMLFormat.toCsq(name));
        }

        public String getAttribute(String name, String defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? value.toString() : defaultValue;
        }

        public boolean getAttribute(String name, boolean defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? value.toBoolean() : defaultValue;
        }

        public char getAttribute(String name, char defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            if (value == null) {
                return defaultValue;
            }
            if (value.length() != 1) {
                throw new XMLStreamException("Single character expected (read '" + value + "')");
            }
            return value.charAt(0);
        }

        public byte getAttribute(String name, byte defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? (byte)value.toInt() : defaultValue;
        }

        public short getAttribute(String name, short defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? (short)value.toInt() : defaultValue;
        }

        public int getAttribute(String name, int defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? value.toInt() : defaultValue;
        }

        public long getAttribute(String name, long defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? value.toLong() : defaultValue;
        }

        public float getAttribute(String name, float defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? value.toFloat() : defaultValue;
        }

        public double getAttribute(String name, double defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? value.toDouble() : defaultValue;
        }

        public <T> T getAttribute(String name, T defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            if (value == null) {
                return defaultValue;
            }
            Class<?> type = defaultValue.getClass();
            TextFormat<?> format = TextFormat.getInstance(type);
            if (format == null) {
                throw new XMLStreamException("No TextFormat instance for " + type);
            }
            return (T)format.parse(value);
        }

        void setBinding(XMLBinding xmlBinding) {
            this._binding = xmlBinding;
        }

        void setReferenceResolver(XMLReferenceResolver xmlReferenceResolver) {
            this._referenceResolver = xmlReferenceResolver;
        }

        void reset() {
            this._binding = XMLBinding.DEFAULT;
            this._isReaderAtNext = false;
            this._reader.reset();
            this._referenceResolver = null;
        }
    }
}

