/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import javolution.Javolution;
import javolution.lang.Reflection;
import javolution.lang.Reusable;
import javolution.util.FastMap;
import javolution.xml.QName;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReader;
import javolution.xml.stream.XMLStreamWriter;

public class XMLBinding
implements Reusable,
XMLSerializable {
    static final XMLBinding DEFAULT = new XMLBinding();
    private QName _classAttribute = QName.valueOf("class");
    private final FastMap _classToAlias = new FastMap();
    private final FastMap _aliasToClass = new FastMap();

    public void setAlias(Class cls, QName qName) {
        this._classToAlias.put(cls, qName);
        this._aliasToClass.put(qName, cls);
    }

    public final void setAlias(Class cls, String alias) {
        this.setAlias(cls, QName.valueOf(alias));
    }

    public void setClassAttribute(QName classAttribute) {
        this._classAttribute = classAttribute;
    }

    public final void setClassAttribute(String name) {
        this.setClassAttribute(name == null ? null : QName.valueOf(name));
    }

    protected XMLFormat getFormat(Class forClass) throws XMLStreamException {
        XMLFormat xmlFormat = XMLFormat.getDefault(forClass);
        if (xmlFormat == null) {
            throw new XMLStreamException("No XML format found for " + forClass);
        }
        return xmlFormat;
    }

    protected Class readClass(XMLStreamReader reader, boolean useAttributes) throws XMLStreamException {
        Class cls;
        QName classQName;
        if (useAttributes) {
            if (this._classAttribute == null) {
                throw new XMLStreamException("Binding has no class attribute defined, cannot retrieve class");
            }
            classQName = QName.valueOf(reader.getAttributeValue(this._classAttribute.getNamespaceURI(), this._classAttribute.getLocalName()));
            if (classQName == null) {
                throw new XMLStreamException("Cannot retrieve class (class attribute not found)");
            }
        } else {
            classQName = QName.valueOf(reader.getNamespaceURI(), reader.getLocalName());
        }
        if ((cls = (Class)this._aliasToClass.get(classQName)) != null) {
            return cls;
        }
        cls = (Class)this._aliasToClass.get(QName.valueOf(classQName.getLocalName()));
        if (cls != null) {
            return cls;
        }
        cls = Reflection.getInstance().getClass(classQName.getLocalName());
        if (cls == null) {
            throw new XMLStreamException("Class " + classQName.getLocalName() + " not found (see javolution.lang.Reflection to support additional class loader)");
        }
        this._aliasToClass.put(classQName, cls);
        return cls;
    }

    protected void writeClass(Class cls, XMLStreamWriter writer, boolean useAttributes) throws XMLStreamException {
        String name;
        QName qName = (QName)this._classToAlias.get(cls);
        String string = name = qName != null ? qName.toString() : cls.getName();
        if (useAttributes) {
            if (this._classAttribute == null) {
                return;
            }
            if (this._classAttribute.getNamespaceURI() == null) {
                writer.writeAttribute(this._classAttribute.getLocalName(), Javolution.j2meToCharSeq(name));
            } else {
                writer.writeAttribute(this._classAttribute.getNamespaceURI(), this._classAttribute.getLocalName(), Javolution.j2meToCharSeq(name));
            }
        } else if (qName != null) {
            writer.writeStartElement(qName.getNamespaceURI(), qName.getLocalName());
        } else {
            writer.writeStartElement(Javolution.j2meToCharSeq(name));
        }
    }

    public void reset() {
        this._classAttribute = QName.valueOf("class");
        this._aliasToClass.reset();
        this._classToAlias.reset();
    }
}

