/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.realtime.MemoryArea;
import javolution.context.ArrayFactory;
import javolution.context.LogContext;
import javolution.context.ObjectFactory;
import javolution.context.PersistentContext;
import javolution.lang.MathLib;
import javolution.lang.Realtime;
import javolution.lang.Reusable;
import javolution.text.Text;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.xml.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastMap<K, V>
implements Map<K, V>,
Reusable,
XMLSerializable,
Realtime {
    private static final int B0 = 4;
    private static final int C0 = 16;
    private static final int B1 = 10;
    private static final int C1 = 1024;
    private static final int B2 = 6;
    private static final int C2 = 64;
    private transient Entry<K, V> _head;
    private transient Entry<K, V> _tail;
    private transient Entry<K, V>[] _entries;
    private transient int _entryCount;
    private transient int _nullCount;
    private transient FastMap[] _subMaps;
    private transient boolean _useSubMaps;
    private transient int _keyShift;
    private transient Values _values;
    private transient KeySet _keySet;
    private transient EntrySet _entrySet;
    private transient Map<K, V> _unmodifiable;
    private transient FastComparator _keyComparator;
    private transient boolean _isDirectKeyComparator;
    private transient FastComparator _valueComparator;
    private transient boolean _isShared;
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        public Object create() {
            return new FastMap();
        }
    };
    private static final Entry[] NULL_ENTRIES = new Entry[1024];
    static volatile int ONE_VOLATILE = 1;
    private static final long serialVersionUID = 1L;

    public FastMap() {
        this(4);
    }

    public FastMap(String id) {
        this();
        new PersistentContext.Reference(id, this){

            protected void notifyChange() {
                FastMap.this.clear();
                FastMap.this.putAll((FastMap)this.get());
            }
        };
    }

    public FastMap(int capacity) {
        this.setKeyComparator(FastComparator.DEFAULT);
        this.setValueComparator(FastComparator.DEFAULT);
        this.setup(capacity);
    }

    private void setup(int capacity) {
        int tableLength;
        for (tableLength = 16; tableLength < capacity; tableLength <<= 1) {
        }
        this._entries = new Entry[tableLength << 1];
        this._head = this.newEntry();
        this._tail = this.newEntry();
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        Entry<K, V> previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            Entry<K, V> newEntry = this.newEntry();
            ((Entry)newEntry)._previous = (Entry)previous;
            ((Entry)previous)._next = (Entry)newEntry;
            previous = newEntry;
        }
    }

    public FastMap(Map<? extends K, ? extends V> map) {
        this(map.size());
        this.putAll(map);
    }

    private FastMap(Entry[] entries) {
        this._entries = entries;
    }

    public static <K, V> FastMap<K, V> newInstance() {
        return (FastMap)FACTORY.object();
    }

    public static void recycle(FastMap instance) {
        FACTORY.recycle(instance);
    }

    public final FastMap<V, K> reverse() {
        FastMap map = (FastMap)FACTORY.object();
        Entry e = this._head;
        Entry<K, V> n = this._tail;
        while ((e = e._next) != n) {
            map.put(e._value, e._key);
        }
        return map;
    }

    public final Entry<K, V> head() {
        return this._head;
    }

    public final Entry<K, V> tail() {
        return this._tail;
    }

    @Override
    public final int size() {
        if (!this._useSubMaps) {
            return this._entryCount;
        }
        int sum = 0;
        int i = 0;
        while (i < this._subMaps.length) {
            sum += this._subMaps[i++].size();
        }
        return sum;
    }

    @Override
    public final boolean isEmpty() {
        return ((Entry)this._head)._next == this._tail;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public final V get(Object key) {
        Entry<K, V> entry = this.getEntry(key);
        return (V)(entry != null ? ((Entry)entry)._value : null);
    }

    public final Entry<K, V> getEntry(Object key) {
        return this.getEntry(key, this._isDirectKeyComparator ? key.hashCode() : this._keyComparator.hashCodeOf(key));
    }

    private final Entry getEntry(Object key, int keyHash) {
        FastMap map = this.getSubMap(keyHash);
        Entry<K, V>[] entries = map._entries;
        int mask = entries.length - 1;
        int i = keyHash >> map._keyShift;
        Entry<K, V> entry;
        while ((entry = entries[i & mask]) != null) {
            if (key == ((Entry)entry)._key || keyHash == ((Entry)entry)._keyHash && (this._isDirectKeyComparator ? key.equals(((Entry)entry)._key) : this._keyComparator.areEqual(key, ((Entry)entry)._key))) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    private final FastMap getSubMap(int keyHash) {
        return this._useSubMaps ? this._subMaps[keyHash & 0x3F].getSubMap(keyHash >> 6) : this;
    }

    @Override
    public final V put(K key, V value) {
        return (V)this.put(key, value, this._isDirectKeyComparator ? key.hashCode() : this._keyComparator.hashCodeOf(key), this._isShared, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object put(Object key, Object value, int keyHash, boolean concurrent, boolean noReplace, boolean returnEntry) {
        FastMap map = this.getSubMap(keyHash);
        Entry<K, V>[] entries = map._entries;
        int mask = entries.length - 1;
        int slot = -1;
        int i2 = keyHash >> map._keyShift;
        while (true) {
            Entry<K, V> entry;
            if ((entry = entries[i2 & mask]) == null) break;
            if (entry == Entry.NULL) {
                slot = slot < 0 ? i2 & mask : slot;
            } else if (key == ((Entry)entry)._key || keyHash == ((Entry)entry)._keyHash && (this._isDirectKeyComparator ? key.equals(((Entry)entry)._key) : this._keyComparator.areEqual(key, ((Entry)entry)._key))) {
                if (noReplace) {
                    return returnEntry ? entry : ((Entry)entry)._value;
                }
                Object prevValue = ((Entry)entry)._value;
                ((Entry)entry)._value = value;
                return returnEntry ? entry : prevValue;
            }
            ++i2;
        }
        slot = slot < 0 ? i2 & mask : slot;
        if (concurrent) {
            FastMap i2 = this;
            synchronized (i2) {
                return this.put(key, value, keyHash, false, noReplace, returnEntry);
            }
        }
        Entry<K, V> entry = this._tail;
        ((Entry)entry)._key = key;
        ((Entry)entry)._value = value;
        ((Entry)entry)._keyHash = keyHash;
        if (((Entry)entry)._next == null) {
            this.createNewEntries();
        }
        entries[slot] = entry;
        map._entryCount += ONE_VOLATILE;
        this._tail = ((Entry)this._tail)._next;
        if (map._entryCount + map._nullCount > entries.length >> 1) {
            map.resizeTable(this._isShared);
        }
        return returnEntry ? entry : null;
    }

    private void createNewEntries() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                Entry previous = FastMap.this._tail;
                for (int i = 0; i < 8; ++i) {
                    Entry newEntry = FastMap.this.newEntry();
                    newEntry._previous = previous;
                    previous._next = newEntry;
                    previous = newEntry;
                }
            }
        });
    }

    private void resizeTable(final boolean isShared) {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                int nullCount = FastMap.this._nullCount;
                FastMap.this._nullCount = 0;
                if (nullCount > FastMap.this._entryCount) {
                    if (isShared) {
                        Entry[] tmp = new Entry[FastMap.this._entries.length];
                        FastMap.this.copyEntries(FastMap.this._entries, tmp, FastMap.this._entries.length);
                        FastMap.access$802(FastMap.this, tmp);
                    } else {
                        Object[] tmp = ArrayFactory.OBJECTS_FACTORY.array(FastMap.this._entries.length);
                        System.arraycopy(FastMap.this._entries, 0, tmp, 0, FastMap.this._entries.length);
                        FastMap.reset(FastMap.this._entries);
                        FastMap.this.copyEntries(tmp, FastMap.this._entries, FastMap.this._entries.length);
                        FastMap.reset(tmp);
                        ArrayFactory.OBJECTS_FACTORY.recycle(tmp);
                    }
                    return;
                }
                int tableLength = FastMap.this._entries.length << 1;
                if (tableLength <= 1024) {
                    Entry[] tmp = new Entry[tableLength];
                    FastMap.this.copyEntries(FastMap.this._entries, tmp, FastMap.this._entries.length);
                    FastMap.access$802(FastMap.this, tmp);
                    return;
                }
                if (FastMap.this._subMaps == null) {
                    FastMap.access$1102(FastMap.this, FastMap.this.newSubMaps(tableLength >> 5));
                }
                int i = 0;
                while (i < FastMap.this._entries.length) {
                    Entry entry = FastMap.this._entries[i++];
                    if (entry == null || entry == Entry.NULL) continue;
                    FastMap subMap = FastMap.this._subMaps[entry._keyHash >> FastMap.this._keyShift & 0x3F];
                    subMap.mapEntry(entry);
                    if (subMap._entryCount + subMap._nullCount << 1 < subMap._entries.length) continue;
                    LogContext.warning("Unevenly distributed hash code - Degraded Preformance");
                    Entry[] tmp = new Entry[tableLength];
                    FastMap.this.copyEntries(FastMap.this._entries, tmp, FastMap.this._entries.length);
                    FastMap.access$802(FastMap.this, tmp);
                    FastMap.access$1102(FastMap.this, null);
                    return;
                }
                FastMap.this._useSubMaps = ONE_VOLATILE == 1;
            }
        });
    }

    private FastMap[] newSubMaps(int capacity) {
        FastMap[] subMaps = new FastMap[64];
        for (int i = 0; i < 64; ++i) {
            FastMap<K, V> subMap = new FastMap<K, V>(new Entry[capacity]);
            subMap._keyShift = 6 + this._keyShift;
            subMaps[i] = subMap;
        }
        return subMaps;
    }

    private void mapEntry(Entry entry) {
        int mask = this._entries.length - 1;
        int i = entry._keyHash >> this._keyShift;
        while (true) {
            Entry<K, V> e;
            if ((e = this._entries[i & mask]) == null) break;
            ++i;
        }
        this._entries[i & mask] = entry;
        ++this._entryCount;
    }

    private void copyEntries(Object[] from, Entry[] to, int count) {
        int mask = to.length - 1;
        int i = 0;
        block0: while (i < count) {
            Entry entry;
            if ((entry = (Entry)from[i++]) == null || entry == Entry.NULL) continue;
            int j = entry._keyHash >> this._keyShift;
            while (true) {
                Entry tmp;
                if ((tmp = to[j & mask]) == null) {
                    to[j & mask] = entry;
                    continue block0;
                }
                ++j;
            }
        }
    }

    public final Entry<K, V> putEntry(K key, V value) {
        return (Entry)this.put(key, value, this._isDirectKeyComparator ? key.hashCode() : this._keyComparator.hashCodeOf(key), this._isShared, false, true);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public final V putIfAbsent(K key, V value) {
        return (V)this.put(key, value, this._isDirectKeyComparator ? key.hashCode() : this._keyComparator.hashCodeOf(key), this._isShared, true, false);
    }

    @Override
    public final V remove(Object key) {
        return (V)this.remove(key, this._isDirectKeyComparator ? key.hashCode() : this._keyComparator.hashCodeOf(key), this._isShared);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object remove(Object key, int keyHash, boolean concurrent) {
        FastMap map = this.getSubMap(keyHash);
        Entry<K, V>[] entries = map._entries;
        int mask = entries.length - 1;
        int i = keyHash >> map._keyShift;
        Entry<K, V> entry;
        while ((entry = entries[i & mask]) != null) {
            if (key == ((Entry)entry)._key || keyHash == ((Entry)entry)._keyHash && (this._isDirectKeyComparator ? key.equals(((Entry)entry)._key) : this._keyComparator.areEqual(key, ((Entry)entry)._key))) {
                if (concurrent) {
                    FastMap fastMap = this;
                    synchronized (fastMap) {
                        return this.remove(key, keyHash, false);
                    }
                }
                ((Entry)entry)._previous._next = ((Entry)entry)._next;
                ((Entry)entry)._next._previous = ((Entry)entry)._previous;
                entries[i & mask] = Entry.NULL;
                ++map._nullCount;
                --map._entryCount;
                Object prevValue = ((Entry)entry)._value;
                if (!this._isShared) {
                    ((Entry)entry)._key = null;
                    ((Entry)entry)._value = null;
                    Entry next = ((Entry)this._tail)._next;
                    ((Entry)entry)._previous = (Entry)this._tail;
                    ((Entry)entry)._next = next;
                    ((Entry)this._tail)._next = (Entry)entry;
                    if (next != null) {
                        next._previous = (Entry)entry;
                    }
                } else {
                    ((Entry)entry)._next = null;
                }
                return prevValue;
            }
            ++i;
        }
        return null;
    }

    public FastMap<K, V> setShared(boolean isShared) {
        this._isShared = isShared;
        return this;
    }

    public boolean isShared() {
        return this._isShared;
    }

    public FastMap<K, V> setKeyComparator(FastComparator<? super K> keyComparator) {
        this._keyComparator = keyComparator;
        this._isDirectKeyComparator = keyComparator == FastComparator.DIRECT || this._keyComparator == FastComparator.DEFAULT && FastComparator.REHASH_SYSTEM_HASHCODE.get() == false;
        return this;
    }

    public FastComparator<? super K> getKeyComparator() {
        return this._keyComparator;
    }

    public FastMap<K, V> setValueComparator(FastComparator<? super V> valueComparator) {
        this._valueComparator = valueComparator;
        return this;
    }

    public FastComparator<? super V> getValueComparator() {
        return this._valueComparator;
    }

    @Override
    public final void clear() {
        if (this._isShared) {
            this.clearShared();
            return;
        }
        Entry e = this._head;
        Entry<K, V> end = this._tail;
        while ((e = e._next) != end) {
            e._key = null;
            e._value = null;
        }
        this._tail = ((Entry)this._head)._next;
        this.clearTables();
    }

    private void clearTables() {
        if (this._useSubMaps) {
            int i = 0;
            while (i < 64) {
                this._subMaps[i++].clearTables();
            }
            this._useSubMaps = false;
        }
        FastMap.reset(this._entries);
        this._nullCount = 0;
        this._entryCount = 0;
    }

    private synchronized void clearShared() {
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                FastMap.access$802(FastMap.this, new Entry[16]);
                if (FastMap.this._useSubMaps) {
                    FastMap.this._useSubMaps = false;
                    FastMap.access$1102(FastMap.this, FastMap.this.newSubMaps(16));
                }
                FastMap.this._entryCount = 0;
                FastMap.this._nullCount = 0;
            }
        });
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Map) {
            Map that = (Map)obj;
            return ((Object)this.entrySet()).equals(that.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 0;
        Entry e = this._head;
        Entry<K, V> end = this._tail;
        while ((e = e._next) != end) {
            code += e.hashCode();
        }
        return code;
    }

    @Override
    public Text toText() {
        return Text.valueOf(this.entrySet());
    }

    public final String toString() {
        return this.toText().toString();
    }

    protected Entry<K, V> newEntry() {
        return new Entry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStatistics(PrintStream out) {
        long sum = this.getSumDistance();
        int size = this.size();
        int avgDistancePercent = size != 0 ? (int)(100L * sum / (long)size) : 0;
        PrintStream printStream = out;
        synchronized (printStream) {
            out.print("SIZE: " + size);
            out.print(", ENTRIES: " + this.getCapacity());
            out.print(", SLOTS: " + this.getTableLength());
            out.print(", USE SUB-MAPS: " + this._useSubMaps);
            out.print(", SUB-MAPS DEPTH: " + this.getSubMapDepth());
            out.print(", NULL COUNT: " + this._nullCount);
            out.print(", IS SHARED: " + this._isShared);
            out.print(", AVG DISTANCE: " + avgDistancePercent + "%");
            out.print(", MAX DISTANCE: " + this.getMaximumDistance());
            out.println();
        }
    }

    private int getTableLength() {
        if (this._useSubMaps) {
            int sum = 0;
            for (int i = 0; i < 64; ++i) {
                sum += this._subMaps[i].getTableLength();
            }
            return sum;
        }
        return this._entries.length;
    }

    private int getCapacity() {
        int capacity = 0;
        Entry e = this._head;
        while ((e = e._next) != null) {
            ++capacity;
        }
        return capacity - 1;
    }

    private int getMaximumDistance() {
        int max = 0;
        if (this._useSubMaps) {
            for (int i = 0; i < 64; ++i) {
                int subMapMax = this._subMaps[i].getMaximumDistance();
                max = MathLib.max(max, subMapMax);
            }
            return max;
        }
        for (int i = 0; i < this._entries.length; ++i) {
            Entry<K, V> entry = this._entries[i];
            if (entry == null || entry == Entry.NULL) continue;
            int slot = ((Entry)entry)._keyHash >> this._keyShift & this._entries.length - 1;
            int distanceToSlot = i - slot;
            if (distanceToSlot < 0) {
                distanceToSlot += this._entries.length;
            }
            if (distanceToSlot <= max) continue;
            max = distanceToSlot;
        }
        return max;
    }

    private long getSumDistance() {
        long sum = 0L;
        if (this._useSubMaps) {
            for (int i = 0; i < 64; ++i) {
                sum += this._subMaps[i].getSumDistance();
            }
            return sum;
        }
        for (int i = 0; i < this._entries.length; ++i) {
            Entry<K, V> entry = this._entries[i];
            if (entry == null || entry == Entry.NULL) continue;
            int slot = ((Entry)entry)._keyHash >> this._keyShift & this._entries.length - 1;
            int distanceToSlot = i - slot;
            if (distanceToSlot < 0) {
                distanceToSlot += this._entries.length;
            }
            sum += (long)distanceToSlot;
        }
        return sum;
    }

    private int getSubMapDepth() {
        if (this._useSubMaps) {
            int depth = 0;
            for (int i = 0; i < 64; ++i) {
                int subMapDepth = this._subMaps[i].getSubMapDepth();
                depth = MathLib.max(depth, subMapDepth);
            }
            return depth + 1;
        }
        return 0;
    }

    @Override
    public final Collection<V> values() {
        if (this._values == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastMap.this._values = new Values();
                }
            });
        }
        return this._values;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        if (this._entrySet == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastMap.this._entrySet = new EntrySet();
                }
            });
        }
        return this._entrySet;
    }

    @Override
    public final Set<K> keySet() {
        if (this._keySet == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastMap.this._keySet = new KeySet();
                }
            });
        }
        return this._keySet;
    }

    public final Map<K, V> unmodifiable() {
        if (this._unmodifiable == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastMap.this._unmodifiable = new Unmodifiable();
                }
            });
        }
        return this._unmodifiable;
    }

    @Override
    public void reset() {
        this.setShared(false);
        this.clear();
        this.setKeyComparator(FastComparator.DEFAULT);
        this.setValueComparator(FastComparator.DEFAULT);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.setKeyComparator((FastComparator)stream.readObject());
        this.setValueComparator((FastComparator)stream.readObject());
        this.setShared(stream.readBoolean());
        int size = stream.readInt();
        this.setup(size);
        for (int i = 0; i < size; ++i) {
            Object key = stream.readObject();
            Object value = stream.readObject();
            this.put(key, value);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.getKeyComparator());
        stream.writeObject(this.getValueComparator());
        stream.writeBoolean(this._isShared);
        stream.writeInt(this.size());
        Entry e = this._head;
        Entry<K, V> end = this._tail;
        while ((e = e._next) != end) {
            stream.writeObject(e._key);
            stream.writeObject(e._value);
        }
    }

    private static void reset(Object[] entries) {
        int count;
        for (int i = 0; i < entries.length; i += count) {
            count = MathLib.min(entries.length - i, 1024);
            System.arraycopy(NULL_ENTRIES, 0, entries, i, count);
        }
    }

    static /* synthetic */ Entry[] access$802(FastMap x0, Entry[] x1) {
        x0._entries = x1;
        return x1;
    }

    static /* synthetic */ FastMap[] access$1102(FastMap x0, FastMap[] x1) {
        x0._subMaps = x1;
        return x1;
    }

    private final class Unmodifiable
    implements Map,
    Serializable {
        private Unmodifiable() {
        }

        public boolean equals(Object obj) {
            return FastMap.this.equals(obj);
        }

        public int hashCode() {
            return FastMap.this.hashCode();
        }

        public Text toText() {
            return FastMap.this.toText();
        }

        public int size() {
            return FastMap.this.size();
        }

        public boolean isEmpty() {
            return FastMap.this.isEmpty();
        }

        public boolean containsKey(Object key) {
            return FastMap.this.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return FastMap.this.containsValue(value);
        }

        public Object get(Object key) {
            return FastMap.this.get(key);
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public void clear() {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Set keySet() {
            return (Set)((KeySet)FastMap.this.keySet()).unmodifiable();
        }

        public Collection values() {
            return ((Values)FastMap.this.values()).unmodifiable();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException("Direct view over unmodifiable map entries is not supported  (to prevent access to Entry.setValue(Object) method). To iterate over unmodifiable map entries, applications may use the keySet() and values() fast collection views in conjonction.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<K, V>
    implements Map.Entry<K, V>,
    FastCollection.Record,
    Realtime {
        public static final Entry NULL = new Entry();
        private Entry<K, V> _next;
        private Entry<K, V> _previous;
        private K _key;
        private V _value;
        private int _keyHash;

        protected Entry() {
        }

        @Override
        public final Entry<K, V> getNext() {
            return this._next;
        }

        @Override
        public final Entry<K, V> getPrevious() {
            return this._previous;
        }

        @Override
        public final K getKey() {
            return this._key;
        }

        @Override
        public final V getValue() {
            return this._value;
        }

        @Override
        public final V setValue(V value) {
            V old = this._value;
            this._value = value;
            return old;
        }

        @Override
        public boolean equals(Object that) {
            if (that instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)that;
                return FastComparator.DEFAULT.areEqual(this._key, entry.getKey()) && FastComparator.DEFAULT.areEqual(this._value, entry.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this._key != null ? this._key.hashCode() : 0) ^ (this._value != null ? this._value.hashCode() : 0);
        }

        @Override
        public Text toText() {
            return Text.valueOf(this._key).plus("=").plus(this._value);
        }
    }

    private static final class KeyIterator
    implements Iterator {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new KeyIterator();
            }

            protected void cleanup(Object obj) {
                KeyIterator iterator = (KeyIterator)obj;
                iterator._map = null;
                iterator._current = null;
                iterator._next = null;
                iterator._tail = null;
            }
        };
        private FastMap _map;
        private Entry _current;
        private Entry _next;
        private Entry _tail;

        public static KeyIterator valueOf(FastMap map) {
            KeyIterator iterator = (KeyIterator)FACTORY.object();
            iterator._map = map;
            iterator._next = map._head._next;
            iterator._tail = map._tail;
            return iterator;
        }

        private KeyIterator() {
        }

        public boolean hasNext() {
            return this._next != this._tail;
        }

        public Object next() {
            if (this._next == this._tail) {
                throw new NoSuchElementException();
            }
            this._current = this._next;
            this._next = this._next._next;
            return this._current._key;
        }

        public void remove() {
            if (this._current == null) {
                throw new IllegalStateException();
            }
            this._next = this._current._next;
            this._map.remove(this._current._key);
            this._current = null;
        }
    }

    private final class KeySet
    extends FastCollection
    implements Set {
        private KeySet() {
        }

        public int size() {
            return FastMap.this.size();
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object obj) {
            return FastMap.this.containsKey(obj);
        }

        public boolean remove(Object obj) {
            return FastMap.this.remove(obj) != null;
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._key;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }

        public FastComparator getValueComparator() {
            return FastMap.this._keyComparator;
        }

        public Iterator iterator() {
            return KeyIterator.valueOf(FastMap.this);
        }
    }

    private static final class EntryIterator
    implements Iterator {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new EntryIterator();
            }

            protected void cleanup(Object obj) {
                EntryIterator iterator = (EntryIterator)obj;
                iterator._map = null;
                iterator._current = null;
                iterator._next = null;
                iterator._tail = null;
            }
        };
        private FastMap _map;
        private Entry _current;
        private Entry _next;
        private Entry _tail;

        public static EntryIterator valueOf(FastMap map) {
            EntryIterator iterator = (EntryIterator)FACTORY.object();
            iterator._map = map;
            iterator._next = map._head._next;
            iterator._tail = map._tail;
            return iterator;
        }

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this._next != this._tail;
        }

        public Object next() {
            if (this._next == this._tail) {
                throw new NoSuchElementException();
            }
            this._current = this._next;
            this._next = this._next._next;
            return this._current;
        }

        public void remove() {
            if (this._current == null) {
                throw new IllegalStateException();
            }
            this._next = this._current._next;
            this._map.remove(this._current._key);
            this._current = null;
        }
    }

    private final class EntrySet
    extends FastCollection
    implements Set {
        private final FastComparator _entryComparator = new FastComparator(){

            public boolean areEqual(Object o1, Object o2) {
                if (o1 instanceof Map.Entry && o2 instanceof Map.Entry) {
                    Map.Entry e1 = (Map.Entry)o1;
                    Map.Entry e2 = (Map.Entry)o2;
                    return FastMap.this._keyComparator.areEqual(e1.getKey(), e2.getKey()) && FastMap.this._valueComparator.areEqual(e1.getValue(), e2.getValue());
                }
                return o1 == null && o2 == null;
            }

            public int compare(Object o1, Object o2) {
                return FastMap.this._keyComparator.compare(o1, o2);
            }

            public int hashCodeOf(Object obj) {
                Map.Entry entry = (Map.Entry)obj;
                return FastMap.this._keyComparator.hashCodeOf(entry.getKey()) + FastMap.this._valueComparator.hashCodeOf(entry.getValue());
            }
        };

        private EntrySet() {
        }

        public int size() {
            return FastMap.this.size();
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object obj) {
            if (obj instanceof Map.Entry) {
                Map.Entry thatEntry = (Map.Entry)obj;
                Entry thisEntry = FastMap.this.getEntry(thatEntry.getKey());
                if (thisEntry == null) {
                    return false;
                }
                return FastMap.this._valueComparator.areEqual(thisEntry.getValue(), thatEntry.getValue());
            }
            return false;
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return (Map.Entry)((Object)record);
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }

        public FastComparator getValueComparator() {
            return this._entryComparator;
        }

        public Iterator iterator() {
            return EntryIterator.valueOf(FastMap.this);
        }
    }

    private static final class ValueIterator
    implements Iterator {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new ValueIterator();
            }

            protected void cleanup(Object obj) {
                ValueIterator iterator = (ValueIterator)obj;
                iterator._map = null;
                iterator._current = null;
                iterator._next = null;
                iterator._tail = null;
            }
        };
        private FastMap _map;
        private Entry _current;
        private Entry _next;
        private Entry _tail;

        public static ValueIterator valueOf(FastMap map) {
            ValueIterator iterator = (ValueIterator)FACTORY.object();
            iterator._map = map;
            iterator._next = map._head._next;
            iterator._tail = map._tail;
            return iterator;
        }

        private ValueIterator() {
        }

        public boolean hasNext() {
            return this._next != this._tail;
        }

        public Object next() {
            if (this._next == this._tail) {
                throw new NoSuchElementException();
            }
            this._current = this._next;
            this._next = this._next._next;
            return this._current._value;
        }

        public void remove() {
            if (this._current == null) {
                throw new IllegalStateException();
            }
            this._next = this._current._next;
            this._map.remove(this._current._key);
            this._current = null;
        }
    }

    private final class Values
    extends FastCollection {
        private Values() {
        }

        public int size() {
            return FastMap.this.size();
        }

        public void clear() {
            FastMap.this.clear();
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._value;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }

        public FastComparator getValueComparator() {
            return FastMap.this._valueComparator;
        }

        public Iterator iterator() {
            return ValueIterator.valueOf(FastMap.this);
        }
    }
}

