/*
 * Decompiled with CFR 0.152.
 */
package javolution.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import javolution.io.UTF8ByteBufferReader;
import javolution.io.UTF8ByteBufferWriter;
import javolution.lang.Configurable;
import javolution.lang.MathLib;
import javolution.lang.Reflection;
import javolution.text.TextBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Struct {
    public static final Configurable<Integer> MAXIMUM_ALIGNMENT = new Configurable(new Integer(4)){};
    Struct _outer;
    ByteBuffer _byteBuffer;
    int _outerOffset;
    int _bitsUsed;
    int _alignment = 1;
    int _bitIndex;
    boolean _resetIndex = this.isUnion();
    byte[] _bytes;
    private static final Reflection.Method ADDRESS_METHOD = Reflection.getInstance().getMethod("sun.nio.ch.DirectBuffer.address()");
    private static final char[] HEXA = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Class BOOL = new Bool[0].getClass();
    private static final Class SIGNED_8 = new Signed8[0].getClass();
    private static final Class UNSIGNED_8 = new Unsigned8[0].getClass();
    private static final Class SIGNED_16 = new Signed16[0].getClass();
    private static final Class UNSIGNED_16 = new Unsigned16[0].getClass();
    private static final Class SIGNED_32 = new Signed32[0].getClass();
    private static final Class UNSIGNED_32 = new Unsigned32[0].getClass();
    private static final Class SIGNED_64 = new Signed64[0].getClass();
    private static final Class FLOAT_32 = new Float32[0].getClass();
    private static final Class FLOAT_64 = new Float64[0].getClass();

    public final int size() {
        int nbrOfBytes = this._bitsUsed + 7 >> 3;
        return nbrOfBytes % this._alignment == 0 ? nbrOfBytes : nbrOfBytes + this._alignment - nbrOfBytes % this._alignment;
    }

    public Struct outer() {
        return this._outer;
    }

    public final ByteBuffer getByteBuffer() {
        if (this._outer != null) {
            return this._outer.getByteBuffer();
        }
        return this._byteBuffer != null ? this._byteBuffer : this.newBuffer();
    }

    private synchronized ByteBuffer newBuffer() {
        if (this._byteBuffer != null) {
            return this._byteBuffer;
        }
        ByteBuffer bf = ByteBuffer.allocateDirect(this.size());
        bf.order(this.byteOrder());
        this.setByteBuffer(bf, 0);
        return this._byteBuffer;
    }

    public final Struct setByteBuffer(ByteBuffer byteBuffer, int position) {
        if (byteBuffer.order() != this.byteOrder()) {
            throw new IllegalArgumentException("The byte order of the specified byte buffer is different from this struct byte order");
        }
        if (this._outer != null) {
            throw new UnsupportedOperationException("Inner struct byte buffer is inherited from outer");
        }
        this._byteBuffer = byteBuffer;
        this._outerOffset = position;
        return this;
    }

    public final Struct setByteBufferPosition(int position) {
        return this.setByteBuffer(this.getByteBuffer(), position);
    }

    public final int getByteBufferPosition() {
        return this._outer != null ? this._outer.getByteBufferPosition() + this._outerOffset : this._outerOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(InputStream in) throws IOException {
        ByteBuffer buffer = this.getByteBuffer();
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + this.getByteBufferPosition();
            return in.read(buffer.array(), offset, this.size());
        }
        ByteBuffer byteBuffer = buffer;
        synchronized (byteBuffer) {
            if (this._bytes == null) {
                this._bytes = new byte[this.size()];
            }
            int bytesRead = in.read(this._bytes);
            buffer.position(this.getByteBufferPosition());
            buffer.put(this._bytes);
            return bytesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) throws IOException {
        ByteBuffer buffer = this.getByteBuffer();
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + this.getByteBufferPosition();
            out.write(buffer.array(), offset, this.size());
        } else {
            ByteBuffer byteBuffer = buffer;
            synchronized (byteBuffer) {
                if (this._bytes == null) {
                    this._bytes = new byte[this.size()];
                }
                buffer.position(this.getByteBufferPosition());
                buffer.get(this._bytes);
                out.write(this._bytes);
            }
        }
    }

    public final long address() {
        ByteBuffer thisBuffer = this.getByteBuffer();
        if (ADDRESS_METHOD != null) {
            Long start = (Long)ADDRESS_METHOD.invoke(thisBuffer);
            return start + (long)this.getByteBufferPosition();
        }
        throw new UnsupportedOperationException("Operation not supported for " + thisBuffer.getClass());
    }

    public String toString() {
        int size = this.size();
        StringBuffer sb = new StringBuffer(size * 3);
        ByteBuffer buffer = this.getByteBuffer();
        int start = this.getByteBufferPosition();
        for (int i = 0; i < size; ++i) {
            int b = buffer.get(start + i) & 0xFF;
            sb.append(HEXA[b >> 4]);
            sb.append(HEXA[b & 0xF]);
            sb.append((i & 0xF) == 15 ? (char)'\n' : ' ');
        }
        return sb.toString();
    }

    public boolean isUnion() {
        return false;
    }

    public ByteOrder byteOrder() {
        return this._outer != null ? this._outer.byteOrder() : ByteOrder.BIG_ENDIAN;
    }

    public boolean isPacked() {
        return false;
    }

    protected <S extends Struct> S inner(S struct) {
        if (struct._outer != null) {
            throw new IllegalArgumentException("struct: Already an inner struct");
        }
        struct._outer = this;
        int bitSize = struct.size() << 3;
        int bitOffset = this.updateIndexes(struct._alignment, bitSize);
        struct._outerOffset = bitOffset >> 3;
        return struct;
    }

    protected <S extends Struct> S[] array(S[] structs) {
        Class structClass = null;
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        int i = 0;
        while (i < structs.length) {
            Object struct = structs[i];
            if (struct == null) {
                try {
                    if (structClass == null) {
                        String arrayName = structs.getClass().getName();
                        String structName = arrayName.substring(2, arrayName.length() - 1);
                        structClass = Reflection.getInstance().getClass(structName);
                        if (structClass == null) {
                            throw new IllegalArgumentException("Struct class: " + structName + " not found");
                        }
                    }
                    struct = (Struct)structClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            structs[i++] = this.inner(struct);
        }
        this._resetIndex = resetIndexSaved;
        return (Struct[])structs;
    }

    protected <S extends Struct> S[][] array(S[][] structs) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < structs.length; ++i) {
            this.array((Struct[])structs[i]);
        }
        this._resetIndex = resetIndexSaved;
        return (Struct[][])structs;
    }

    protected <S extends Struct> S[][][] array(S[][][] structs) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < structs.length; ++i) {
            this.array((Struct[][])structs[i]);
        }
        this._resetIndex = resetIndexSaved;
        return (Struct[][][])structs;
    }

    protected <M extends Member> M[] array(M[] arrayMember) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        if (BOOL.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Bool();
            }
        } else if (SIGNED_8.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Signed8();
            }
        } else if (UNSIGNED_8.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Unsigned8();
            }
        } else if (SIGNED_16.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Signed16();
            }
        } else if (UNSIGNED_16.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Unsigned16();
            }
        } else if (SIGNED_32.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Signed32();
            }
        } else if (UNSIGNED_32.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Unsigned32();
            }
        } else if (SIGNED_64.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Signed64();
            }
        } else if (FLOAT_32.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Float32();
            }
        } else if (FLOAT_64.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Float64();
            }
        } else {
            throw new UnsupportedOperationException("Cannot create member elements, the arrayMember should contain the member instances instead of null");
        }
        this._resetIndex = resetIndexSaved;
        return (Member[])arrayMember;
    }

    protected <M extends Member> M[][] array(M[][] arrayMember) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < arrayMember.length; ++i) {
            this.array((Member[])arrayMember[i]);
        }
        this._resetIndex = resetIndexSaved;
        return (Member[][])arrayMember;
    }

    protected <M extends Member> M[][][] array(M[][][] arrayMember) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < arrayMember.length; ++i) {
            this.array((Member[][])arrayMember[i]);
        }
        this._resetIndex = resetIndexSaved;
        return (Member[][][])arrayMember;
    }

    protected UTF8String[] array(UTF8String[] array, int stringLength) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = new UTF8String(stringLength);
        }
        return array;
    }

    private int updateIndexes(int alignment, int nbrOfBits) {
        if (this._resetIndex) {
            this._bitIndex = 0;
        }
        if (!this.isPacked() && this._alignment < alignment) {
            this._alignment = alignment;
        }
        int bitOffset = this._bitIndex;
        if (alignment != 0) {
            int trueAlignment = this.isPacked() ? 1 : MathLib.min(alignment, MAXIMUM_ALIGNMENT.get());
            int i = this._bitIndex % (trueAlignment << 3);
            int paddingBits = i == 0 ? 0 : (trueAlignment << 3) - i;
            bitOffset += paddingBits;
        }
        this._bitIndex = bitOffset + nbrOfBits;
        if (this._bitsUsed < this._bitIndex) {
            this._bitsUsed = this._bitIndex;
        }
        return bitOffset;
    }

    public long readBits(int bitOffset, int bitSize) {
        if (bitOffset + bitSize - 1 >> 3 >= this.size()) {
            throw new IllegalArgumentException("Attempt to read outside the Struct");
        }
        int offset = bitOffset >> 3;
        int bitStart = this.byteOrder() == ByteOrder.BIG_ENDIAN ? bitOffset - (offset << 3) : 64 - bitSize - (bitOffset - (offset << 3));
        int index = this.getByteBufferPosition() + offset;
        long value = this.readByteBufferLong(index);
        value <<= bitStart;
        return value >>= 64 - bitSize;
    }

    private long readByteBufferLong(int index) {
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (index + 8 < byteBuffer.capacity()) {
            return byteBuffer.getLong(index);
        }
        if (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            return (long)((Struct.readByte(index, byteBuffer) & 0xFF) + ((Struct.readByte(++index, byteBuffer) & 0xFF) << 8) + ((Struct.readByte(++index, byteBuffer) & 0xFF) << 16)) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 24) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 32) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 40) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 48) + ((long)this._bytes[++index] << 56);
        }
        return ((long)Struct.readByte(index, byteBuffer) << 56) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 48) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 40) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 32) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 24) + (long)((Struct.readByte(++index, byteBuffer) & 0xFF) << 16) + (long)((Struct.readByte(++index, byteBuffer) & 0xFF) << 8) + ((long)Struct.readByte(++index, byteBuffer) & 0xFFL);
    }

    private static byte readByte(int index, ByteBuffer byteBuffer) {
        return index < byteBuffer.capacity() ? byteBuffer.get(index) : (byte)0;
    }

    public void writeBits(long value, int bitOffset, int bitSize) {
        if (bitOffset + bitSize - 1 >> 3 >= this.size()) {
            throw new IllegalArgumentException("Attempt to write outside the Struct");
        }
        int offset = bitOffset >> 3;
        int bitStart = this.byteOrder() == ByteOrder.BIG_ENDIAN ? bitOffset - (offset << 3) : 64 - bitSize - (bitOffset - (offset << 3));
        long mask = -1L;
        mask <<= bitStart;
        mask >>>= 64 - bitSize;
        int index = this.getByteBufferPosition() + offset;
        long oldValue = this.readByteBufferLong(index);
        long resetValue = oldValue & ((mask <<= 64 - bitSize - bitStart) ^ 0xFFFFFFFFFFFFFFFFL);
        long newValue = resetValue | value << 64 - bitSize - bitStart;
        this.writeByteBufferLong(index, newValue);
    }

    private void writeByteBufferLong(int index, long value) {
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (index + 8 < byteBuffer.capacity()) {
            byteBuffer.putLong(index, value);
            return;
        }
        if (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            Struct.writeByte(index, byteBuffer, (byte)value);
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 8));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 16));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 24));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 32));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 40));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 48));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 56));
        } else {
            Struct.writeByte(index, byteBuffer, (byte)(value >> 56));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 48));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 40));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 32));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 24));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 16));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 8));
            Struct.writeByte(++index, byteBuffer, (byte)value);
        }
    }

    private static void writeByte(int index, ByteBuffer byteBuffer, byte value) {
        if (index < byteBuffer.capacity()) {
            byteBuffer.put(index, value);
        }
    }

    public class Enum64
    extends Member {
        private final List _enumValues;

        public Enum64(List enumValues) {
            super(1, 64);
            this._enumValues = enumValues;
        }

        public Enum64(List enumValues, int nbrOfBits) {
            super(0, nbrOfBits);
            this._enumValues = enumValues;
        }

        public Enum get() {
            long signedValue = Struct.this.readBits(this.bitOffset(), this.bitSize());
            int index = (int)(-1L >>> 64 - this.bitSize() & signedValue);
            return (Enum)this._enumValues.get(index);
        }

        public void set(Enum e) {
            int index = e.ordinal();
            if (this._enumValues.get(index) != e) {
                throw new IllegalArgumentException("enum: " + e + ", ordinal value does not reflect enum values position");
            }
            Struct.this.writeBits(index, this.bitOffset(), this.bitSize());
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Enum32
    extends Member {
        private final List _enumValues;

        public Enum32(List enumValues) {
            super(1, 32);
            this._enumValues = enumValues;
        }

        public Enum32(List enumValues, int nbrOfBits) {
            super(0, nbrOfBits);
            this._enumValues = enumValues;
        }

        public Enum get() {
            long signedValue = Struct.this.readBits(this.bitOffset(), this.bitSize());
            int index = (int)(-1L >>> 64 - this.bitSize() & signedValue);
            return (Enum)this._enumValues.get(index);
        }

        public void set(Enum e) {
            int index = e.ordinal();
            if (this._enumValues.get(index) != e) {
                throw new IllegalArgumentException("enum: " + e + ", ordinal value does not reflect enum values position");
            }
            Struct.this.writeBits(index, this.bitOffset(), this.bitSize());
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Enum16
    extends Member {
        private final List _enumValues;

        public Enum16(List enumValues) {
            super(1, 16);
            this._enumValues = enumValues;
        }

        public Enum16(List enumValues, int nbrOfBits) {
            super(0, nbrOfBits);
            this._enumValues = enumValues;
        }

        public Enum get() {
            long signedValue = Struct.this.readBits(this.bitOffset(), this.bitSize());
            int index = (int)(-1L >>> 64 - this.bitSize() & signedValue);
            return (Enum)this._enumValues.get(index);
        }

        public void set(Enum e) {
            int index = e.ordinal();
            if (this._enumValues.get(index) != e) {
                throw new IllegalArgumentException("enum: " + e + ", ordinal value does not reflect enum values position");
            }
            Struct.this.writeBits(index, this.bitOffset(), this.bitSize());
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Enum8
    extends Member {
        private final List _enumValues;

        public Enum8(List enumValues) {
            super(1, 8);
            this._enumValues = enumValues;
        }

        public Enum8(List enumValues, int nbrOfBits) {
            super(0, nbrOfBits);
            this._enumValues = enumValues;
        }

        public Enum get() {
            long signedValue = Struct.this.readBits(this.bitOffset(), this.bitSize());
            int index = (int)(-1L >>> 64 - this.bitSize() & signedValue);
            return (Enum)this._enumValues.get(index);
        }

        public void set(Enum e) {
            int index = e.ordinal();
            if (this._enumValues.get(index) != e) {
                throw new IllegalArgumentException("enum: " + e + ", ordinal value does not reflect enum values position");
            }
            Struct.this.writeBits(index, this.bitOffset(), this.bitSize());
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Reference64<S extends Struct>
    extends Member {
        private Struct _struct;

        public Reference64() {
            super(8, 64);
        }

        public void set(S struct) {
            int index = (this.bitOffset() >> 3) + Struct.this.getByteBufferPosition();
            if (struct != null) {
                Struct.this.getByteBuffer().putLong(index, ((Struct)struct).address());
            } else if (struct == null) {
                Struct.this.getByteBuffer().putLong(index, 0L);
            }
            this._struct = struct;
        }

        public Struct get() {
            return this._struct;
        }

        public long value() {
            int index = (this.bitOffset() >> 3) + Struct.this.getByteBufferPosition();
            return Struct.this.getByteBuffer().getLong(index);
        }

        public boolean isUpToDate() {
            int index = (this.bitOffset() >> 3) + Struct.this.getByteBufferPosition();
            if (this._struct != null) {
                return Struct.this.getByteBuffer().getLong(index) == this._struct.address();
            }
            return Struct.this.getByteBuffer().getLong(index) == 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Reference32<S extends Struct>
    extends Member {
        private Struct _struct;

        public Reference32() {
            super(4, 32);
        }

        public void set(S struct) {
            int index = (this.bitOffset() >> 3) + Struct.this.getByteBufferPosition();
            if (struct != null) {
                Struct.this.getByteBuffer().putInt(index, (int)((Struct)struct).address());
            } else {
                Struct.this.getByteBuffer().putInt(index, 0);
            }
            this._struct = struct;
        }

        public Struct get() {
            return this._struct;
        }

        public int value() {
            int index = (this.bitOffset() >> 3) + Struct.this.getByteBufferPosition();
            return Struct.this.getByteBuffer().getInt(index);
        }

        public boolean isUpToDate() {
            int index = (this.bitOffset() >> 3) + Struct.this.getByteBufferPosition();
            if (this._struct != null) {
                return Struct.this.getByteBuffer().getInt(index) == (int)this._struct.address();
            }
            return Struct.this.getByteBuffer().getInt(index) == 0;
        }
    }

    public class Float64
    extends Member {
        public Float64() {
            super(8, 8);
        }

        public double get() {
            int index = (this.bitOffset() >> 3) + Struct.this.getByteBufferPosition();
            return Struct.this.getByteBuffer().getDouble(index);
        }

        public void set(double value) {
            int index = (this.bitOffset() >> 3) + Struct.this.getByteBufferPosition();
            Struct.this.getByteBuffer().putDouble(index, value);
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Float32
    extends Member {
        public Float32() {
            super(4, 32);
        }

        public float get() {
            int index = (this.bitOffset() >> 3) + Struct.this.getByteBufferPosition();
            return Struct.this.getByteBuffer().getFloat(index);
        }

        public void set(float value) {
            int index = (this.bitOffset() >> 3) + Struct.this.getByteBufferPosition();
            Struct.this.getByteBuffer().putFloat(index, value);
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class BitField
    extends Member {
        public BitField(int nbrOfBits) {
            super(0, nbrOfBits);
            if (nbrOfBits >= 64) {
                throw new IllegalArgumentException("Unsigned bit fields cannot exceed 63 bits");
            }
        }

        public long longValue() {
            long signedValue = Struct.this.readBits(this.bitOffset(), this.bitSize());
            return -1L >>> 64 - this.bitSize() & signedValue;
        }

        public int intValue() {
            return (int)this.longValue();
        }

        public short shortValue() {
            return (short)this.longValue();
        }

        public byte byteValue() {
            return (byte)this.longValue();
        }

        public void set(long value) {
            Struct.this.writeBits(value, this.bitOffset(), this.bitSize());
        }

        public String toString() {
            return String.valueOf(this.longValue());
        }
    }

    public class Signed64
    extends Member {
        public Signed64() {
            super(8, 64);
        }

        public Signed64(int nbrOfBits) {
            super(0, nbrOfBits);
        }

        public long get() {
            return Struct.this.readBits(this.bitOffset(), this.bitSize());
        }

        public void set(long value) {
            Struct.this.writeBits(value, this.bitOffset(), this.bitSize());
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Unsigned32
    extends Member {
        public Unsigned32() {
            super(4, 32);
        }

        public Unsigned32(int nbrOfBits) {
            super(0, nbrOfBits);
        }

        public long get() {
            long signedValue = Struct.this.readBits(this.bitOffset(), this.bitSize());
            return 0xFFFFFFFFL & signedValue;
        }

        public void set(long value) {
            Struct.this.writeBits(value, this.bitOffset(), this.bitSize());
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Signed32
    extends Member {
        public Signed32() {
            super(4, 32);
        }

        public Signed32(int nbrOfBits) {
            super(0, nbrOfBits);
        }

        public int get() {
            return (int)Struct.this.readBits(this.bitOffset(), this.bitSize());
        }

        public void set(int value) {
            Struct.this.writeBits(value, this.bitOffset(), this.bitSize());
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Unsigned16
    extends Member {
        public Unsigned16() {
            super(2, 16);
        }

        public Unsigned16(int nbrOfBits) {
            super(0, nbrOfBits);
        }

        public int get() {
            long signedValue = Struct.this.readBits(this.bitOffset(), this.bitSize());
            return (int)(0xFFFFL & signedValue);
        }

        public void set(int value) {
            Struct.this.writeBits(value, this.bitOffset(), this.bitSize());
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Signed16
    extends Member {
        public Signed16() {
            super(2, 16);
        }

        public Signed16(int nbrOfBits) {
            super(0, nbrOfBits);
        }

        public short get() {
            return (short)Struct.this.readBits(this.bitOffset(), this.bitSize());
        }

        public void set(short value) {
            Struct.this.writeBits(value, this.bitOffset(), this.bitSize());
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Unsigned8
    extends Member {
        public Unsigned8() {
            super(1, 8);
        }

        public Unsigned8(int nbrOfBits) {
            super(0, nbrOfBits);
        }

        public short get() {
            long signedValue = Struct.this.readBits(this.bitOffset(), this.bitSize());
            return (short)(0xFFL & signedValue);
        }

        public void set(short value) {
            Struct.this.writeBits(value, this.bitOffset(), this.bitSize());
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Signed8
    extends Member {
        public Signed8() {
            super(1, 8);
        }

        public Signed8(int nbrOfBits) {
            super(0, nbrOfBits);
        }

        public byte get() {
            return (byte)Struct.this.readBits(this.bitOffset(), this.bitSize());
        }

        public void set(byte value) {
            Struct.this.writeBits(value, this.bitOffset(), this.bitSize());
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Bool
    extends Member {
        public Bool() {
            super(1, 8);
        }

        public Bool(int nbrOfBits) {
            super(0, nbrOfBits);
        }

        public boolean get() {
            return Struct.this.readBits(this.bitOffset(), this.bitSize()) != 0L;
        }

        public void set(boolean value) {
            Struct.this.writeBits(value ? -1L : 0L, this.bitOffset(), this.bitSize());
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class UTF8String
    extends Member {
        private final UTF8ByteBufferWriter _writer;
        private final UTF8ByteBufferReader _reader;
        private final int _length;

        public UTF8String(int length) {
            super(1, length << 3);
            this._writer = new UTF8ByteBufferWriter();
            this._reader = new UTF8ByteBufferReader();
            this._length = length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String string) {
            ByteBuffer buffer;
            ByteBuffer byteBuffer = buffer = Struct.this.getByteBuffer();
            synchronized (byteBuffer) {
                try {
                    int index = Struct.this.getByteBufferPosition() + (this.bitOffset() >> 3);
                    buffer.position(index);
                    this._writer.setOutput(buffer);
                    if (string.length() < this._length) {
                        this._writer.write(string);
                        this._writer.write(0);
                    } else if (string.length() > this._length) {
                        this._writer.write(string.substring(0, this._length));
                    } else {
                        this._writer.write(string);
                    }
                }
                catch (IOException e) {
                    throw new Error(e.getMessage());
                }
                finally {
                    this._writer.reset();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String get() {
            ByteBuffer buffer;
            ByteBuffer byteBuffer = buffer = Struct.this.getByteBuffer();
            synchronized (byteBuffer) {
                TextBuilder tmp = TextBuilder.newInstance();
                try {
                    int index = Struct.this.getByteBufferPosition() + (this.bitOffset() >> 3);
                    buffer.position(index);
                    this._reader.setInput(buffer);
                    for (int i = 0; i < this._length; ++i) {
                        char c = (char)this._reader.read();
                        if (c == '\u0000') {
                            String string = tmp.toString();
                            return string;
                        }
                        tmp.append(c);
                    }
                    String string = tmp.toString();
                    return string;
                }
                catch (IOException e) {
                    throw new Error(e.getMessage());
                }
                finally {
                    this._reader.reset();
                    TextBuilder.recycle(tmp);
                }
            }
        }

        public String toString() {
            return this.get();
        }
    }

    protected class Member {
        private final int _bitOffset;
        private final int _bitSize;

        protected Member(int alignment, int bitSize) {
            this._bitSize = bitSize;
            this._bitOffset = Struct.this.updateIndexes(alignment, bitSize);
        }

        public final Struct struct() {
            return Struct.this;
        }

        public final int bitSize() {
            return this._bitSize;
        }

        public final int bitOffset() {
            return this._bitOffset;
        }
    }
}

