/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.Context;
import javolution.context.ObjectFactory;
import javolution.lang.Configurable;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.util.StandardLog;

public abstract class LogContext
extends Context {
    private static volatile LogContext _Default = new StandardLog();
    public static final Class<? extends LogContext> STANDARD = StandardLog.class;
    public static final Class<? extends LogContext> NULL = Null.class;
    public static final Class<? extends LogContext> SYSTEM_OUT = SystemOut.class;
    public static final Class<? extends LogContext> CONSOLE = Console.class;
    public static final Configurable<Class<? extends LogContext>> DEFAULT = new Configurable(STANDARD){

        protected void notifyChange(Object oldValue, Object newValue) {
            _Default = (LogContext)ObjectFactory.getInstance((Class)newValue).object();
        }
    };

    protected LogContext() {
    }

    public static Context getCurrent() {
        for (Context ctx = Context.getCurrent(); ctx != null; ctx = ctx.getOuter()) {
            if (!(ctx instanceof LogContext)) continue;
            return (LogContext)ctx;
        }
        return _Default;
    }

    public static LogContext getDefault() {
        return _Default;
    }

    public static boolean isDebugLogged() {
        return ((LogContext)LogContext.getCurrent()).isLogged("debug");
    }

    public static void debug(CharSequence message) {
        ((LogContext)LogContext.getCurrent()).logDebug(message);
    }

    public static void debug(Object message) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (!logContext.isLogged("debug")) {
            return;
        }
        logContext.logDebug(Text.valueOf(message));
    }

    public static void debug(Object ... messages) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (!logContext.isLogged("debug")) {
            return;
        }
        Text tmp = Text.valueOf(messages[0]);
        for (int i = 1; i < messages.length; ++i) {
            tmp = tmp.plus(messages[i]);
        }
        logContext.logDebug(tmp);
    }

    public static boolean isInfoLogged() {
        return ((LogContext)LogContext.getCurrent()).isLogged("info");
    }

    public static void info(CharSequence message) {
        ((LogContext)LogContext.getCurrent()).logInfo(message);
    }

    public static void info(Object message) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (!logContext.isLogged("info")) {
            return;
        }
        logContext.logInfo(Text.valueOf(message));
    }

    public static void info(Object ... messages) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (!logContext.isLogged("info")) {
            return;
        }
        Text tmp = Text.valueOf(messages[0]);
        for (int i = 1; i < messages.length; ++i) {
            tmp = tmp.plus(messages[i]);
        }
        logContext.logInfo(tmp);
    }

    public static boolean isWarningLogged() {
        return ((LogContext)LogContext.getCurrent()).isLogged("warning");
    }

    public static void warning(CharSequence message) {
        ((LogContext)LogContext.getCurrent()).logWarning(message);
    }

    public static void warning(Object message) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (!logContext.isLogged("warning")) {
            return;
        }
        logContext.logWarning(Text.valueOf(message));
    }

    public static void warning(Object ... messages) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (!logContext.isLogged("warning")) {
            return;
        }
        Text tmp = Text.valueOf(messages[0]);
        for (int i = 1; i < messages.length; ++i) {
            tmp = tmp.plus(messages[i]);
        }
        logContext.logWarning(tmp);
    }

    public static boolean isErrorLogged() {
        return ((LogContext)LogContext.getCurrent()).isLogged("error");
    }

    public static void error(Throwable error) {
        ((LogContext)LogContext.getCurrent()).logError(error, null);
    }

    public static void error(Throwable error, CharSequence message) {
        ((LogContext)LogContext.getCurrent()).logError(error, message);
    }

    public static void error(Throwable error, Object message) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (!logContext.isLogged("error")) {
            return;
        }
        logContext.logError(error, Text.valueOf(message));
    }

    public static void error(Throwable error, Object ... messages) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (!logContext.isLogged("error")) {
            return;
        }
        Text tmp = Text.valueOf(messages[0]);
        for (int i = 1; i < messages.length; ++i) {
            tmp = tmp.plus(messages[i]);
        }
        logContext.logError(error, tmp);
    }

    public static void error(CharSequence message) {
        ((LogContext)LogContext.getCurrent()).logError(null, message);
    }

    public static void error(Object message) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (!logContext.isLogged("error")) {
            return;
        }
        logContext.logError(null, Text.valueOf(message));
    }

    public static void error(Object ... messages) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (!logContext.isLogged("error")) {
            return;
        }
        Text tmp = Text.valueOf(messages[0]);
        for (int i = 1; i < messages.length; ++i) {
            tmp = tmp.plus(messages[i]);
        }
        logContext.logError(null, tmp);
    }

    protected abstract void logMessage(String var1, CharSequence var2);

    protected boolean isLogged(String category) {
        return true;
    }

    protected void logDebug(CharSequence message) {
        this.logMessage("debug", message);
    }

    protected void logInfo(CharSequence message) {
        this.logMessage("info", message);
    }

    protected void logWarning(CharSequence message) {
        this.logMessage("warning", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logError(Throwable error, CharSequence message) {
        TextBuilder tmp = TextBuilder.newInstance();
        try {
            if (error != null) {
                tmp.append(error.getClass().getName());
                tmp.append(" - ");
            }
            if (message != null) {
                tmp.append(message);
            } else if (error != null) {
                tmp.append(error.getMessage());
            }
            if (error != null) {
                StackTraceElement[] trace = error.getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    tmp.append("\n\tat ");
                    tmp.append(trace[i]);
                }
            }
            this.logMessage("error", tmp);
        }
        finally {
            TextBuilder.recycle(tmp);
        }
    }

    protected void enterAction() {
    }

    protected void exitAction() {
    }

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Console();
            }
        }, CONSOLE);
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Null();
            }
        }, NULL);
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new SystemOut();
            }
        }, SYSTEM_OUT);
    }

    private static class Console
    extends SystemOut {
        private Console() {
        }
    }

    private static final class Null
    extends SystemOut {
        private Null() {
        }

        protected boolean isLogged(String category) {
            return false;
        }

        protected void logMessage(String category, CharSequence message) {
        }
    }

    private static class SystemOut
    extends LogContext {
        private SystemOut() {
        }

        protected void logMessage(String category, CharSequence message) {
            System.out.print("[");
            System.out.print(category);
            System.out.print("] ");
            System.out.println(message);
        }
    }
}

