/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.property.Contact;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.PropertyValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VFreeBusy
extends CalendarComponent {
    private static final long serialVersionUID = 1046534053331139832L;
    private transient Log log = LogFactory.getLog((Class)VFreeBusy.class);

    public VFreeBusy() {
        super("VFREEBUSY");
        this.getProperties().add(new DtStamp());
    }

    public VFreeBusy(PropertyList properties) {
        super("VFREEBUSY", properties);
    }

    public VFreeBusy(DateTime start, DateTime end) {
        this();
        this.getProperties().add(new DtStart(start, true));
        this.getProperties().add(new DtEnd(end, true));
    }

    public VFreeBusy(DateTime start, DateTime end, Dur duration) {
        this();
        this.getProperties().add(new DtStart(start, true));
        this.getProperties().add(new DtEnd(end, true));
        this.getProperties().add(new Duration(duration));
    }

    public VFreeBusy(VFreeBusy request, ComponentList components) {
        this();
        DtStart start = (DtStart)request.getProperty("DTSTART");
        DtEnd end = (DtEnd)request.getProperty("DTEND");
        Duration duration = (Duration)request.getProperty("DURATION");
        this.getProperties().add(new DtStart(start.getDate(), true));
        this.getProperties().add(new DtEnd(end.getDate(), true));
        if (duration != null) {
            this.getProperties().add(new Duration(duration.getDuration()));
            DateTime freeStart = new DateTime(start.getDate());
            DateTime freeEnd = new DateTime(end.getDate());
            FreeBusy fb = this.createFreeTime(freeStart, freeEnd, duration.getDuration(), components);
            if (fb != null && !fb.getPeriods().isEmpty()) {
                this.getProperties().add(fb);
            }
        } else {
            DateTime busyEnd;
            DateTime busyStart = new DateTime(start.getDate());
            FreeBusy fb = this.createBusyTime(busyStart, busyEnd = new DateTime(end.getDate()), components);
            if (fb != null && !fb.getPeriods().isEmpty()) {
                this.getProperties().add(fb);
            }
        }
    }

    private FreeBusy createBusyTime(DateTime start, DateTime end, ComponentList components) {
        PeriodList periods = this.getConsumedTime(components, start, end);
        periods.setUtc(true);
        Iterator i = periods.iterator();
        while (i.hasNext()) {
            Period period = (Period)i.next();
            if (!period.getStart().after(end) && !period.getEnd().before(start)) continue;
            periods.remove(period);
        }
        return new FreeBusy(periods);
    }

    private FreeBusy createFreeTime(DateTime start, DateTime end, Dur duration, ComponentList components) {
        FreeBusy fb = new FreeBusy();
        fb.getParameters().add(FbType.FREE);
        PeriodList periods = this.getConsumedTime(components, start, end);
        periods.add(new Period(end, end));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Busy periods: " + periods));
        }
        DateTime lastPeriodEnd = new DateTime(start);
        Iterator i = periods.iterator();
        while (i.hasNext()) {
            Period period = (Period)i.next();
            if (period.getStart().after(end) || period.getEnd().before(start)) continue;
            Duration freeDuration = new Duration(lastPeriodEnd, period.getStart());
            if (freeDuration.getDuration().compareTo(duration) >= 0) {
                fb.getPeriods().add(new Period(lastPeriodEnd, freeDuration.getDuration()));
            }
            if (!period.getEnd().after(lastPeriodEnd)) continue;
            lastPeriodEnd = period.getEnd();
        }
        return fb;
    }

    private PeriodList getConsumedTime(ComponentList components, DateTime rangeStart, DateTime rangeEnd) {
        PeriodList periods = new PeriodList();
        Iterator i = components.getComponents("VEVENT").iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            periods.addAll(((VEvent)component).getConsumedTime(rangeStart, rangeEnd, false));
        }
        return periods.normalise();
    }

    public final void validate(boolean recurse) throws ValidationException {
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
            PropertyValidator.getInstance().assertOne("UID", this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        }
        PropertyValidator validator = PropertyValidator.getInstance();
        validator.assertOneOrLess("CONTACT", this.getProperties());
        validator.assertOneOrLess("DTSTART", this.getProperties());
        validator.assertOneOrLess("DTEND", this.getProperties());
        validator.assertOneOrLess("DURATION", this.getProperties());
        validator.assertOneOrLess("DTSTAMP", this.getProperties());
        validator.assertOneOrLess("ORGANIZER", this.getProperties());
        validator.assertOneOrLess("UID", this.getProperties());
        validator.assertOneOrLess("URL", this.getProperties());
        validator.assertNone("RRULE", this.getProperties());
        validator.assertNone("EXRULE", this.getProperties());
        validator.assertNone("RDATE", this.getProperties());
        validator.assertNone("EXDATE", this.getProperties());
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        if (dtStart != null && !dtStart.isUtc()) {
            throw new ValidationException("DTSTART must be specified in UTC time");
        }
        DtEnd dtEnd = (DtEnd)this.getProperty("DTEND");
        if (dtEnd != null && !dtEnd.isUtc()) {
            throw new ValidationException("DTEND must be specified in UTC time");
        }
        if (dtStart != null && dtEnd != null && !dtStart.getDate().before(dtEnd.getDate())) {
            throw new ValidationException("Property [DTEND] must be later in time than [DTSTART]");
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    public void validatePublish() throws ValidationException {
        PropertyValidator.getInstance().assertOneOrMore("FREEBUSY", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTEND", this.getProperties());
        PropertyValidator.getInstance().assertOne("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOne("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("COMMENT", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        PropertyValidator.getInstance().assertNone("ATTENDEE", this.getProperties());
        PropertyValidator.getInstance().assertNone("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertNone("REQUEST-STATUS", this.getProperties());
    }

    public void validateRequest() throws ValidationException {
        PropertyValidator.getInstance().assertOneOrMore("ATTENDEE", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTEND", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOne("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOne("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("COMMENT", this.getProperties());
        PropertyValidator.getInstance().assertNone("FREEBUSY", this.getProperties());
        PropertyValidator.getInstance().assertNone("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertNone("REQUEST-STATUS", this.getProperties());
        PropertyValidator.getInstance().assertNone("URL", this.getProperties());
    }

    public void validateReply() throws ValidationException {
        PropertyValidator.getInstance().assertOne("ATTENDEE", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTEND", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOne("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOne("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("COMMENT", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        PropertyValidator.getInstance().assertNone("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertNone("SEQUENCE", this.getProperties());
    }

    public void validateRefresh() throws ValidationException {
        throw new ValidationException("METHOD:REFRESH not supported for VFREEBUSY components");
    }

    public void validateAdd() throws ValidationException {
        throw new ValidationException("METHOD:ADD not supported for VFREEBUSY components");
    }

    public void validateCancel() throws ValidationException {
        throw new ValidationException("METHOD:CANCEL not supported for VFREEBUSY components");
    }

    public void validateCounter() throws ValidationException {
        throw new ValidationException("METHOD:COUNTER not supported for VFREEBUSY components");
    }

    public void validateDeclineCounter() throws ValidationException {
        throw new ValidationException("METHOD:DECLINE-COUNTER not supported for VFREEBUSY components");
    }

    public final Contact getContact() {
        return (Contact)this.getProperty("CONTACT");
    }

    public final DtStart getStartDate() {
        return (DtStart)this.getProperty("DTSTART");
    }

    public final DtEnd getEndDate() {
        return (DtEnd)this.getProperty("DTEND");
    }

    public final Duration getDuration() {
        return (Duration)this.getProperty("DURATION");
    }

    public final DtStamp getDateStamp() {
        return (DtStamp)this.getProperty("DTSTAMP");
    }

    public final Organizer getOrganizer() {
        return (Organizer)this.getProperty("ORGANIZER");
    }

    public final Url getUrl() {
        return (Url)this.getProperty("URL");
    }

    public final Uid getUid() {
        return (Uid)this.getProperty("UID");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.log = LogFactory.getLog((Class)VFreeBusy.class);
    }
}

