/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.net.URL;
import org.eclipse.birt.report.model.api.command.CssException;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetAdapter;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.CompatibleStructureState;
import org.eclipse.birt.report.model.parser.ListPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.xml.sax.SAXException;

public class IncludedCssStyleSheetListState
extends ListPropertyState {
    IncludedCssStyleSheetListState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    @Override
    public AbstractParseState startElement(String tagName) {
        if (tagName.equalsIgnoreCase("structure")) {
            return new IncludedCssStructureState(this.handler, this.element, this.propDefn);
        }
        return super.startElement(tagName);
    }

    static class IncludedCssStructureState
    extends CompatibleStructureState {
        IncludedCssStructureState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn) {
            super(theHandler, element, propDefn);
            this.lineNumber = this.handler.getCurrentLineNo();
        }

        @Override
        public void end() throws SAXException {
            CssStyleSheet sheet;
            super.end();
            IncludedCssStyleSheet includeCss = (IncludedCssStyleSheet)this.struct;
            String fileName = includeCss.getFileName();
            String externalCssURI = includeCss.getExternalCssURI();
            boolean useExternalCss = includeCss.isUseExternalCss();
            if (externalCssURI != null && !useExternalCss) {
                includeCss.setUseExternalCss(true);
                useExternalCss = true;
            }
            if (!(this.element instanceof ICssStyleSheetOperation)) {
                return;
            }
            URL url = null;
            ICssStyleSheetOperation sheetOperation = (ICssStyleSheetOperation)((Object)this.element);
            if (fileName != null) {
                url = this.handler.module.findResource(fileName, 3);
            }
            if ((sheet = CssStyleSheetAdapter.getCssStyleSheetByProperties(this.handler.module, sheetOperation.getCsses(), url, externalCssURI, useExternalCss)) != null) {
                CssException ex = new CssException(this.handler.module, new String[]{fileName}, "Error.CSSException.DUPLICATE_CSS");
                this.handler.getErrorHandler().semanticWarning(ex);
                return;
            }
            if (fileName != null) {
                try {
                    sheet = this.handler.module.loadCss(this.element, url, fileName);
                    sheet.setExternalCssURI(externalCssURI);
                    sheet.setUseExternalCss(useExternalCss);
                    sheetOperation.addCss(sheet);
                }
                catch (StyleSheetException e) {
                    CssException ex = ModelUtil.convertSheetExceptionToCssException(this.handler.module, includeCss, fileName, e);
                    this.handler.getErrorHandler().semanticWarning(ex);
                }
            } else {
                sheet = new CssStyleSheet();
                sheet.setExternalCssURI(externalCssURI);
                sheet.setUseExternalCss(useExternalCss);
                sheet.setContainer(this.handler.module);
                sheetOperation.addCss(sheet);
            }
        }
    }
}

