/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.script.internal;

import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.item.crosstab.core.script.ICrosstabInstance;
import org.eclipse.birt.report.item.crosstab.core.script.internal.StyleInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.UserPropertyDefnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class CrosstabInstanceImpl
implements ICrosstabInstance {
    private ITableContent content;
    private DesignElementHandle modelHandle;
    private RunningState runningState;

    public CrosstabInstanceImpl(ITableContent content, DesignElementHandle modelHandle, RunningState runningState) {
        this.content = content;
        this.modelHandle = modelHandle;
        this.runningState = runningState;
    }

    public String getCaption() {
        return this.content.getCaption();
    }

    public String getCaptionKey() {
        return this.content.getCaptionKey();
    }

    public String getSummary() {
        return this.content.getSummary();
    }

    public boolean isRepeatColumnHeader() {
        return this.content.isHeaderRepeat();
    }

    public boolean isRepeatRowHeader() {
        return false;
    }

    public void setCaption(String caption) {
        this.content.setCaption(caption);
    }

    public void setCaptionKey(String key) {
        this.content.setCaptionKey(key);
    }

    public void setSummary(String summary) {
        this.content.setSummary(summary);
    }

    public void setRepeatColumnHeader(boolean repeat) {
        if (this.runningState != RunningState.CREATE) {
            if (this.runningState == RunningState.RENDER) {
                throw new UnsupportedOperationException("Repeat column header can't be set at render time.");
            }
            throw new UnsupportedOperationException("Repeat column header can't be set on page break.");
        }
        this.content.setHeaderRepeat(repeat);
    }

    public void setRepeatRowHeader(boolean repeat) {
    }

    public String getHeight() {
        DimensionType height = this.content.getHeight();
        if (height != null) {
            return height.toString();
        }
        return null;
    }

    public String getHelpText() {
        return this.content.getHelpText();
    }

    public String getHorizontalPosition() {
        DimensionType x = this.content.getX();
        if (x != null) {
            return x.toString();
        }
        return null;
    }

    public String getName() {
        return this.content.getName();
    }

    public Object getNamedExpressionValue(String name) {
        return null;
    }

    public IScriptStyle getStyle() {
        return new StyleInstance(this.content.getStyle());
    }

    public Object getUserPropertyValue(String name) {
        UserPropertyDefnHandle prop = this.modelHandle.getUserPropertyDefnHandle(name);
        if (prop != null) {
            return this.modelHandle.getProperty(prop.getName());
        }
        return null;
    }

    public String getVerticalPosition() {
        DimensionType y = this.content.getY();
        if (y != null) {
            return y.toString();
        }
        return null;
    }

    public String getWidth() {
        DimensionType width = this.content.getWidth();
        if (width != null) {
            return width.toString();
        }
        return null;
    }

    public void setHeight(String height) {
        this.content.setHeight(DimensionType.parserUnit(height));
    }

    public void setHelpText(String help) {
        this.content.setHelpText(help);
    }

    public void setHorizontalPosition(String position) {
        this.content.setX(DimensionType.parserUnit(position));
    }

    public void setName(String name) {
        this.content.setName(name);
    }

    public void setUserPropertyValue(String name, Object value) throws ScriptException {
        UserPropertyDefnHandle prop = this.modelHandle.getUserPropertyDefnHandle(name);
        if (prop != null) {
            try {
                this.modelHandle.setProperty(prop.getName(), value);
            }
            catch (SemanticException e) {
                throw new ScriptException(e.getLocalizedMessage());
            }
        }
    }

    public void setVerticalPosition(String position) {
        this.content.setY(DimensionType.parserUnit(position));
    }

    public void setWidth(String width) {
        String unit = this.content.getReportContent().getDesign().getReportDesign().getDefaultUnits();
        this.content.setWidth(DimensionType.parserUnit(width, unit));
    }
}

