/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc.document;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.toc.ITOCReader;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TreeNode;
import org.eclipse.birt.report.engine.toc.document.MemTreeNode;

public class TOCReaderV0
implements ITOCReader {
    TreeNode root;

    public TOCReaderV0(InputStream in) throws IOException {
        this(in, false);
    }

    public TOCReaderV0(InputStream in, boolean checkVersion) throws IOException {
        DataInputStream input = new DataInputStream(in);
        if (checkVersion) {
            IOUtil.readString(input);
        }
        this.root = this.readRoot(input);
    }

    public TOCReaderV0(TreeNode root) {
        this.root = root;
    }

    @Override
    public ITreeNode readTree() throws IOException {
        return this.root;
    }

    @Override
    public void close() throws IOException {
    }

    protected MemTreeNode readRoot(DataInputStream input) throws IOException {
        MemTreeNode node = new MemTreeNode();
        String nodeId = "/";
        String displayString = IOUtil.readString(input);
        String bookmark = IOUtil.readString(input);
        node.setNodeId(nodeId);
        node.setTOCValue(displayString);
        node.setBookmark(bookmark);
        int size = IOUtil.readInt(input);
        int i = 0;
        while (i < size) {
            MemTreeNode child = this.readNode(input);
            node.addChild(child);
            ++i;
        }
        return node;
    }

    public MemTreeNode readNode(DataInputStream input) throws IOException {
        MemTreeNode node = new MemTreeNode();
        String nodeId = IOUtil.readString(input);
        String displayString = IOUtil.readString(input);
        String bookmark = IOUtil.readString(input);
        node.setNodeId(nodeId);
        node.setTOCValue(displayString);
        node.setBookmark(bookmark);
        int size = IOUtil.readInt(input);
        int i = 0;
        while (i < size) {
            MemTreeNode child = this.readNode(input);
            node.addChild(child);
            ++i;
        }
        return node;
    }
}

