/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IDataItemEventHandler;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.DataItem;
import org.eclipse.birt.report.engine.script.internal.instance.DataItemInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.model.api.DataItemHandle;

public class DataItemScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(DataItemHandle dataItemHandle, ExecutionContext context) {
        try {
            DataItem dataItem = new DataItem(dataItemHandle);
            IDataItemEventHandler eh = DataItemScriptExecutor.getEventHandler(dataItemHandle, context);
            if (eh != null) {
                eh.onPrepare(dataItem, context.getReportContext());
            }
        }
        catch (Exception e) {
            DataItemScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(IDataContent content, ExecutionContext context) {
        ReportItemDesign dataItemDesign = (ReportItemDesign)content.getGenerateBy();
        if (!DataItemScriptExecutor.needOnCreate(dataItemDesign)) {
            return;
        }
        try {
            DataItemInstance dataItem = new DataItemInstance(content, context, RunningState.CREATE);
            if (DataItemScriptExecutor.handleScript(dataItem, dataItemDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IDataItemEventHandler eh = DataItemScriptExecutor.getEventHandler(dataItemDesign, context);
            if (eh != null) {
                eh.onCreate(dataItem, context.getReportContext());
            }
        }
        catch (Exception e) {
            DataItemScriptExecutor.addException(context, e, dataItemDesign.getHandle());
        }
    }

    public static void handleOnRender(IDataContent content, ExecutionContext context) {
        ReportItemDesign dataItemDesign = (ReportItemDesign)content.getGenerateBy();
        if (!DataItemScriptExecutor.needOnRender(dataItemDesign)) {
            return;
        }
        try {
            DataItemInstance dataItem = new DataItemInstance(content, context, RunningState.RENDER);
            if (DataItemScriptExecutor.handleScript(dataItem, dataItemDesign.getOnRender(), context).didRun()) {
                return;
            }
            IDataItemEventHandler eh = DataItemScriptExecutor.getEventHandler(dataItemDesign, context);
            if (eh != null) {
                eh.onRender(dataItem, context.getReportContext());
            }
        }
        catch (Exception e) {
            DataItemScriptExecutor.addException(context, e, dataItemDesign.getHandle());
        }
    }

    public static void handleOnPageBreak(IDataContent content, ExecutionContext context) {
        ReportItemDesign dataItemDesign = (ReportItemDesign)content.getGenerateBy();
        if (!DataItemScriptExecutor.needOnPageBreak(dataItemDesign, context)) {
            return;
        }
        try {
            DataItemInstance dataItem = new DataItemInstance(content, context, RunningState.PAGEBREAK);
            if (DataItemScriptExecutor.handleScript(dataItem, dataItemDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IDataItemEventHandler eh = DataItemScriptExecutor.getEventHandler(dataItemDesign, context);
            if (eh != null) {
                eh.onPageBreak(dataItem, context.getReportContext());
            }
        }
        catch (Exception e) {
            DataItemScriptExecutor.addException(context, e, dataItemDesign.getHandle());
        }
    }

    private static IDataItemEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (IDataItemEventHandler)DataItemScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            DataItemScriptExecutor.addClassCastException(context, e, design.getHandle(), IDataItemEventHandler.class);
        }
        catch (EngineException e) {
            DataItemScriptExecutor.addException(context, e, design.getHandle());
        }
        return null;
    }

    private static IDataItemEventHandler getEventHandler(DataItemHandle handle, ExecutionContext context) {
        try {
            return (IDataItemEventHandler)DataItemScriptExecutor.getInstance(handle, context);
        }
        catch (ClassCastException e) {
            DataItemScriptExecutor.addClassCastException(context, e, handle, IDataItemEventHandler.class);
        }
        catch (EngineException e) {
            DataItemScriptExecutor.addException(context, e, handle);
        }
        return null;
    }
}

