/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.excel.impl.util;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.eclipse.birt.report.data.oda.excel.impl.util.XlsxRowCallBack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XlsxFileReader {
    static final String PARSER_CLASS_NAME = "org.apache.xerces.parsers.SAXParser";
    static final String ROW_LIMIT_REACHED_EX_MSG = "Row Limit Reached";
    private final XSSFReader reader;

    public XlsxFileReader(InputStream fis) throws IOException, OpenXML4JException {
        OPCPackage pkg = OPCPackage.open(fis);
        this.reader = new XSSFReader(pkg);
    }

    public LinkedHashMap<String, String> getSheetNames() throws InvalidFormatException, IOException, SAXException {
        BufferedInputStream wbData = new BufferedInputStream(this.reader.getWorkbookData());
        LinkedHashMap<String, String> sheetMap = new LinkedHashMap<String, String>();
        try {
            InputSource wbSource = new InputSource(wbData);
            XMLReader parser = this.fetchWorkbookParser(sheetMap);
            parser.parse(wbSource);
        }
        finally {
            if (wbData != null) {
                wbData.close();
            }
        }
        return sheetMap;
    }

    public void processSheet(String rid, XlsxRowCallBack callback, int xlsxRowsToRead) throws InvalidFormatException, IOException, SAXException {
        SharedStringsTable sst = this.reader.getSharedStringsTable();
        StylesTable st = this.reader.getStylesTable();
        XMLReader parser = this.fetchSheetParser(st, sst, callback, xlsxRowsToRead);
        BufferedInputStream sheet = new BufferedInputStream(this.reader.getSheet(rid));
        try {
            InputSource sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
        }
        finally {
            if (sheet != null) {
                sheet.close();
            }
        }
    }

    private XMLReader fetchSheetParser(StylesTable st, SharedStringsTable sst, XlsxRowCallBack callback, int xlsxRowsToRead) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader(PARSER_CLASS_NAME);
        SheetHandler handler = new SheetHandler(st, sst, callback, xlsxRowsToRead);
        parser.setContentHandler(handler);
        return parser;
    }

    private XMLReader fetchWorkbookParser(LinkedHashMap<String, String> sheetMap) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader(PARSER_CLASS_NAME);
        WorkbookHandler handler = new WorkbookHandler(sheetMap);
        parser.setContentHandler(handler);
        return parser;
    }

    private static class SheetHandler
    extends DefaultHandler {
        private cDataType cellDataType;
        private int columnCount = 1;
        private final SharedStringsTable sst;
        private final StylesTable st;
        private final XlsxRowCallBack callback;
        private String lastContents;
        private ArrayList<Object> values;
        private int currentColumn = 0;
        private int xlsxRowsToRead = 0;
        private int currentXlsxRowNumber = 0;
        private SimpleDateFormat sdf;

        private SheetHandler(StylesTable st, SharedStringsTable sst, XlsxRowCallBack callback, int xlsxRowsToRead) {
            this.sst = sst;
            this.st = st;
            this.callback = callback;
            this.values = new ArrayList();
            this.cellDataType = cDataType.NUMBER;
            this.xlsxRowsToRead = xlsxRowsToRead;
            this.sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("c")) {
                String vCellType = attributes.getValue("t");
                String cellS = attributes.getValue("s");
                if ("b".equals(vCellType)) {
                    this.cellDataType = cDataType.BOOL;
                } else if ("e".equals(vCellType)) {
                    this.cellDataType = cDataType.FORMULA;
                } else if ("s".equals(vCellType)) {
                    this.cellDataType = cDataType.SSTINDEX;
                } else if ("str".equals(vCellType)) {
                    this.cellDataType = cDataType.STATIC;
                } else if (cellS != null) {
                    int styleIndex = Integer.parseInt(cellS);
                    XSSFCellStyle style = this.st.getStyleAt(styleIndex);
                    short formatIndex = style.getDataFormat();
                    String formatString = style.getDataFormatString();
                    if (formatString == null) {
                        formatString = BuiltinFormats.getBuiltinFormat((int)formatIndex);
                    }
                    this.cellDataType = DateUtil.isADateFormat((int)formatIndex, (String)formatString) ? cDataType.DATETIME : cDataType.NUMBER;
                } else {
                    this.cellDataType = cDataType.NUMBER;
                }
                String r = attributes.getValue("r");
                this.currentColumn = this.getColumnNumber(r);
                if (this.currentColumn + 1 > this.columnCount) {
                    this.callback.columnExpansion(this.currentColumn + 1);
                    int newvals = this.currentColumn + 1 - this.columnCount;
                    int ii = 0;
                    while (ii < newvals) {
                        this.values.add("");
                        ++ii;
                    }
                    this.columnCount = this.currentColumn + 1;
                }
            }
            if (qName.equals("row")) {
                int i = 0;
                while (i < this.columnCount) {
                    this.values.add(i, "");
                    ++i;
                }
            }
            this.lastContents = "";
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (name.equals("row")) {
                this.callback.handleRow(this.values);
                this.values.clear();
                this.currentColumn = -1;
                ++this.currentXlsxRowNumber;
                if (this.xlsxRowsToRead > 0 && this.currentXlsxRowNumber > this.xlsxRowsToRead) {
                    throw new SAXException(XlsxFileReader.ROW_LIMIT_REACHED_EX_MSG);
                }
                return;
            }
            if (name.equals("c")) {
                this.cellDataType = cDataType.NUMBER;
                return;
            }
            if (name.equals("v")) {
                String val = "";
                if (this.cellDataType == cDataType.SSTINDEX) {
                    int idx = Integer.parseInt(this.lastContents);
                    val = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
                } else if (this.cellDataType == cDataType.STATIC || this.cellDataType == cDataType.NUMBER) {
                    val = this.lastContents;
                } else if (this.cellDataType == cDataType.DATETIME || this.cellDataType == cDataType.DATE || this.cellDataType == cDataType.TIME) {
                    Date myjavadate = DateUtil.getJavaDate((double)Double.parseDouble(this.lastContents));
                    val = this.sdf.format(myjavadate);
                } else if (this.cellDataType == cDataType.BOOL) {
                    if (this.lastContents.compareTo("1") == 0) {
                        Boolean mybool = new Boolean(true);
                        val = mybool.toString();
                    } else if (this.lastContents.compareTo("0") == 0) {
                        Boolean mybool = new Boolean(false);
                        val = mybool.toString();
                    }
                }
                if (val != null && this.currentColumn != -1) {
                    this.values.remove(this.currentColumn);
                    this.values.add(this.currentColumn, val);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.lastContents = String.valueOf(this.lastContents) + new String(ch, start, length);
        }

        private int getColumnNumber(String colname) {
            int tmpcol = 0;
            String drpNumber = colname;
            int ch = 0;
            while (ch < colname.length()) {
                if (!Character.isLetter(colname.charAt(ch))) {
                    drpNumber = colname.substring(0, ch);
                    break;
                }
                ++ch;
            }
            int sum = 0;
            int ii = 0;
            while (ii < drpNumber.length()) {
                tmpcol = drpNumber.charAt(ii) - 65 + 1;
                sum = sum * 26 + tmpcol;
                ++ii;
            }
            return sum - 1;
        }
    }

    private static class WorkbookHandler
    extends DefaultHandler {
        private final LinkedHashMap<String, String> sheetMap;

        private WorkbookHandler(LinkedHashMap<String, String> sheetMap) {
            this.sheetMap = sheetMap;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("sheet")) {
                String rid = attributes.getValue("r:id");
                String sheetName = attributes.getValue("name");
                this.sheetMap.put(sheetName, rid);
            }
        }
    }

    static enum cDataType {
        BOOL,
        DATE,
        DATETIME,
        FORMULA,
        SSTINDEX,
        TIME,
        NUMBER,
        STATIC;

    }
}

