/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.excel.impl;

import com.ibm.icu.util.ULocale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.excel.impl.DataSetMetaData;
import org.eclipse.birt.report.data.oda.excel.impl.ExcelFileQuery;
import org.eclipse.birt.report.data.oda.excel.impl.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;

public class Connection
implements IConnection {
    private boolean isOpen = false;
    private Properties connProperties;
    private Map appContext = null;

    public void open(Properties connProperties) throws OdaException {
        if (connProperties == null) {
            throw new OdaException(Messages.getString("connection_CONNECTION_PROPERTIES_MISSING"));
        }
        this.connProperties = connProperties;
        this.validateURI();
    }

    private void validateURI() throws OdaException {
        String uri = this.connProperties.getProperty("URI");
        if (uri != null && uri.trim().length() > 0) {
            this.isOpen = true;
            return;
        }
        throw new OdaException(Messages.getString("connection_MISSING_FILELOCATION"));
    }

    public void setAppContext(Object context) throws OdaException {
        this.appContext = (Map)context;
    }

    public void close() throws OdaException {
        this.isOpen = false;
    }

    public boolean isOpen() throws OdaException {
        return this.isOpen;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        if (!this.isOpen()) {
            throw new OdaException(Messages.getString("common_CONNECTION_HAS_NOT_OPEN"));
        }
        ExcelFileQuery excelFileQuery = new ExcelFileQuery(this.connProperties);
        excelFileQuery.setAppContext(this.appContext);
        return excelFileQuery;
    }

    public ResourceIdentifiers getResourceIdentifiers() {
        return (ResourceIdentifiers)this.appContext.get("org.eclipse.datatools.connectivity.oda.util_consumerResourceIds");
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
    }

    public void rollback() throws OdaException {
    }

    public void setLocale(ULocale locale) throws OdaException {
    }
}

