/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api.timeFunction;

import com.ibm.icu.util.Calendar;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.i18n.AdapterResourceHandle;

public class DateTimeUtility {
    public static int getPortion(Object date, String timeType, Calendar calendar) throws AdapterException {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        if (date == null) {
            return new Integer(0);
        }
        if ("day-of-month".equals(timeType)) {
            return new Integer(DateTimeUtility.getCalendar(calendar, date).get(5));
        }
        if ("day-of-week".equals(timeType)) {
            return new Integer(DateTimeUtility.getCalendar(calendar, date).get(7));
        }
        if ("day-of-year".equals(timeType)) {
            return new Integer(DateTimeUtility.getCalendar(calendar, date).get(6));
        }
        if ("week-of-month".equals(timeType)) {
            return new Integer(DateTimeUtility.getCalendar(calendar, date).get(4));
        }
        if ("week-of-year".equals(timeType)) {
            return new Integer(DateTimeUtility.getCalendar(calendar, date).get(3));
        }
        if ("month".equals(timeType)) {
            return new Integer(DateTimeUtility.getCalendar(calendar, date).get(2) + 1);
        }
        if ("quarter".equals(timeType)) {
            int month = -1;
            month = DateTimeUtility.getCalendar(calendar, date).get(2);
            int quarter = -1;
            switch (month) {
                case 0: 
                case 1: 
                case 2: {
                    quarter = 1;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    quarter = 2;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    quarter = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    quarter = 4;
                    break;
                }
                default: {
                    quarter = -1;
                }
            }
            return new Integer(quarter);
        }
        if ("year".equals(timeType)) {
            return new Integer(DateTimeUtility.getCalendar(calendar, date).get(1));
        }
        if ("hour".equals(timeType)) {
            return new Integer(DateTimeUtility.getCalendar(calendar, date).get(11));
        }
        if ("minute".equals(timeType)) {
            return new Integer(DateTimeUtility.getCalendar(calendar, date).get(12));
        }
        if ("second".equals(timeType)) {
            return DateTimeUtility.getCalendar(calendar, date).get(13);
        }
        throw new AdapterException("adapter.invalid.datetimetype", timeType);
    }

    private static Calendar getCalendar(Calendar calendar, Object d) {
        assert (d != null);
        try {
            if (d instanceof java.sql.Date) {
                calendar.setTime((Date)d);
                return calendar;
            }
            Date date = DataTypeUtil.toDate(d);
            calendar.setTime(date);
            return calendar;
        }
        catch (BirtException birtException) {
            throw new IllegalArgumentException(AdapterResourceHandle.getInstance().getMessage("invalid.datetime.value"));
        }
    }
}

