/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.validation;

import java.awt.AWTEvent;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.events.XuiEventHandler;
import net.xoetrope.xui.exception.XExceptionHandler;
import net.xoetrope.xui.validation.XValidationFactory;
import net.xoetrope.xui.validation.XValidator;

public class XValidationHandler
implements XExceptionHandler {
    protected XValidationFactory validationFactory;
    protected Hashtable validations;
    protected XExceptionHandler customExceptionHandler;
    protected Object container;

    public XValidationHandler(Object object) {
        this.container = object;
    }

    public void setupEventHandler(XuiEventHandler xuiEventHandler) {
        this.setupEventHandler(xuiEventHandler, "java.awt.event.FocusListener", 4L);
    }

    public void setupEventHandler(XuiEventHandler xuiEventHandler, String string, long l) {
        this.clearValidations();
        xuiEventHandler.addHandler(this.container, "validationHandler", "addFocusListener", string, l, xuiEventHandler);
    }

    public void setExceptionHandler(XExceptionHandler xExceptionHandler) {
        this.customExceptionHandler = xExceptionHandler;
    }

    public void clearValidations() {
        this.validations = new Hashtable(5);
    }

    public XValidator addValidation(XuiEventHandler xuiEventHandler, Object object, String string, String string2, int n, XmlElement xmlElement) {
        XValidator xValidator = this.getValidation(string, string2, n, xmlElement);
        if (xValidator != null) {
            Long l = new Long(1005 * object.hashCode());
            Vector<XValidator> vector = (Vector<XValidator>)this.validations.get(l);
            if (vector == null) {
                vector = new Vector<XValidator>();
                vector.addElement((XValidator)object);
                this.validations.put(l, vector);
                switch (n) {
                    default: 
                }
                xuiEventHandler.addHandler(object, "validationHandler", "addFocusListener", "java.awt.event.FocusListener", 4L, null);
            }
            vector.addElement(xValidator);
            return xValidator;
        }
        return null;
    }

    public XValidator getValidation(String string, String string2, int n, XmlElement xmlElement) {
        Method method = null;
        if (string2 != null && string2.length() > 0) {
            try {
                method = this.container.getClass().getMethod(string2, null);
            }
            catch (Exception exception) {
                DebugLogger.logError("Validations", "Cannot find the validation method: " + string2);
            }
        }
        XValidator xValidator = this.validationFactory.getValidation(string, method, n, this.container, xmlElement);
        return xValidator;
    }

    public XValidator getValidation(String string, String string2) {
        return this.getValidation(string, string2, 0, null);
    }

    public Vector getValidations(Object object) {
        try {
            Vector vector = (Vector)this.validations.get(new Long(1005 * object.hashCode()));
            if (vector != null) {
                return vector;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void removeValidations(Object object) {
        this.validations.remove(new Long(1005 * object.hashCode()));
    }

    public XValidator addValidation(XuiEventHandler xuiEventHandler, Object object, String string, String string2) {
        return this.addValidation(xuiEventHandler, object, string, string2, 1005, null);
    }

    public XValidator addValidation(XuiEventHandler xuiEventHandler, Object object, String string) {
        return this.addValidation(xuiEventHandler, object, string, null, 1005, null);
    }

    public void setValidationFactory(XValidationFactory xValidationFactory) {
        this.validationFactory = xValidationFactory;
    }

    public int validationHandler(XuiEventHandler xuiEventHandler) {
        Object object = null;
        XValidator xValidator = null;
        int n = 0;
        try {
            object = xuiEventHandler.getCurrentEvent().getSource();
            Vector vector = (Vector)this.validations.get(new Long(1005 * object.hashCode()));
            if (vector != null) {
                for (int i = 1; i < vector.size(); ++i) {
                    xValidator = (XValidator)vector.elementAt(i);
                    if (xValidator == null || ((AWTEvent)xuiEventHandler.getCurrentEvent()).getID() != xValidator.getMask()) continue;
                    n = Math.max(n, xValidator.getLevel());
                    xValidator.validate(object, false);
                }
            }
        }
        catch (Exception exception) {
            if (this.customExceptionHandler != null) {
                this.customExceptionHandler.handleException(object, exception, xValidator);
            } else {
                this.handleException(object, exception, xValidator);
            }
            return n;
        }
        return 0;
    }

    public int checkValidations() {
        int n = 0;
        Enumeration enumeration = this.validations.elements();
        XValidator xValidator = null;
        Object var4_4 = null;
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            if (vector == null) continue;
            var4_4 = vector.elementAt(0);
            int n2 = vector.size();
            for (int i = 1; i < n2; ++i) {
                try {
                    xValidator = (XValidator)vector.elementAt(i);
                    if (xValidator == null) continue;
                    xValidator.validate(var4_4, true);
                    continue;
                }
                catch (Exception exception) {
                    n = Math.max(n, xValidator.getLevel());
                    if (this.customExceptionHandler != null) {
                        this.customExceptionHandler.handleException(var4_4, exception, xValidator);
                        continue;
                    }
                    this.handleException(var4_4, exception, xValidator);
                }
            }
        }
        return n;
    }

    public int accumulateMessages(boolean bl, int n) {
        if (this.customExceptionHandler != null) {
            return this.customExceptionHandler.accumulateMessages(bl, n);
        }
        return n;
    }

    public boolean handleException(Object object, Exception exception, Object object2) {
        exception.printStackTrace();
        return true;
    }

    public boolean handleEventHandlerException(XProject xProject, Object object, Throwable throwable) {
        return true;
    }
}

