/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.validation;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.helper.ReflectionHelper;
import net.xoetrope.xui.style.XStyleEx;
import net.xoetrope.xui.validation.XBaseValidator;
import net.xoetrope.xui.validation.XValidator;

public class XValidationFactory {
    protected static Hashtable configFiles;
    protected static int changeCounter;
    protected int localChangeCounter = -1;
    protected XProject currentProject;
    protected Hashtable validations;

    public XValidationFactory(XProject xProject) {
        URL uRL;
        this.currentProject = xProject;
        XValidationFactory.addConfigFile("XUI", "net/xoetrope/xui/validation/validations.xml", false);
        this.currentProject = xProject;
        String string = this.currentProject.getStartupParam("Validations");
        if (string == null || string.length() == 0) {
            string = "validations.xml";
        }
        if (string.indexOf(".xml") < 0) {
            string = string + ".xml";
        }
        if ((uRL = this.currentProject.findResource(string)) != null) {
            XValidationFactory.addConfigFile("Project", uRL, false);
        }
    }

    public XValidator getValidation(String string, Method method, int n, Object object, XmlElement xmlElement) {
        this.checkRegistration();
        XValidator xValidator = this.getValidation(string, n, object);
        if (xValidator != null) {
            xValidator.setValidationMethod(method, object);
        }
        return xValidator;
    }

    public XValidator getValidation(String string, int n, Object object) {
        XmlElement xmlElement = (XmlElement)this.validations.get(string);
        String string2 = xmlElement.getAttribute("type");
        String string3 = null;
        if (string2.equals("minmax")) {
            string3 = "net.xoetrope.xui.validation.XMinMaxValidator";
        } else if (string2.equals("mandatory")) {
            string3 = "net.xoetrope.xui.validation.XMandatoryValidator";
        } else if (string2.equals("custom")) {
            string3 = xmlElement.getAttribute("class");
        }
        if (string3 != null) {
            XBaseValidator xBaseValidator = null;
            try {
                Object[] objectArray = new Object[]{this.currentProject};
                xBaseValidator = (XBaseValidator)ReflectionHelper.constructViaReflection(string3, objectArray);
                xBaseValidator.setName(string);
                xBaseValidator.setMask(n);
                xBaseValidator.setup(xmlElement);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return xBaseValidator;
        }
        return null;
    }

    public static void addConfigFile(String string, Object object, boolean bl) {
        Object v;
        if (object == null) {
            return;
        }
        if (configFiles == null) {
            configFiles = new Hashtable();
        }
        if ((v = configFiles.get(string)) != null && object.equals(v)) {
            return;
        }
        ++changeCounter;
        if (v != null || bl) {
            configFiles.remove(string);
        }
        configFiles.put(string, object);
    }

    public void updateConfig() {
        ++changeCounter;
    }

    protected void read() {
        if (this.validations != null) {
            this.validations.clear();
        }
        Enumeration enumeration = configFiles.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("Project")) continue;
            this.doRead(string, configFiles.get(string));
        }
        this.doRead("Project", configFiles.get("Project"));
    }

    protected void read(String string, String string2) {
        XValidationFactory.addConfigFile(string, string2, true);
        this.doRead(string, string2);
    }

    protected void doRead(String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof URL) {
            this.doRead(string, (URL)object);
        } else {
            this.doRead(string, (String)object);
        }
    }

    protected void doRead(String string, String string2) {
        try {
            BufferedReader bufferedReader;
            String string3 = string2;
            if (string3.indexOf(".xml") < 0) {
                string3 = string3 + ".xml";
            }
            if ((bufferedReader = this.currentProject.getBufferedReader(string3, null)) != null) {
                this.read(string, bufferedReader);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void doRead(String string, URL uRL) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            if (bufferedReader != null) {
                this.read(string, bufferedReader);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void read(String string, Reader reader) {
        try {
            Object object;
            Object object2;
            XmlElement xmlElement = XmlSource.read(reader);
            String string2 = xmlElement.getAttribute("style");
            if (string2 != null) {
                object2 = (XStyleEx)this.currentProject.getStyleManager().getStyle(string2);
                object = new Color[]{(Color)((XStyleEx)object2).getStyleAsColor("colornormal"), (Color)((XStyleEx)object2).getStyleAsColor("colorwarn"), (Color)((XStyleEx)object2).getStyleAsColor("colorfail")};
                XBaseValidator.setValidationColors((Color[])object);
            }
            object2 = xmlElement.getChildren().elements();
            this.validations = new Hashtable();
            while (object2.hasMoreElements()) {
                object = (XmlElement)object2.nextElement();
                String string3 = object.getAttribute("name");
                this.validations.put(string3, object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkRegistration() {
        if (this.localChangeCounter != changeCounter) {
            this.read();
            this.localChangeCounter = changeCounter;
        }
    }
}

