/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.validation;

import net.xoetrope.xml.XmlElement;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.helper.NumberFormatter;
import net.xoetrope.xui.validation.XBaseValidator;

public class XMinMaxValidator
extends XBaseValidator {
    protected float min;
    protected float max;

    public XMinMaxValidator(XProject xProject) {
        super(xProject);
    }

    public void setup(XmlElement xmlElement) {
        String string;
        super.setup(xmlElement);
        String string2 = xmlElement.getAttribute("min");
        if (string2 != null) {
            this.min = Float.valueOf(string2).floatValue();
        }
        if ((string = xmlElement.getAttribute("max")) != null) {
            this.max = Float.valueOf(string).floatValue();
        }
        if (xmlElement.getAttribute("mandatory") != null) {
            this.mandatory = Boolean.valueOf(xmlElement.getAttribute("mandatory"));
        }
    }

    public void validate(Object object, boolean bl) throws Exception {
        Object object2;
        this.errorLevel = 0;
        this.formattedMessage = this.message;
        String string = "";
        if (this.validationMethod == null) {
            string = this.getText(object);
        } else {
            object2 = this.invokeMethod();
            if (object2 != null) {
                string = object2.toString();
            }
        }
        object2 = null;
        boolean bl2 = false;
        if (string.length() > 0 || this.mandatory) {
            float f = 0.0f;
            String string2 = null;
            if (this.validationMethod == null) {
                if (string.length() > 0) {
                    string2 = string;
                }
            } else {
                object2 = this.invokeMethod();
                if (object2 != null) {
                    string2 = object2.toString();
                }
            }
            try {
                f = this.getValue(string2);
            }
            catch (Exception exception) {
                bl2 = true;
            }
            if (this.validationMethod == null || object2 != null) {
                this.value = String.valueOf(f);
                if (string.length() == 0 && this.mandatory && !bl) {
                    bl2 = false;
                } else if (string.length() == 0 && this.mandatory && bl) {
                    bl2 = true;
                } else if (f < this.min) {
                    bl2 = true;
                } else if (f > this.max) {
                    bl2 = true;
                }
            }
        } else if (this.mandatory && bl) {
            bl2 = true;
        }
        this.applyErrorStyle(object, bl2 ? 2 : 0);
        if (bl2) {
            this.replaceToken("{min}", String.valueOf(this.getMin()).replace('.', NumberFormatter.getDecimalSeparator()));
            this.replaceToken("{max}", String.valueOf(this.getMax()).replace('.', NumberFormatter.getDecimalSeparator()));
            if (object2 != null) {
                this.replaceToken("{value}", object2.toString());
            } else {
                this.replaceToken("{value}", string);
            }
            this.errorLevel = bl ? 2 : 1;
            this.throwException();
        }
    }

    protected float getValue(String string) {
        return NumberFormatter.parseFloat(string);
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMin(float f) {
        this.min = f;
    }

    public void setMax(float f) {
        this.max = f;
    }
}

