/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.validation;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xui.WidgetAdapter;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XTextHolder;
import net.xoetrope.xui.helper.MessageHelper;
import net.xoetrope.xui.validation.XValidator;

public abstract class XBaseValidator
implements XValidator {
    public static final int USE_NORMAL_STYLE = 0;
    public static final int USE_WARN_STYLE = 1;
    public static final int USE_FAIL_STYLE = 2;
    private static Color normalColor = Color.white;
    private static Color warnColor = new Color(255, 255, 213);
    private static Color failColor = new Color(255, 230, 213);
    protected boolean mandatory;
    protected String message;
    protected String value;
    protected String formattedMessage;
    protected String validationName;
    protected Object container;
    protected Method validationMethod;
    protected int mask;
    protected int errorLevel = 0;
    protected boolean start = true;
    protected XProject currentProject;

    public XBaseValidator(XProject xProject) {
        this.currentProject = xProject;
    }

    public int getMask() {
        return this.mask;
    }

    public void setMask(int n) {
        this.mask = n;
    }

    public void setValidationMethod(Method method, Object object) {
        this.container = object;
        this.validationMethod = method;
    }

    public String getName() {
        return this.validationName;
    }

    public void setName(String string) {
        this.validationName = string;
    }

    public String getMessage() {
        return this.formattedMessage;
    }

    public void setup(XmlElement xmlElement) {
        this.formattedMessage = this.message = xmlElement.getAttribute("msg");
    }

    public String getValueAsString() {
        return this.value;
    }

    public int getLevel() {
        return this.errorLevel;
    }

    public Object invokeMethod() {
        if (this.validationMethod != null) {
            try {
                return this.validationMethod.invoke(this.container, (Object[])null);
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                return null;
            }
        }
        return "";
    }

    protected void replaceToken(String string, String string2) {
        if (this.start) {
            this.formattedMessage = this.message;
        }
        this.formattedMessage = MessageHelper.replaceToken(this.formattedMessage, string, string2);
        this.start = false;
    }

    protected void replaceTokens() {
        if (this.start) {
            this.formattedMessage = this.message;
        }
        this.formattedMessage = MessageHelper.replaceTokens(this.formattedMessage);
        this.start = false;
    }

    protected String getText(Object object) {
        return ((XTextHolder)object).getText();
    }

    protected void throwException() throws Exception {
        this.replaceTokens();
        this.start = true;
        throw new Exception(this.formattedMessage);
    }

    public void applyErrorStyle(Object object, int n) {
        if (object instanceof XTextHolder) {
            WidgetAdapter widgetAdapter = WidgetAdapter.getInstance();
            if (n == 0) {
                widgetAdapter.setBackground(object, normalColor);
            } else if (n == 1) {
                widgetAdapter.setBackground(object, warnColor);
            } else if (n == 2) {
                widgetAdapter.setBackground(object, failColor);
            }
        }
    }

    public static void setValidationColors(Color[] colorArray) {
        normalColor = colorArray[0];
        warnColor = colorArray[1];
        failColor = colorArray[2];
    }
}

