/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.style;

import java.awt.Font;
import java.io.BufferedReader;
import java.util.Enumeration;
import java.util.Hashtable;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.style.XStyle;
import net.xoetrope.xui.style.XStyleEx;

public class XStyleManager {
    protected Hashtable styles;
    protected Hashtable mergedStyles;
    protected Hashtable fontCache;
    protected static XStyle baseStyle = new XStyleEx();
    protected XProject currentProject;
    protected Hashtable fontMap;

    public XStyleManager(XProject xProject) {
        this(xProject, 10);
    }

    public XStyleManager(XProject xProject, int n) {
        this.currentProject = xProject;
        this.styles = new Hashtable(n);
        this.mergedStyles = new Hashtable(n);
        this.fontCache = new Hashtable(10);
        try {
            String string = this.currentProject.getStartupParam("StyleFile");
            if (string == null) {
                string = "styles.xml";
            }
            this.load(string);
        }
        catch (Exception exception) {
            DebugLogger.logWarning("No style file loaded!");
        }
    }

    public void addStyle(String string, XStyle xStyle) {
        this.styles.remove(string);
        this.styles.put(string, xStyle);
    }

    public XStyle getStyle(String string, boolean bl) {
        String string2 = null;
        string2 = string;
        if (string2 == null) {
            return null;
        }
        XStyle xStyle = (XStyle)this.mergedStyles.get(string2);
        if (xStyle != null) {
            return xStyle;
        }
        int n = 0;
        if (bl) {
            int n2;
            xStyle = (XStyle)baseStyle.clone();
            do {
                String string3;
                XStyle xStyle2;
                if ((xStyle2 = (XStyle)this.styles.get(string3 = (n2 = string2.indexOf("/", n)) != -1 ? string2.substring(0, n2) : string2)) instanceof XStyleEx && !(xStyle instanceof XStyleEx)) {
                    xStyle = new XStyleEx(xStyle);
                }
                xStyle.mergeStyle(xStyle2);
                n = n2 + 1;
            } while (n2 != -1);
            this.mergedStyles.put(string2, xStyle);
        }
        return xStyle;
    }

    public boolean hasStyle(String string) {
        if (this.mergedStyles.get(string) != null) {
            return true;
        }
        return this.styles.get(string) != null;
    }

    public XStyle getStyle(String string) {
        return this.getStyle(string, true);
    }

    public Font getFont(String string) {
        return this.getFont(this.getStyle(string));
    }

    public Font getFont(XStyle xStyle) {
        String string;
        Font font = (Font)this.fontCache.get(xStyle.getFontHashcode());
        if (font != null) {
            return font;
        }
        int n = xStyle.getStyleAsInt(2);
        int n2 = xStyle.getStyleAsInt(3);
        int n3 = 0;
        if (n == 1) {
            n3 = 1;
        }
        if (n2 == 1) {
            n3 |= 2;
        }
        if ((string = xStyle.getStyleAsString(0)) == null) {
            return null;
        }
        int n4 = xStyle.getStyleAsInt(1);
        if (this.fontMap != null) {
            String string2 = (String)this.fontMap.get(string + n4);
            if (string2 != null) {
                string = string2;
            } else {
                string2 = (String)this.fontMap.get(string);
                if (string2 != null) {
                    string = string2;
                }
            }
            int n5 = string.indexOf(59);
            if (n5 > 0) {
                n4 = new Integer(string.substring(n5 + 1));
                string = string.substring(0, n5);
            }
        }
        font = new Font(string, n3, n4);
        this.fontCache.put(xStyle.getFontHashcode(), font);
        return font;
    }

    public void setFontMap(Hashtable hashtable) {
        this.fontCache = new Hashtable();
        this.fontMap = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("font_")) continue;
            this.fontMap.put(string.substring(5), hashtable.get(string));
        }
    }

    public void load(String string) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = this.currentProject.getBufferedReader(string, null);
            if (bufferedReader != null) {
                XmlElement xmlElement = XmlSource.read(bufferedReader);
                this.loadXStyle(xmlElement, null);
                baseStyle = this.getStyle("base");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadXStyle(XmlElement xmlElement, String string) {
        Object object;
        Enumeration enumeration = xmlElement.getChildren().elements();
        XStyleEx xStyleEx = new XStyleEx();
        while (enumeration.hasMoreElements()) {
            object = (XmlElement)enumeration.nextElement();
            String string2 = object.getName();
            if (string2.equals("style")) {
                String string3 = xmlElement.getAttribute("name");
                if (string != null && string.length() > 0) {
                    string3 = string + "/" + xmlElement.getAttribute("name");
                }
                this.loadXStyle((XmlElement)object, string3);
                continue;
            }
            ((XStyle)xStyleEx).setStyle(((XStyle)xStyleEx).getStyleIndex(string2), object.getAttribute("value"));
        }
        ((XStyle)xStyleEx).setClosed(true);
        object = xmlElement.getAttribute("name");
        if (string != null && string.length() > 0) {
            object = string + "/" + (String)object;
        }
        if (object != null && ((String)object).length() > 0) {
            this.addStyle((String)object, xStyleEx);
        }
    }

    public Hashtable getStyles() {
        return this.styles;
    }

    public XStyle getStyleParent(String string) {
        if (string.indexOf("/") > 0) {
            return this.getStyle("base/" + string.substring(0, string.lastIndexOf("/")));
        }
        return null;
    }

    public void reset() {
        this.styles.clear();
        this.mergedStyles.clear();
        this.fontCache.clear();
    }
}

