/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.style;

import java.io.ObjectInputStream;
import java.io.StringBufferInputStream;
import net.xoetrope.xui.style.XStyle;

public class XStyleEx
extends XStyle {
    private String[] attributeNames;
    private boolean closed;

    public XStyleEx() {
        this.closed = false;
    }

    public XStyleEx(XStyle xStyle) {
        this.setNumStyles(xStyle.values.length);
        for (int i = 0; i < xStyle.values.length; ++i) {
            this.values[i] = xStyle.values[i];
        }
        this.closed = false;
    }

    public Object clone() {
        int n;
        XStyleEx xStyleEx = new XStyleEx();
        xStyleEx.setNumStyles(this.values.length);
        for (n = 0; n < this.values.length; ++n) {
            xStyleEx.values[n] = this.values[n];
        }
        n = 0;
        if (this.attributeNames != null) {
            n = this.attributeNames.length;
        }
        for (int i = 0; i < n; ++i) {
            xStyleEx.attributeNames[i] = this.attributeNames[i];
        }
        xStyleEx.closed = this.closed;
        return xStyleEx;
    }

    public void mergeStyle(XStyle xStyle) {
        if (xStyle == null) {
            return;
        }
        super.mergeStyle(xStyle);
        if (xStyle instanceof XStyleEx) {
            XStyleEx xStyleEx = (XStyleEx)xStyle;
            if (xStyleEx.attributeNames != null) {
                for (int i = 0; i < xStyleEx.attributeNames.length; ++i) {
                    int n = this.getStyleIndex(xStyleEx.getStyleName(6 + i));
                    this.setStyle(n, xStyleEx.getStyleValue(6 + i));
                }
            }
        }
    }

    public void setClosed(boolean bl) {
        this.closed = bl;
    }

    public void setStyle(int n, Object object) {
        if (n >= 6 && object instanceof String) {
            String string = (String)object;
            if (string.equals("true")) {
                this.values[n] = Boolean.TRUE;
                return;
            }
            if (string.equals("false")) {
                this.values[n] = Boolean.FALSE;
                return;
            }
            try {
                char c = string.charAt(0);
                if (c == '-' || c == '.' || Character.isDigit(c)) {
                    this.values[n] = string.indexOf(46) >= 0 ? (Number)(string.indexOf(70) >= 0 ? (Number)new Float(string) : (Number)new Double(string)) : (Number)new Integer(string);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n2 = string.indexOf(91);
            if (n2 > 0) {
                String string2 = string.substring(n2 + 1, string.indexOf(93));
                String string3 = string.substring(0, n2);
                if (string2.equals("Color")) {
                    this.values[n] = XStyle.parseColor(string3);
                    return;
                }
                if (string2.equals("ser")) {
                    try {
                        ObjectInputStream exception = new ObjectInputStream(new StringBufferInputStream(string3));
                        this.values[n] = exception.readObject();
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        super.setStyle(n, object);
    }

    public int getStyleIndex(String string) {
        int n;
        int n2 = 0;
        if (this.attributeNames != null) {
            n2 = this.attributeNames.length;
        }
        for (n = 0; n < n2; ++n) {
            if (!this.attributeNames[n].equalsIgnoreCase(string)) continue;
            return n + 6;
        }
        n = super.getStyleIndex(string);
        if (n >= 0) {
            return n;
        }
        if (!this.closed) {
            return this.addStyleName(string);
        }
        return -1;
    }

    public String getStyleName(int n) {
        int n2 = n - 6;
        if (n2 >= 0 && n2 < this.attributeNames.length) {
            return this.attributeNames[n2];
        }
        return super.getStyleName(n);
    }

    public int addStyleName(String string) {
        String[] stringArray = this.attributeNames;
        int n = 0;
        if (this.attributeNames != null) {
            n = this.attributeNames.length;
        }
        this.attributeNames = new String[n + 1];
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, this.attributeNames, 0, stringArray.length);
        }
        this.attributeNames[n] = string;
        super.setNumStyles(6 + n + 1);
        return n + 6;
    }

    public int getStyleAsInt(String string) {
        return super.getStyleAsInt(this.getStyleIndex(string));
    }

    public String getStyleAsString(String string) {
        return super.getStyleAsString(this.getStyleIndex(string));
    }

    public Object getStyleAsColor(String string) {
        int n = this.getStyleIndex(string);
        Object object = super.getStyleAsColor(n);
        if (object == null) {
            String string2 = this.values[n].toString();
            object = XStyleEx.parseColor(string2);
        }
        return object;
    }
}

