/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.style;

import java.awt.Color;
import java.awt.SystemColor;
import java.io.Serializable;

public class XStyle
implements Cloneable {
    public static final int FONT_FACE = 0;
    public static final int FONT_SIZE = 1;
    public static final int FONT_WEIGHT = 2;
    public static final int FONT_ITALIC = 3;
    public static final int COLOR_BACK = 4;
    public static final int COLOR_FORE = 5;
    public static final int NUM_DEFAULT_STYLES = 6;
    protected Object[] values = new Object[6];
    private Integer fontHashcode = null;

    public void setNumStyles(int n) {
        if (n <= this.values.length) {
            return;
        }
        Object[] objectArray = new Object[Math.max(6, n)];
        System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
        this.values = objectArray;
    }

    public int getNumStyles() {
        return this.values.length;
    }

    public void setClosed(boolean bl) {
    }

    public int getStyleIndex(String string) {
        if ((string = string.toLowerCase()).equals("font_face")) {
            return 0;
        }
        if (string.equals("font_size")) {
            return 1;
        }
        if (string.equals("font_weight")) {
            return 2;
        }
        if (string.equals("font_italic")) {
            return 3;
        }
        if (string.equals("color_back")) {
            return 4;
        }
        if (string.equals("color_fore")) {
            return 5;
        }
        return -1;
    }

    public String getStyleName(int n) {
        switch (n) {
            case 0: {
                return "font_face";
            }
            case 1: {
                return "font_size";
            }
            case 2: {
                return "font_weight";
            }
            case 3: {
                return "font_italic";
            }
            case 4: {
                return "color_back";
            }
            case 5: {
                return "color_fore";
            }
        }
        return null;
    }

    public Object clone() {
        XStyle xStyle = new XStyle();
        xStyle.setNumStyles(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            xStyle.values[i] = this.values[i];
        }
        return xStyle;
    }

    public void setStyle(int n, Object object) {
        if (object instanceof String) {
            String string = object.toString();
            switch (n) {
                case 4: 
                case 5: {
                    this.values[n] = XStyle.parseColor(string);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.values[n] = new Integer(string);
                    break;
                }
                default: {
                    this.values[n] = object;
                    break;
                }
            }
        } else {
            this.values[n] = object;
        }
    }

    public void setStyle(int n, int n2) {
        this.values[n % 6] = new Integer(n2);
    }

    public int getStyleAsInt(int n) {
        Object object = this.values[n];
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public String getStyleAsString(int n) {
        Object object = this.values[n];
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public Object getStyleValue(int n) {
        return this.values[n];
    }

    public Color getStyleAsColor(int n) {
        Object object = this.values[n];
        if (object instanceof Color) {
            return (Color)object;
        }
        return null;
    }

    public void mergeStyle(XStyle xStyle) {
        if (xStyle == null) {
            return;
        }
        for (int i = 0; i < xStyle.values.length; ++i) {
            if (xStyle.values[i] == null) continue;
            this.setNumStyles(Math.max(this.values.length, xStyle.values.length));
            this.values[i] = xStyle.values[i];
        }
    }

    public Integer getFontHashcode() {
        if (this.fontHashcode != null) {
            return this.fontHashcode;
        }
        int n = 0;
        if (this.values[1] != null) {
            n += ((Integer)this.values[1]).intValue();
        }
        if (this.values[3] != null) {
            n += 1000 * (Integer)this.values[3];
        }
        if (this.values[2] != null) {
            n += 2000 * (Integer)this.values[2];
        }
        if (this.values[0] != null) {
            this.fontHashcode = new Integer((this.values[0] + Integer.toString(n)).hashCode());
            return this.fontHashcode;
        }
        this.fontHashcode = new Integer(Integer.toString(n).hashCode());
        return this.fontHashcode;
    }

    public static Object parseColor(String string) {
        Serializable serializable;
        block7: {
            try {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 255;
                int n5 = string.indexOf(44);
                if (n5 > 0) {
                    n3 = Integer.parseInt(string.substring(0, n5++));
                    int n6 = n5;
                    n5 = string.indexOf(44, n5);
                    n2 = Integer.parseInt(string.substring(n6, n5++));
                    n6 = n5;
                    if ((n5 = string.indexOf(44, n5)) > 0) {
                        n = Integer.parseInt(string.substring(n6, n5++));
                        n4 = Integer.parseInt(string.substring(n5));
                    } else {
                        n = Integer.parseInt(string.substring(n6));
                    }
                    serializable = new Color(n3, n2, n, n4);
                    break block7;
                }
                n3 = Integer.parseInt(string.substring(0, 2), 16);
                n2 = Integer.parseInt(string.substring(2, 4), 16);
                n = Integer.parseInt(string.substring(4, 6), 16);
                try {
                    n4 = Integer.parseInt(string.substring(6, 8), 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                serializable = new Color(n3, n2, n, n4);
            }
            catch (Exception exception) {
                serializable = string.equals("activeCaption") ? SystemColor.activeCaption : (string.equals("desktop") ? SystemColor.desktop : (string.equals("activeCaptionText") ? SystemColor.activeCaptionText : (string.equals("activeCaptionBorder") ? SystemColor.activeCaptionBorder : (string.equals("inactiveCaption") ? SystemColor.inactiveCaption : (string.equals("inactiveCaptionText") ? SystemColor.inactiveCaptionText : (string.equals("inactiveCaptionBorder") ? SystemColor.inactiveCaptionBorder : (string.equals("window") ? SystemColor.window : (string.equals("windowBorder") ? SystemColor.windowBorder : (string.equals("windowText") ? SystemColor.windowText : (string.equals("menu") ? SystemColor.menu : (string.equals("menuText") ? SystemColor.menuText : (string.equals("text") ? SystemColor.text : (string.equals("textText") ? SystemColor.textText : (string.equals("textHighlight") ? SystemColor.textHighlight : (string.equals("textHighlightText") ? SystemColor.textHighlightText : (string.equals("textInactiveText") ? SystemColor.textInactiveText : (string.equals("control") ? SystemColor.control : (string.equals("controlText") ? SystemColor.controlText : (string.equals("controlHighlight") ? SystemColor.controlHighlight : (string.equals("controlLtHighlight") ? SystemColor.controlLtHighlight : (string.equals("controlShadow") ? SystemColor.controlShadow : (string.equals("controlDkShadow") ? SystemColor.controlDkShadow : (string.equals("scrollbar") ? SystemColor.scrollbar : (string.equals("info") ? SystemColor.info : (string.equals("infoText") ? SystemColor.infoText : (string.equals("white") ? Color.white : (string.equals("lightGray") ? Color.lightGray : (string.equals("gray") ? Color.gray : (string.equals("darkGray") ? Color.darkGray : (string.equals("black") ? Color.black : (string.equals("red") ? Color.red : (string.equals("pink") ? Color.pink : (string.equals("orange") ? Color.orange : (string.equals("yellow") ? Color.yellow : (string.equals("green") ? Color.green : (string.equals("magenta") ? Color.magenta : (string.equals("cyan") ? Color.green : (string.equals("blue") ? Color.blue : new Integer(string)))))))))))))))))))))))))))))))))))))));
            }
        }
        return serializable;
    }
}

