/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.registry;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.registry.XInspector;
import net.xoetrope.xui.registry.XInspectorRegistrationEntry;
import net.xoetrope.xui.registry.XRegistrationEntry;
import net.xoetrope.xui.registry.XRegistrationSetup;

public abstract class XRegistrationFactory {
    public static final int CLASS_MATCH = 0;
    public static final int INTERFACE_MATCH = 1;
    public static final int INSTANCE_MATCH = 2;
    public static final int INSPECTOR_MATCH = 3;
    private static final int NUM_MATCH_MODES = 4;
    protected ArrayList[] handlerRegisters;
    protected static Hashtable configFiles;
    protected static int changeCounter;
    private String factoryObjectName;
    protected int localChangeCounter = -1;
    private XProject currentProject;

    protected XRegistrationFactory(XProject xProject, String string, String string2, String string3, String string4) {
        URL uRL;
        this.factoryObjectName = string;
        XRegistrationFactory.addConfigFile("XUI", string2, false);
        this.currentProject = xProject;
        this.currentProject.setObject(string, this);
        String string5 = this.currentProject.getStartupParam(string3);
        if (string5 == null || string5.length() == 0) {
            string5 = string4;
        }
        if (string5.indexOf(".xml") < 0) {
            string5 = string5 + ".xml";
        }
        if ((uRL = this.currentProject.findResource(string5)) != null) {
            XRegistrationFactory.addConfigFile("Project", uRL, false);
        }
    }

    public abstract String getFactoryName();

    public Object getObject(Object object, Hashtable hashtable) {
        this.checkRegistration();
        String string = object.getClass().getName();
        for (int i = 3; i >= 0; --i) {
            int n = this.handlerRegisters[i].size();
            for (int j = 0; j < n; ++j) {
                XRegistrationEntry xRegistrationEntry = (XRegistrationEntry)this.handlerRegisters[i].get(j);
                if (xRegistrationEntry.matchMode != i || !xRegistrationEntry.matches(i, object, xRegistrationEntry.registrationConfig, hashtable)) continue;
                try {
                    XRegistrationSetup xRegistrationSetup = (XRegistrationSetup)Class.forName(xRegistrationEntry.className.trim()).newInstance();
                    xRegistrationSetup.setup(this.currentProject, object, xRegistrationEntry.registrationConfig, hashtable);
                    return xRegistrationSetup;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void addConfigFile(String string, Object object, boolean bl) {
        Object v;
        if (object == null) {
            return;
        }
        if (configFiles == null) {
            configFiles = new Hashtable();
        }
        if ((v = configFiles.get(string)) != null && object.equals(v)) {
            return;
        }
        ++changeCounter;
        if (v != null || bl) {
            configFiles.remove(string);
        }
        configFiles.put(string, object);
    }

    public void updateConfig() {
        ++changeCounter;
    }

    protected void read() {
        this.handlerRegisters = new ArrayList[4];
        for (int i = 0; i < 4; ++i) {
            this.handlerRegisters[i] = new ArrayList();
        }
        Enumeration enumeration = configFiles.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("Project")) continue;
            this.doRead(string, configFiles.get(string));
        }
        this.doRead("Project", configFiles.get("Project"));
    }

    protected void read(String string, String string2) {
        XRegistrationFactory.addConfigFile(string, string2, true);
        this.doRead(string, string2);
    }

    protected void doRead(String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof URL) {
            this.doRead(string, (URL)object);
        } else {
            this.doRead(string, (String)object);
        }
    }

    protected void doRead(String string, String string2) {
        try {
            BufferedReader bufferedReader;
            String string3 = string2;
            if (string3.indexOf(".xml") < 0) {
                string3 = string3 + ".xml";
            }
            if ((bufferedReader = this.currentProject.getBufferedReader(string3, null)) != null) {
                this.read(string, bufferedReader);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void doRead(String string, URL uRL) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            if (bufferedReader != null) {
                this.read(string, bufferedReader);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void read(String string, Reader reader) {
        try {
            XmlElement xmlElement = XmlSource.read(reader);
            Vector vector = xmlElement.getChildren();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
                String string2 = xmlElement2.getName();
                int n2 = string2.equals("InspectorTransferHandlers") ? 3 : (string2.equals("ClassTransferHandlers") ? 0 : (string2.equals("InterfaceTransferHandlers") ? 1 : 2));
                this.addRegistrationTypes(xmlElement2, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addRegistrationTypes(XmlElement xmlElement, int n) {
        try {
            Vector vector = xmlElement.getChildren();
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                XRegistrationEntry xRegistrationEntry;
                XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
                if (n == 3) {
                    xRegistrationEntry = new XInspectorRegistrationEntry();
                    try {
                        String string = xmlElement2.getAttribute("inspector");
                        if (string != null) {
                            Class<?> clazz = Class.forName(string);
                            xRegistrationEntry.inspector = (XInspector)clazz.newInstance();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    xRegistrationEntry = new XRegistrationEntry();
                }
                xRegistrationEntry.matchMode = n;
                xRegistrationEntry.target = xmlElement2.getAttribute("target");
                xRegistrationEntry.className = xmlElement2.getAttribute("class");
                this.handlerRegisters[n].add(xRegistrationEntry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkRegistration() {
        if (this.localChangeCounter != changeCounter) {
            this.read();
            this.localChangeCounter = changeCounter;
        }
    }
}

