/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.helper;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ResourceBundle;
import net.xoetrope.xui.WidgetAdapter;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.helper.ReflectionHelper;
import net.xoetrope.xui.style.XStyle;
import net.xoetrope.xui.style.XStyleComponent;
import net.xoetrope.xui.style.XStyleManager;

public class XuiUtilities {
    public static int count(String string, char c) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static int count(String string, char c, char c2, char c3) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c4 = string.charAt(i);
            if (c4 == c) {
                ++n;
                continue;
            }
            if (c4 != c2) continue;
            i = XuiUtilities.indexOfMatchingEnding(string, c2, c3, i + 1);
        }
        return n;
    }

    public static void centerOnScreen(Container container) {
        Container container2;
        for (container2 = container; container2 != null && !(container2 instanceof Window); container2 = container2.getParent()) {
        }
        if (container2 != null) {
            Window window = (Window)container2;
            Dimension dimension = window.getToolkit().getScreenSize();
            Dimension dimension2 = window.getSize();
            dimension.height /= 2;
            dimension.width /= 2;
            dimension2.height /= 2;
            dimension2.width /= 2;
            int n = dimension.height - dimension2.height;
            int n2 = dimension.width - dimension2.width;
            window.setLocation(n2, n);
        }
    }

    public static void invokeLater(Runnable runnable) {
        try {
            Class[] classArray = new Class[]{Runnable.class};
            Class<?> clazz = Class.forName("javax.swing.SwingUtilities");
            Method method = clazz.getMethod("invokeLater", classArray);
            Object[] objectArray = new Object[]{runnable};
            if (method != null) {
                method.invoke(null, objectArray);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            exception.getCause().printStackTrace();
        }
    }

    public static void invokeAndWait(Runnable runnable) {
        try {
            Class[] classArray = new Class[]{Runnable.class};
            Class<?> clazz = Class.forName("javax.swing.SwingUtilities");
            Method method = clazz.getMethod("invokeAndWait", classArray);
            Object[] objectArray = new Object[]{runnable};
            if (method != null) {
                method.invoke(null, objectArray);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            exception.getCause().printStackTrace();
        }
    }

    public static String translate(XProject xProject, String string) {
        ResourceBundle resourceBundle = xProject.getResourceBundle(xProject.getStartupParam("Language"));
        String string2 = string;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static Color unsaturateColor(Color color, int n) {
        if (n == 100) {
            return color;
        }
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return new Color(Color.HSBtoRGB(fArray[0], (float)n * fArray[1] / 100.0f, fArray[2]));
    }

    public static Color brightenColor(Color color, int n) {
        if (n == 100) {
            return color;
        }
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return new Color(Color.HSBtoRGB(fArray[0], fArray[1], (float)n * fArray[2] / 100.0f));
    }

    public static void getArguments(String string, Class[] classArray, Object[] objectArray, char c) {
        int n = 0;
        int n2 = classArray.length;
        for (int i = 0; i < n2; ++i) {
            String string2;
            int n3 = string.indexOf(c, n);
            if (n3 > -1) {
                string2 = string.substring(n, n3);
                n = n3 + 1;
            } else {
                string2 = string.substring(n);
                n2 = 0;
            }
            string2 = string2.trim();
            char c2 = string2.charAt(0);
            if (Character.isDigit(c2) || c2 == '-') {
                objectArray[i] = new Integer(string2);
                classArray[i] = Integer.TYPE;
                continue;
            }
            if (string2.equals("true") || string2.equals("false")) {
                objectArray[i] = string2.equals("true") ? Boolean.TRUE : Boolean.FALSE;
                classArray[i] = Boolean.TYPE;
                continue;
            }
            objectArray[i] = string2;
            classArray[i] = String.class;
        }
    }

    public static void getArguments(String string, Class[] classArray, Object[] objectArray, char c, char c2, char c3) {
        int n = string.length();
        int n2 = 0;
        int n3 = classArray.length;
        for (int i = 0; i < n3; ++i) {
            String string2;
            char c4;
            int n4;
            for (n4 = n2; n4 < n && (c4 = string.charAt(n4)) != c; ++n4) {
                if (c4 != c2) continue;
                n4 = XuiUtilities.indexOfMatchingEnding(string, c2, c3, n4 + 1);
            }
            if (n4 > -1) {
                string2 = string.substring(n2, n4);
                n2 = n4 + 1;
            } else {
                string2 = string.substring(n2);
                n3 = 0;
            }
            string2 = string2.trim();
            char c5 = string2.charAt(0);
            if (Character.isDigit(c5) || c5 == '-') {
                objectArray[i] = new Integer(string2);
                classArray[i] = Integer.TYPE;
                continue;
            }
            if (string2.equals("true") || string2.equals("false")) {
                objectArray[i] = string2.equals("true") ? Boolean.TRUE : Boolean.FALSE;
                classArray[i] = Boolean.TYPE;
                continue;
            }
            objectArray[i] = string2;
            classArray[i] = String.class;
        }
    }

    public static void applyStyle(XProject xProject, Object object, String string) {
        XStyleManager xStyleManager = xProject.getStyleManager();
        XStyle xStyle = xStyleManager.getStyle(string);
        WidgetAdapter widgetAdapter = WidgetAdapter.getInstance();
        if (xStyle != null) {
            widgetAdapter.setFont(object, xStyleManager.getFont(xStyle));
            widgetAdapter.setBackground(object, xStyle.getStyleAsColor(4));
            widgetAdapter.setForeground(object, xStyle.getStyleAsColor(5));
            if (object instanceof XStyleComponent) {
                ((XStyleComponent)object).setStyle(string);
            }
        }
    }

    public static int getMinorVersion() {
        String string = System.getProperty("java.version");
        int n = string.indexOf(46);
        int n2 = string.indexOf(46, ++n);
        return new Integer(string.substring(n, n2));
    }

    public static int indexOfMatchingEnding(String string, char c, char c2, int n) {
        int n2 = string.indexOf(c, n);
        int n3 = string.indexOf(c2, n);
        while (n2 >= 0 && n2 < n3 && (n2 = string.indexOf(c, n = n3 + 1)) >= 0) {
            n3 = string.indexOf(c2, n);
        }
        return n3;
    }

    public static String replace(String string, String string2, String string3) {
        int n = 0;
        while ((n = string.indexOf(string2)) >= 0) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    public static String exec(String[] stringArray) {
        String string = null;
        String string2 = null;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            System.out.println("Here is the standard output of the command:\n");
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string2 + string;
                System.out.println(string);
            }
            System.out.println("Here is the standard error of the command (if any):\n" + string);
            while ((string = bufferedReader2.readLine()) != null) {
                System.out.println(string);
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to run the command [" + stringArray[0] + "] - here's the error: ");
            iOException.printStackTrace();
            return null;
        }
        return string2;
    }

    public static String getRegistryEntry(String string) {
        try {
            String string2;
            Process process = Runtime.getRuntime().exec("REG QUERY " + string);
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                string3 = string3 + string2;
            }
            return string3;
        }
        catch (Exception exception) {
            System.err.println("Encountered error : \n\n" + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public static Point getMaxCoordinates(Container container) {
        Point point = container.getLocation();
        int n = point.x;
        int n2 = point.y;
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getSize();
            Point point2 = component.getLocation();
            n = Math.max(point.x + point2.x + dimension.width, n);
            n2 = Math.max(point.y + point2.y + dimension.height, n2);
            if (!(component instanceof Container)) continue;
            Point point3 = XuiUtilities.getMaxCoordinates((Container)component);
            n = Math.max(point3.x, n);
            n2 = Math.max(point3.y, n2);
        }
        return new Point(n, n2);
    }

    public static String colorToHexString(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        String string = "" + (n < 16 ? "0" : "") + Integer.toString(n, 16) + (n2 < 16 ? "0" : "") + Integer.toString(n2, 16) + (n3 < 16 ? "0" : "") + Integer.toString(n3, 16) + (n4 < 16 ? "0" : "") + (n4 != 255 ? Integer.toString(n4, 16) : "");
        return string;
    }

    public static URL checkUrl(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            inputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return uRL;
    }

    public static int getFileCount(File file) {
        int n = 0;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                ++n;
                continue;
            }
            n += XuiUtilities.getFileCount(fileArray[i]);
        }
        return n;
    }

    public static boolean hasFiles(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile() && !XuiUtilities.hasFiles(fileArray[i])) continue;
            return true;
        }
        return false;
    }

    public static BufferedImage createCompatibleImage(Graphics2D graphics2D, BufferedImage bufferedImage) {
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        if (bufferedImage.getColorModel().equals(graphicsConfiguration.getColorModel())) {
            return bufferedImage;
        }
        int n = (Integer)ReflectionHelper.getViaReflection("getTransparency", bufferedImage);
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.dispose();
        return bufferedImage2;
    }

    public static BufferedImage createCompatibleImage(Graphics2D graphics2D, int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2);
        return bufferedImage;
    }
}

