/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.helper;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import net.xoetrope.xui.LayoutHelper;
import net.xoetrope.xui.WidgetAdapter;
import net.xoetrope.xui.helper.ReflectionHelper;

public class XLayoutHelper
implements LayoutHelper {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;

    public Object addLayout(Object object, int n) {
        try {
            LayoutManager layoutManager = null;
            switch (n) {
                case 1: {
                    layoutManager = new BorderLayout();
                    break;
                }
                case 2: {
                    layoutManager = new FlowLayout();
                    break;
                }
                case 3: {
                    layoutManager = new CardLayout();
                    break;
                }
                case 4: {
                    layoutManager = new GridLayout();
                    break;
                }
                case 5: {
                    layoutManager = new GridBagLayout();
                    break;
                }
                case 6: {
                    Object[] objectArray = new Object[]{object, "0"};
                    layoutManager = (LayoutManager)ReflectionHelper.constructViaReflection("javax.swing.BoxLayout", objectArray);
                    break;
                }
                case 7: {
                    layoutManager = (LayoutManager)Class.forName("javax.swing.SpringLayout").newInstance();
                    break;
                }
                case 8: {
                    layoutManager = (LayoutManager)Class.forName("net.xoetrope.optional.layout.ScaleLayout").newInstance();
                    break;
                }
                case 9: {
                    layoutManager = (LayoutManager)Class.forName("net.xoetrope.optional.layout.GuideLayoutEx").newInstance();
                    break;
                }
                case 10: {
                    layoutManager = (LayoutManager)Class.forName("net.xoetrope.optional.layout.LayerLayout").newInstance();
                    break;
                }
                case 11: {
                    layoutManager = (LayoutManager)Class.forName("net.xoetrope.optional.layout.ColumnLayout").newInstance();
                    break;
                }
            }
            WidgetAdapter.getInstance().setLayout(object, layoutManager);
            return layoutManager;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object addLayout(Object object, int n, Hashtable hashtable) {
        LayoutManager layoutManager = null;
        if (n != 6) {
            layoutManager = (LayoutManager)this.addLayout(object, n);
        }
        if (hashtable != null) {
            switch (n) {
                case 1: {
                    ((BorderLayout)layoutManager).setHgap(this.getIntAttrib(hashtable, "hgap"));
                    ((BorderLayout)layoutManager).setVgap(this.getIntAttrib(hashtable, "vgap"));
                    break;
                }
                case 2: {
                    ((FlowLayout)layoutManager).setHgap(this.getIntAttrib(hashtable, "hgap"));
                    ((FlowLayout)layoutManager).setVgap(this.getIntAttrib(hashtable, "vgap"));
                    String string = (String)hashtable.get("alignment");
                    if (string == null) break;
                    ((FlowLayout)layoutManager).setAlignment(this.getAlignment(string));
                    break;
                }
                case 3: {
                    ((CardLayout)layoutManager).setHgap(this.getIntAttrib(hashtable, "hgap"));
                    ((CardLayout)layoutManager).setVgap(this.getIntAttrib(hashtable, "vgap"));
                    break;
                }
                case 4: {
                    ((GridLayout)layoutManager).setHgap(this.getIntAttrib(hashtable, "hgap"));
                    ((GridLayout)layoutManager).setVgap(this.getIntAttrib(hashtable, "vgap"));
                    int n2 = this.getIntAttrib(hashtable, "rows");
                    int n3 = this.getIntAttrib(hashtable, "cols");
                    if (n2 <= 0 && n3 <= 0) break;
                    if (n2 == 0) {
                        ((GridLayout)layoutManager).setColumns(n3);
                        ((GridLayout)layoutManager).setRows(n2);
                        break;
                    }
                    ((GridLayout)layoutManager).setRows(n2);
                    ((GridLayout)layoutManager).setColumns(n3);
                    break;
                }
                case 6: {
                    String string = (String)hashtable.get("layoutStyle");
                    Object[] objectArray = new Object[]{object, this.getBoxAlignment(string)};
                    try {
                        Class[] classArray = new Class[]{Container.class, Integer.TYPE};
                        Constructor<?> constructor = Class.forName("javax.swing.BoxLayout").getConstructor(classArray);
                        layoutManager = (LayoutManager)constructor.newInstance(objectArray);
                        WidgetAdapter.getInstance().setLayout(object, layoutManager);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    ReflectionHelper.setErrorMode(1);
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        this.setAttrib(object, layoutManager, string, hashtable.get(string));
                    }
                    ReflectionHelper.setErrorMode(0);
                    break;
                }
            }
        }
        return layoutManager;
    }

    public int getAlignment(String string) {
        int n = 1;
        if ((string = string.toUpperCase()) == null) {
            return n;
        }
        if (string.compareTo("LEADING") == 0) {
            return 3;
        }
        if (string.compareTo("CENTER") == 0) {
            return 1;
        }
        if (string.compareTo("LEFT") == 0) {
            return 0;
        }
        if (string.compareTo("RIGHT") == 0) {
            return 2;
        }
        if (string.compareTo("TRAILING") == 0) {
            return 4;
        }
        try {
            n = Integer.parseInt(string);
            n = Math.max(0, Math.min(n, 4));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public int getLayoutType(String string) {
        if ((string = string.toUpperCase()) == null || string.length() == 0 || string.equals("NULL")) {
            return 0;
        }
        if (string.equals("FLOW")) {
            return 2;
        }
        if (string.equals("BORDER")) {
            return 1;
        }
        if (string.equals("GRID")) {
            return 4;
        }
        if (string.equals("GRIDBAG")) {
            return 5;
        }
        if (string.equals("CARD")) {
            return 3;
        }
        if (string.equals("BOX")) {
            return 6;
        }
        if (string.equals("GUIDE")) {
            return 9;
        }
        if (string.equals("SCALE")) {
            return 8;
        }
        if (string.equals("SPRING")) {
            return 7;
        }
        if (string.equals("LAYER")) {
            return 10;
        }
        if (string.equals("COLUMN")) {
            return 11;
        }
        return 0;
    }

    public String getLayoutClass(Object object) {
        if (object != null) {
            String string = object.getClass().getName();
            if (object instanceof FlowLayout) {
                return "Flow";
            }
            if (object instanceof BorderLayout) {
                return "Border";
            }
            if (object instanceof GridLayout) {
                return "Grid";
            }
            if (object instanceof GridBagLayout) {
                return "GridBag";
            }
            if (object instanceof CardLayout) {
                return "Card";
            }
            if (object instanceof GridLayout) {
                return "Box";
            }
            if (string.indexOf("BoxLayout") > 0) {
                return "Box";
            }
            if (string.indexOf("GuideLayout") > 0) {
                return "Guide";
            }
            if (string.indexOf("ScaleLayout") > 0) {
                return "Scale";
            }
            if (string.indexOf("LayerLayout") > 0) {
                return "Layer";
            }
            if (string.indexOf("SpringLayout") > 0) {
                return "Spring";
            }
        }
        return null;
    }

    public boolean getUsesConstraints(Object object) {
        if (object != null) {
            String string = object.getClass().getName();
            if (object instanceof FlowLayout) {
                return false;
            }
            if (object instanceof BorderLayout) {
                return true;
            }
            if (object instanceof GridLayout) {
                return true;
            }
            if (object instanceof GridBagLayout) {
                return true;
            }
            if (object instanceof CardLayout) {
                return true;
            }
            if (object instanceof GridLayout) {
                return false;
            }
            if (string.indexOf("BoxLayout") > 0) {
                return false;
            }
            if (string.indexOf("SpringLayout") > 0) {
                return true;
            }
            if (string.indexOf("ScaleLayout") > 0) {
                return false;
            }
            if (string.indexOf("LayerLayout") > 0) {
                return false;
            }
            if (string.indexOf("GuideLayout") > 0) {
                return true;
            }
        }
        return false;
    }

    public boolean getUsesDimensions(Object object) {
        if (object != null) {
            String string = object.getClass().getName();
            if (string.indexOf("SpringLayout") > 0) {
                return true;
            }
            return string.indexOf("GuideLayout") > 0;
        }
        return true;
    }

    public Object getConstraint(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toUpperCase();
        if (string2.equals("WEST")) {
            return "West";
        }
        if (string2.equals("EAST")) {
            return "East";
        }
        if (string2.equals("NORTH")) {
            return "North";
        }
        if (string2.equals("SOUTH")) {
            return "South";
        }
        if (string2.equals("CENTER")) {
            return "Center";
        }
        if (string2.equals("AFTER_LAST_LINE")) {
            return "Last";
        }
        if (string2.equals("AFTER_LINE_ENDS")) {
            return "After";
        }
        if (string2.equals("BEFORE_FIRST_LINE")) {
            return "First";
        }
        if (string2.equals("BEFORE_LINE_BEGINS")) {
            return "Before";
        }
        String[] stringArray = string2.split(",");
        if (stringArray.length == 14) {
            String string3 = stringArray[6].toUpperCase();
            String string4 = stringArray[7].toUpperCase();
            int n = 10;
            int n2 = 0;
            if (string3.equals("EAST")) {
                n = 13;
            } else if (string3.equals("WEST")) {
                n = 17;
            } else if (string3.equals("NORTH")) {
                n = 11;
            } else if (string3.equals("SOUTH")) {
                n = 15;
            } else if (string3.equals("NORTHEAST")) {
                n = 12;
            } else if (string3.equals("NORTHWEST")) {
                n = 18;
            } else if (string3.equals("SOUTHEAST")) {
                n = 14;
            } else if (string3.equals("SOUTHWEST")) {
                n = 16;
            }
            if (string4.equals("HORIZONTAL")) {
                n2 = 2;
            } else if (string4.equals("VERTICAL")) {
                n2 = 3;
            }
            return new GridBagConstraints(new Integer(stringArray[0]), new Integer(stringArray[1]), new Integer(stringArray[2]), new Integer(stringArray[3]), new Double(stringArray[4]), new Double(stringArray[5]), n, n2, new Insets(new Integer(stringArray[8]), new Integer(stringArray[9]), new Integer(stringArray[10]), new Integer(stringArray[11])), new Integer(stringArray[12]), new Integer(stringArray[13]));
        }
        return string;
    }

    protected int getIntAttrib(Hashtable hashtable, String string) {
        try {
            Object v = hashtable.get(string);
            if (v != null) {
                return new Integer((String)v);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    public void setAttrib(Object object, Object object2, String string, Object object3) {
        String string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
        ReflectionHelper.setViaReflection(string2, object2, object3, object3.getClass());
    }

    protected Integer getBoxAlignment(String string) {
        if (string != null) {
            String string2 = string.toUpperCase();
            if (string2.equals("X") || string2.equals("0")) {
                return new Integer(0);
            }
            if (string2.equals("Y") || string2.equals("1")) {
                return new Integer(1);
            }
            if (string2.equals("LINE")) {
                return new Integer(2);
            }
            if (string2.equals("PAGE")) {
                return new Integer(3);
            }
        }
        return new Integer(0);
    }
}

