/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.helper;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import net.xoetrope.xui.XAttributedComponent;
import net.xoetrope.xui.style.XStyle;

public class ReflectionHelper {
    public static final int PRINT_STACK_TRACE = 0;
    public static final int LOG_ERROR_MESSAGE = 1;
    private static int errorMode = 0;
    private static Hashtable methodCache = new Hashtable();
    private static int cacheCalls;
    private static int cacheHits;

    public static void setErrorMode(int n) {
        errorMode = n;
    }

    public static int getErrorMode() {
        return errorMode;
    }

    public static Object getViaReflection(String string, Object object) {
        return ReflectionHelper.getViaReflection(string, object, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getViaReflection(String string, Object object, boolean bl) {
        try {
            Class[] classArray = new Class[]{};
            Object object2 = object;
            Method method = object2.getClass().getMethod(string, classArray);
            Object[] objectArray = new Object[]{};
            if (method == null) return null;
            return method.invoke(object2, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (!bl) return null;
        }
        catch (Exception exception) {
            exception.getCause().printStackTrace();
        }
        return null;
    }

    public static Object getViaReflection(Class clazz, String string, Object object) {
        try {
            Class[] classArray = new Class[]{};
            Object object2 = object;
            Method method = clazz.getMethod(string, classArray);
            Object[] objectArray = new Object[]{};
            if (method != null) {
                return method.invoke(object2, objectArray);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            exception.getCause().printStackTrace();
        }
        return null;
    }

    public static boolean setViaReflection(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object2};
        return ReflectionHelper.setViaReflection(string, object, objectArray);
    }

    public static boolean setViaReflection(String string, Object object, Object[] objectArray) {
        try {
            Method method = ReflectionHelper.findMethod(string, object, objectArray.length);
            if (method != null) {
                try {
                    Class[] classArray = method.getParameterTypes();
                    Object[] objectArray2 = ReflectionHelper.deserialize(objectArray, classArray);
                    method.invoke(object, objectArray2);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (Exception exception) {
            exception.getCause().printStackTrace();
        }
        return false;
    }

    private static Method findMethod(String string, Object object, int n) {
        Class<?> clazz = object.getClass();
        String string2 = clazz.getName() + "." + string + "/" + n;
        try {
            Object v = methodCache.get(string2);
            if (v != null) {
                if (v instanceof Integer) {
                    return null;
                }
                return (Method)v;
            }
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Class<?>[] classArray;
                if (!methodArray[i].getName().equals(string) || (classArray = methodArray[i].getParameterTypes()).length != n) continue;
                methodCache.put(string2, methodArray[i]);
                return methodArray[i];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        methodCache.put(string2, new Integer(0));
        return null;
    }

    public static Object parseArgument(Class clazz, Object object) {
        String string = object.toString();
        if (clazz == null) {
            Object object2;
            if ("true".equals(string)) {
                return Boolean.TRUE;
            }
            if ("false".equals(string)) {
                return Boolean.FALSE;
            }
            if (string.indexOf(".") > 0) {
                try {
                    Double d = new Double(string);
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
            try {
                object2 = XStyle.parseColor(string);
                if (object2 != null) {
                    return object2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object2 = new Integer(string);
                return object2;
            }
            catch (NumberFormatException numberFormatException) {
                return string;
            }
        }
        if (object.getClass().isAssignableFrom(clazz)) {
            return object;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return new Integer(string);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return new Boolean(string);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return new Double(string);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return new Float(string);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return new Long(string);
        }
        if (clazz == Color.class) {
            return XStyle.parseColor(string);
        }
        return null;
    }

    public static boolean setViaReflection(String string, Object object, Object object2, boolean bl) {
        try {
            Class[] classArray = new Class[]{bl ? Boolean.TYPE : object2.getClass()};
            Object object3 = object;
            Method method = object3.getClass().getMethod(string, classArray);
            Object[] objectArray = new Object[]{object2};
            if (method != null) {
                method.invoke(object3, objectArray);
            }
        }
        catch (Exception exception) {
            exception.getCause().printStackTrace();
        }
        return true;
    }

    public static boolean setViaReflection(String string, Object object, Object object2, Class clazz) {
        try {
            Class[] classArray = new Class[]{clazz};
            Object object3 = object;
            Method method = object3.getClass().getMethod("set" + string, classArray);
            Object[] objectArray = new Object[]{object2};
            if (method != null) {
                method.invoke(object3, objectArray);
            }
        }
        catch (Exception exception) {
            Class clazz2 = ReflectionHelper.getAltClass(clazz);
            if (clazz2 == null || !ReflectionHelper.setViaReflection(string, object, object2, clazz2)) {
                // empty if block
            }
            return false;
        }
        return true;
    }

    public static void setFieldViaReflection(Object object, String string, String string2) {
        try {
            Class<?> clazz = object.getClass();
            Field field = clazz.getField(string);
            Class<?> clazz2 = field.getType();
            if (clazz2 == Boolean.TYPE) {
                field.setBoolean(object, string2.equals("true"));
            } else if (clazz2 == Integer.TYPE) {
                field.setInt(object, Integer.parseInt(string2));
            } else if (clazz2 == Double.TYPE) {
                field.setDouble(object, Double.parseDouble(string2));
            } else if (clazz2 == Float.TYPE) {
                field.setFloat(object, Float.parseFloat(string2));
            } else {
                field.set(object, string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setFieldViaReflection(Object object, String string, Object object2) {
        try {
            Class<?> clazz = object.getClass();
            Field field = clazz.getField(string);
            field.set(object, object2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Object constructViaReflection(String string, Object[] objectArray) {
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return ReflectionHelper.constructViaReflection((Object)string, classArray, objectArray);
    }

    public static Object constructViaReflection(Object object, Class[] classArray, Object[] objectArray) {
        Object var3_3 = null;
        try {
            Class<?> clazz = object instanceof Class ? (Class<?>)object : Class.forName(((String)object).trim());
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getConstructor(classArray);
                var3_3 = constructor.newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Constructor<?>[] constructorArray = clazz.getConstructors();
                for (int i = 0; i < constructorArray.length; ++i) {
                    Class<?>[] classArray2 = constructorArray[i].getParameterTypes();
                    if (classArray2.length != classArray.length) continue;
                    try {
                        var3_3 = constructorArray[i].newInstance(objectArray);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (var3_3 != null) break;
                }
                if (var3_3 == null) {
                    noSuchMethodException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return var3_3;
    }

    public static Object constructViaReflection(String string, Class clazz, Object object) {
        Object[] objectArray = new Object[]{object};
        Class[] classArray = new Class[]{clazz};
        return ReflectionHelper.constructViaReflection((Object)string, classArray, objectArray);
    }

    public static Object constructViaReflection(ClassLoader classLoader, Object object, Class clazz, Object object2) {
        Object[] objectArray = new Object[]{object2};
        Class[] classArray = new Class[]{clazz};
        try {
            Class<?> clazz2 = object instanceof Class ? (Class<?>)object : (classLoader != null ? classLoader.loadClass(((String)object).trim()) : Class.forName(((String)object).trim()));
            Constructor constructor = clazz2.getConstructor(classArray);
            if (constructor != null) {
                return constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            if (exception.getCause() != null) {
                exception.getCause().printStackTrace();
            }
            exception.printStackTrace();
        }
        return null;
    }

    public static Object constructViaReflection(ClassLoader classLoader, Object object) {
        Object[] objectArray = new Object[]{};
        Class[] classArray = new Class[]{};
        try {
            Class<?> clazz = object instanceof Class ? (Class<?>)object : (classLoader != null ? classLoader.loadClass(((String)object).trim()) : Class.forName(((String)object).trim()));
            Constructor constructor = clazz.getConstructor(classArray);
            if (constructor != null) {
                return constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static Class getAltClass(Class clazz) {
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        return null;
    }

    public static Class getParamClass(String string) {
        Class clazz = null;
        if (string == null || string.length() == 0 || string.equals("String") || string.equals("java.lang.String")) {
            clazz = String.class;
        } else if (string.equals("int")) {
            clazz = Integer.TYPE;
        } else if (string.equals("long")) {
            clazz = Long.TYPE;
        } else if (string.equals("java.lang.Integer")) {
            clazz = Integer.class;
        } else if (string.equals("double")) {
            clazz = Double.TYPE;
        } else if (string.equals("java.lang.Double")) {
            clazz = Double.class;
        } else if (string.equals("boolean")) {
            clazz = Boolean.TYPE;
        } else if (string.equals("java.lang.Boolean")) {
            clazz = Boolean.class;
        } else if (string.equals("float")) {
            clazz = Float.TYPE;
        } else if (string.equals("java.lang.Float")) {
            clazz = Float.class;
        } else if (string.equals("Object")) {
            clazz = Object.class;
        } else if (string.equals("class")) {
            clazz = Class.class;
        } else if (string.equals("styleName")) {
            clazz = String.class;
        } else {
            if (string.equals("custom_list") || string.equals("custom_list_int") || string.equals("style")) {
                return XAttributedComponent.class;
            }
            if (string.equals("image") || string.equals("imageName")) {
                clazz = String.class;
            } else {
                try {
                    clazz = Class.forName(string.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return clazz;
    }

    public static Object getObject(String string, String string2) {
        Object object = null;
        if (string.length() == 0 || string.equals("String") || string.indexOf("class java.lang.String") >= 0) {
            object = string2;
        } else if (string.equals("int") || string.indexOf("java.lang.Integer") >= 0) {
            object = new Integer(string2);
        } else if (string.equals("double") || string.indexOf("java.lang.Double") >= 0) {
            object = new Double(string2);
        } else if (string.equals("boolean") || string.indexOf("java.lang.Boolean") >= 0) {
            object = new Boolean(string2.equals("true"));
        } else if (string.equals("float") || string.indexOf("java.lang.Float") >= 0) {
            object = new Float(string2);
        } else if (string.equals("Object")) {
            object = string2;
        } else {
            try {
                object = Class.forName(string.trim()).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    public static Object deserialize(Object object, Class clazz) {
        String string;
        if (object instanceof String && (string = (String)object).length() > 0) {
            if (string.charAt(0) == '[') {
                char c = string.charAt(1);
                String string2 = string.substring(2, string.lastIndexOf(93));
                if (c == 'Z') {
                    object = new Boolean(string2);
                } else if (c == 'B') {
                    object = new Byte(string2);
                } else if (c == 'C') {
                    object = new Character(string2.charAt(0));
                } else if (c == 'S') {
                    object = new Short(string2);
                } else if (c == 'I') {
                    object = new Integer(string2);
                } else if (c == 'J') {
                    object = new Long(string2);
                } else if (c == 'F') {
                    object = new Float(string2);
                } else if (c == 'D') {
                    object = new Double(string2);
                }
            } else {
                if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                    return new Boolean(string);
                }
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    return new Integer(string);
                }
                if (clazz == Double.TYPE || clazz == Double.class) {
                    return new Double(string);
                }
                if (clazz == Float.TYPE || clazz == Float.class) {
                    return new Float(string);
                }
                if (clazz == Long.TYPE || clazz == Long.class) {
                    return new Long(string);
                }
            }
        }
        return object;
    }

    public static Object[] deserialize(Object[] objectArray, Class[] classArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = ReflectionHelper.deserialize(objectArray[i], classArray[i]);
        }
        return objectArray2;
    }
}

