/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.events;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.events.XAction;
import net.xoetrope.xui.events.XActionFactory;

public class XActionManager {
    private static XActionManager instance = null;
    protected Hashtable actionContexts;
    protected static Hashtable configFiles;
    protected static int changeCounter;
    protected int localChangeCounter = -1;
    private XProject currentProject;
    private XActionFactory actionFactory;

    private XActionManager(XProject xProject) {
        URL uRL;
        this.currentProject = xProject;
        this.actionContexts = new Hashtable();
        String string = this.currentProject.getStartupParam("Actions");
        if (string == null || string.length() == 0) {
            string = "actions";
        }
        if (string.indexOf(".xml") < 0) {
            string = string + ".xml";
        }
        if ((uRL = this.currentProject.findResource(string)) != null) {
            XActionManager.addConfigFile("Project", uRL, false);
        }
    }

    public static void register(XProject xProject) {
        instance = (XActionManager)xProject.getObject("ActionManager");
        if (instance == null) {
            instance = new XActionManager(xProject);
        }
        xProject.setObject("ActionManager", instance);
    }

    public XAction getAction(String string, Object object) {
        this.checkRegistration();
        if (string != null) {
            Hashtable hashtable = (Hashtable)this.actionContexts.get(string);
            if (hashtable != null) {
                return (XAction)hashtable.get(object);
            }
        } else {
            Enumeration enumeration = this.actionContexts.elements();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable = (Hashtable)this.actionContexts.get(enumeration.nextElement());
                XAction xAction = (XAction)hashtable.get(object);
                if (xAction == null) continue;
                return xAction;
            }
        }
        return null;
    }

    public static void addConfigFile(String string, Object object, boolean bl) {
        Object v;
        if (object == null) {
            return;
        }
        if (configFiles == null) {
            configFiles = new Hashtable();
        }
        if ((v = configFiles.get(string)) != null && object.equals(v)) {
            return;
        }
        ++changeCounter;
        if (v != null || bl) {
            configFiles.remove(string);
        }
        configFiles.put(string, object);
    }

    public void updateConfig() {
        ++changeCounter;
    }

    protected void read() {
        this.actionContexts.clear();
        Enumeration enumeration = configFiles.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("Project")) continue;
            this.doRead(string, configFiles.get(string));
        }
        this.doRead("Project", configFiles.get("Project"));
    }

    protected void read(String string, String string2) {
        XActionManager.addConfigFile(string, string2, true);
        this.doRead(string, string2);
    }

    protected void doRead(String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof URL) {
            this.doRead(string, (URL)object);
        } else {
            this.doRead(string, (String)object);
        }
    }

    protected void doRead(String string, String string2) {
        try {
            BufferedReader bufferedReader;
            String string3 = string2;
            if (string3.indexOf(".xml") < 0) {
                string3 = string3 + ".xml";
            }
            if ((bufferedReader = this.currentProject.getBufferedReader(string3, null)) != null) {
                this.read(string, bufferedReader);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void doRead(String string, URL uRL) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            if (bufferedReader != null) {
                this.read(string, bufferedReader);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void read(String string, Reader reader) {
        try {
            XmlElement xmlElement = XmlSource.read(reader);
            String string2 = xmlElement.getAttribute("factory");
            if (string2 == null) {
                string2 = "net.xoetrope.swing.actions.XSwingActionFactory";
            }
            try {
                if (this.actionFactory == null) {
                    this.actionFactory = (XActionFactory)Class.forName(string2.trim()).newInstance();
                }
            }
            catch (Exception exception) {
                DebugLogger.logError("Unable to setup the action factory");
                exception.printStackTrace();
                return;
            }
            Vector vector = xmlElement.getChildren();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Hashtable hashtable;
                String string3;
                XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
                String string4 = xmlElement2.getName();
                if (!"Context".equalsIgnoreCase(string4)) {
                    string3 = "global";
                    hashtable = (Hashtable)this.actionContexts.get(string3);
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                        this.actionContexts.put(string3, hashtable);
                    }
                    hashtable.put(xmlElement2.getAttribute("id"), this.actionFactory.getAction(xmlElement2));
                    continue;
                }
                string3 = xmlElement2.getAttribute("name");
                hashtable = (Hashtable)this.actionContexts.get(string3);
                if (hashtable == null) {
                    hashtable = new Hashtable();
                    this.actionContexts.put(string3, hashtable);
                }
                Vector vector2 = xmlElement2.getChildren();
                int n2 = vector2.size();
                for (int j = 0; j < n2; ++j) {
                    XmlElement xmlElement3 = (XmlElement)vector2.elementAt(j);
                    hashtable.put(xmlElement3.getAttribute("id"), this.actionFactory.getAction(xmlElement3));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkRegistration() {
        if (this.localChangeCounter != changeCounter) {
            this.read();
            this.localChangeCounter = changeCounter;
        }
    }
}

