/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.data;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;
import net.xoetrope.xui.PageSupport;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.data.XDataBinding;
import net.xoetrope.xui.data.XDataBindingFactory;

public class XRegisteredDataBindingFactory
extends XDataBindingFactory {
    private static XRegisteredDataBindingFactory instance = null;
    public static final int CLASS_MATCH = 0;
    public static final int INTERFACE_MATCH = 1;
    public static final int INSTANCE_MATCH = 2;
    public static final int INSPECTOR_MATCH = 3;
    private static final int NUM_MATCH_MODES = 4;
    protected ArrayList[] bindingRegisters;
    protected static Hashtable configFiles;
    protected static int changeCounter;
    protected int localChangeCounter = -1;
    private XProject currentProject;

    private XRegisteredDataBindingFactory(XProject xProject) {
        super(xProject);
        URL uRL;
        XRegisteredDataBindingFactory.addConfigFile("XUI", "net/xoetrope/xui/data/bindings.xml", false);
        this.currentProject = xProject;
        String string = this.currentProject.getStartupParam("BindingsRegistry");
        if (string == null || string.length() == 0) {
            string = "bindings";
        }
        if (string.indexOf(".xml") < 0) {
            string = string + ".xml";
        }
        if ((uRL = this.currentProject.findResource(string)) != null) {
            XRegisteredDataBindingFactory.addConfigFile("Project", uRL, false);
        }
    }

    public static void register(XProject xProject) {
        if (instance == null) {
            instance = new XRegisteredDataBindingFactory(xProject);
        }
        xProject.registerBindingFactory(instance);
    }

    public XDataBinding getBinding(PageSupport pageSupport, Object object, Hashtable hashtable) {
        this.checkRegistration();
        String string = object.getClass().getName();
        String string2 = (String)hashtable.get("type");
        Hashtable hashtable2 = new Hashtable();
        for (int i = 0; i < 4; ++i) {
            int n = this.bindingRegisters[i].size();
            for (int j = 0; j < n; ++j) {
                XBindingMatch xBindingMatch = (XBindingMatch)this.bindingRegisters[i].get(j);
                if (xBindingMatch.matchMode != i || !xBindingMatch.matches(i, object, string, string2)) continue;
                try {
                    XDataBinding xDataBinding = (XDataBinding)Class.forName(xBindingMatch.className.trim()).newInstance();
                    xDataBinding.setup(this.currentProject, object, hashtable2, hashtable);
                    return xDataBinding;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void addConfigFile(String string, Object object, boolean bl) {
        Object v;
        if (object == null) {
            return;
        }
        if (configFiles == null) {
            configFiles = new Hashtable();
        }
        if ((v = configFiles.get(string)) != null && object.equals(v)) {
            return;
        }
        ++changeCounter;
        if (v != null || bl) {
            configFiles.remove(string);
        }
        configFiles.put(string, object);
    }

    public void updateConfig() {
        ++changeCounter;
    }

    protected void read() {
        this.bindingRegisters = new ArrayList[4];
        for (int i = 0; i < 4; ++i) {
            this.bindingRegisters[i] = new ArrayList();
        }
        Enumeration enumeration = configFiles.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("Project")) continue;
            this.doRead(string, configFiles.get(string));
        }
        this.doRead("Project", configFiles.get("Project"));
    }

    protected void read(String string, String string2) {
        XRegisteredDataBindingFactory.addConfigFile(string, string2, true);
        this.doRead(string, string2);
    }

    protected void doRead(String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof URL) {
            this.doRead(string, (URL)object);
        } else {
            this.doRead(string, (String)object);
        }
    }

    protected void doRead(String string, String string2) {
        try {
            BufferedReader bufferedReader;
            String string3 = string2;
            if (string3.indexOf(".xml") < 0) {
                string3 = string3 + ".xml";
            }
            if ((bufferedReader = this.currentProject.getBufferedReader(string3, null)) != null) {
                this.read(string, bufferedReader);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void doRead(String string, URL uRL) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            if (bufferedReader != null) {
                this.read(string, bufferedReader);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void read(String string, Reader reader) {
        try {
            XmlElement xmlElement = XmlSource.read(reader);
            Vector vector = xmlElement.getChildren();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
                String string2 = xmlElement2.getName();
                int n2 = string2.equals("InspectorBindings") ? 3 : (string2.equals("ClassBindings") ? 0 : (string2.equals("InterfaceBindings") ? 1 : 2));
                this.addBindingTypes(xmlElement2, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addBindingTypes(XmlElement xmlElement, int n) {
        try {
            Vector vector = xmlElement.getChildren();
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
                XBindingMatch xBindingMatch = new XBindingMatch();
                xBindingMatch.matchMode = n;
                xBindingMatch.target = xmlElement2.getAttribute("target");
                xBindingMatch.className = xmlElement2.getAttribute("class");
                xBindingMatch.type = xmlElement2.getAttribute("type");
                this.bindingRegisters[n].add(xBindingMatch);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkRegistration() {
        if (this.localChangeCounter != changeCounter) {
            this.read();
            this.localChangeCounter = changeCounter;
        }
    }

    class XBindingMatch {
        public int matchMode;
        public String target;
        public String className;
        public String type;
        private Class targetClass;

        XBindingMatch() {
        }

        public boolean matches(int n, Object object, String string, String string2) {
            if (string2 != null && string2.length() > 0 && !string2.equals(this.type)) {
                return false;
            }
            if (n == 0) {
                if (this.target.equals(string)) {
                    return true;
                }
                int n2 = this.target.indexOf(42);
                if (n2 > 0 && string.startsWith(this.target.substring(0, n2)) && string.endsWith(this.target.substring(n2 + 1))) {
                    return true;
                }
            } else if (n == 1) {
                try {
                    if (this.targetClass == null) {
                        this.targetClass = Class.forName(this.target.trim());
                    }
                    for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                        Class<?>[] classArray = clazz.getInterfaces();
                        for (int i = 0; i < classArray.length; ++i) {
                            if (classArray[i] != this.targetClass) continue;
                            return true;
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            } else if (n == 2) {
                try {
                    if (this.targetClass == null) {
                        this.targetClass = Class.forName(this.target.trim());
                    }
                    for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                        if (clazz != this.targetClass) continue;
                        return true;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            } else if (n == 3) {
                return false;
            }
            return false;
        }
    }
}

