/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.data;

import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.data.XBaseModel;
import net.xoetrope.xui.data.XModel;
import net.xoetrope.xui.helper.NumberFormatter;

public class XModelHelper {
    private XModel modelNode;
    private static XProject currentProject;

    public XModelHelper(Object object) {
        this.modelNode = (XModel)object;
    }

    public static XModel getNextSibling(XModel xModel, boolean bl) {
        return XModelHelper.getSibling(true, xModel, bl);
    }

    public static XModel getPrevSibling(XModel xModel, boolean bl) {
        return XModelHelper.getSibling(false, xModel, bl);
    }

    public static XModel getSibling(boolean bl, XModel xModel, boolean bl2) {
        XModel xModel2 = xModel.getParent();
        int n = xModel2.getNumChildren();
        if (n == 1) {
            return null;
        }
        int n2 = -1;
        int n3 = n - 1;
        for (int i = 0; i < n; ++i) {
            int n4 = bl ? i : n3 - i;
            XModel xModel3 = xModel2.get(n4);
            if (xModel3 != xModel) continue;
            n2 = i;
            break;
        }
        if (bl) {
            if (n2 < n3) {
                return xModel2.get(n2 + 1);
            }
            if (bl2) {
                return xModel2.get(0);
            }
        } else {
            if (n2 > 1) {
                return xModel2.get(n2 - 1);
            }
            if (bl2) {
                return xModel2.get(n3);
            }
        }
        return null;
    }

    public static void setCurrentProject(XProject xProject) {
        currentProject = xProject;
    }

    public XModel get() {
        return (XModel)this.modelNode.get();
    }

    public XModel get(String string) {
        return (XModel)this.modelNode.get(string);
    }

    public static XModel get(Object object) {
        XModel xModel = (XModel)object;
        return (XModel)xModel.get();
    }

    public static XModel get(XProject xProject, Object object, String string) {
        currentProject = xProject;
        XModel xModel = (XModel)object;
        if (xModel == null) {
            xModel = currentProject.getModel();
        }
        return (XModel)xModel.get(string);
    }

    public static String getString(XProject xProject, Object object, String string) {
        currentProject = xProject;
        XModel xModel = XModelHelper.get(xProject, object, string);
        if (xModel == null) {
            return null;
        }
        return (String)xModel.get();
    }

    public static String getString(Object object, String string) {
        XModel xModel = XModelHelper.get(currentProject, object, string);
        if (xModel == null) {
            return null;
        }
        return (String)xModel.get();
    }

    public static String getString(String string) {
        XModel xModel = XModelHelper.get(currentProject, null, string);
        if (xModel == null) {
            return null;
        }
        return (String)xModel.get();
    }

    public void set(Object object) {
        this.modelNode.set(object);
    }

    public void set(String string, Object object) {
        ((XModel)this.modelNode.get(string)).set(object);
    }

    public static void set(XProject xProject, Object object, String string, Object object2) {
        currentProject = xProject;
        XModel xModel = (XModel)object;
        if (xModel == null) {
            xModel = currentProject.getModel();
        }
        ((XModel)xModel.get(string)).set(object2);
    }

    public static XModel clone(Object object) {
        XBaseModel xBaseModel = new XBaseModel();
        XModelHelper.cloneChildren(object, xBaseModel, true);
        return xBaseModel;
    }

    public static XModel clone(Object object, boolean bl) {
        XBaseModel xBaseModel = new XBaseModel();
        XModelHelper.cloneChildren(object, xBaseModel, bl);
        return xBaseModel;
    }

    private static void cloneChildren(Object object, Object object2, boolean bl) {
        int n;
        if (object == null || object2 == null) {
            return;
        }
        XModel xModel = (XModel)object;
        XModel xModel2 = (XModel)object2;
        int n2 = xModel.getNumAttributes();
        xModel2.setNumAttributes(n2);
        xModel2.setId(xModel.getId());
        for (n = 0; n < n2; ++n) {
            xModel2.setAttribValue(n, xModel.getAttribName(n), xModel.getAttribValue(n));
        }
        if (bl) {
            n = xModel.getNumChildren();
            for (int i = 0; i < n; ++i) {
                XBaseModel xBaseModel = (XBaseModel)xModel.get(i);
                XBaseModel xBaseModel2 = new XBaseModel(xModel2);
                xModel2.append(xBaseModel2);
                XModelHelper.cloneChildren(xBaseModel, xBaseModel2, true);
            }
        }
    }

    public static void merge(Object object, Object object2) {
        XModelHelper.mergeChildren(object2, object);
    }

    private static void mergeChildren(Object object, Object object2) {
        int n;
        XModel xModel = (XModel)object;
        XModel xModel2 = (XModel)object2;
        int n2 = xModel.getNumAttributes();
        xModel2.setNumAttributes(n2);
        xModel2.setId(xModel.getId());
        for (n = 0; n < n2; ++n) {
            String string = xModel.getAttribName(n);
            xModel2.setAttribValue(xModel2.getAttribute(string), xModel.getAttribValue(n));
        }
        n = xModel.getNumChildren();
        for (int i = 0; i < n; ++i) {
            XBaseModel xBaseModel = (XBaseModel)xModel.get(i);
            XBaseModel xBaseModel2 = new XBaseModel(xModel2);
            xModel2.append(xBaseModel2);
            XModelHelper.mergeChildren(xBaseModel, xBaseModel2);
        }
    }

    public static String getAttrib(Object object, String string) {
        if (object == null) {
            return null;
        }
        XModel xModel = (XModel)object;
        return xModel.getAttribValueAsString(xModel.getAttribute(string));
    }

    public static void setAttrib(Object object, String string, Object object2) {
        XModel xModel = (XModel)object;
        xModel.setAttribValue(xModel.getAttribute(string), string, object2);
    }

    public static XModel getParent(Object object, int n) {
        XModel xModel = (XModel)object;
        for (int i = 0; i < n; ++i) {
            xModel = xModel.getParent();
        }
        return xModel;
    }

    public static int getPositionInModel(Object object) {
        XModel xModel = (XModel)object;
        for (int i = 0; i < xModel.getParent().getNumChildren(); ++i) {
            if (!xModel.getParent().get(i).equals(xModel)) continue;
            return i;
        }
        return -1;
    }

    public static String getValue(Object object) {
        return (String)((XModel)object).get();
    }

    public static double getDouble(Object object, String string) {
        return XModelHelper.getDouble(object, string, 0.0);
    }

    public static double getDouble(Object object, String string, char c, char c2) {
        return XModelHelper.getDouble(object, string, 0.0, c, c2);
    }

    public static double getDouble(Object object, String string, double d) {
        try {
            XModel xModel = (XModel)((XModel)object).get(string);
            return xModel.getAttribValueAsDouble(0, '.', ',');
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static double getDouble(Object object, String string, double d, char c, char c2) {
        try {
            XModel xModel = (XModel)((XModel)object).get(string);
            return xModel.getAttribValueAsDouble(0, c, c2);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static double getDoubleValue(Object object) {
        double d = 0.0;
        XModel xModel = (XModel)object;
        String string = (String)xModel.get();
        try {
            if (string != null) {
                d = NumberFormatter.parseDouble(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public static double getDoubleValue(Object object, String string) {
        return XModelHelper.getDoubleValue(object, string, 0.0);
    }

    public static double getDoubleValue(Object object, String string, char c, char c2) {
        return XModelHelper.getDoubleValue(object, string, 0.0, c, c2);
    }

    public static double getDoubleValue(Object object, String string, double d) {
        try {
            XModel xModel = (XModel)object;
            return xModel.getAttribValueAsDouble(xModel.getAttribute(string));
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static double getDoubleValue(Object object, String string, double d, char c, char c2) {
        try {
            XModel xModel = (XModel)object;
            return xModel.getAttribValueAsDouble(xModel.getAttribute(string), c, c2);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static int getInt(Object object, String string) {
        int n = 0;
        XModel xModel = (XModel)((XModel)object).get(string);
        String string2 = (String)xModel.get();
        try {
            if (string2 != null) {
                n = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static int getInt(Object object, String string, int n) {
        int n2 = n;
        XModel xModel = (XModel)((XModel)object).get(string);
        String string2 = (String)xModel.get();
        try {
            if (string2 != null) {
                n2 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public static int getInt(Object object) {
        return XModelHelper.getIntValue(object);
    }

    public static int getIntValue(Object object) {
        int n = 0;
        XModel xModel = (XModel)object;
        String string = (String)xModel.get();
        try {
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static int getIntValue(Object object, String string) {
        return XModelHelper.getIntValue(object, string, 0);
    }

    public static int getIntValue(Object object, String string, int n) {
        try {
            XModel xModel = (XModel)object;
            return xModel.getAttribValueAsInt(xModel.getAttribute(string));
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static double addModels(Object object, Object object2) {
        double d = XModelHelper.getDoubleValue(object);
        return d += XModelHelper.getDoubleValue(object2);
    }

    public static double multipyModels(Object object, Object object2) {
        double d = XModelHelper.getDoubleValue(object);
        return d *= XModelHelper.getDoubleValue(object2);
    }

    public static double multipyAttribs(Object object, String string, String string2) {
        double d = XModelHelper.getDoubleValue(object, string);
        return d *= XModelHelper.getDoubleValue(object, string2);
    }

    public static void setTempVar(String string, String string2) {
        XModel xModel = (XModel)XProjectManager.getModel().get("temp/" + string);
        xModel.set(string2);
    }

    public static String getTempVar(String string) {
        XModel xModel = (XModel)currentProject.getModel().get("temp/" + string);
        return (String)xModel.get();
    }

    public static boolean getBooleanValue(Object object) {
        XModel xModel = (XModel)object;
        Object object2 = xModel.get();
        boolean bl = object2 instanceof Boolean ? ((Boolean)object2).booleanValue() : object2.toString().equals("true");
        return bl;
    }

    public static boolean getBooleanValue(Object object, String string) {
        String string2 = XModelHelper.getAttrib(object, string);
        if (string2 == null) {
            return false;
        }
        return string2.toString().equals("true");
    }

    public static boolean isChildNode(Object object, Object object2) {
        XModel xModel = (XModel)object;
        for (XModel xModel2 = xModel.getParent(); xModel2 != null; xModel2 = xModel2.getParent()) {
            if (!xModel2.equals(object)) continue;
            return true;
        }
        return false;
    }

    public static XModel getFirstChild(XModel xModel, String string, String string2) {
        XModel xModel2 = (XModel)xModel.get(string);
        return XModelHelper.getFirstChild(xModel2, string2);
    }

    public static XModel getFirstChild(XModel xModel, String string) {
        int n = xModel.getNumChildren();
        for (int i = 0; i < n; ++i) {
            XModel xModel2 = xModel.get(i);
            String string2 = xModel2.getAttribValueAsString(0);
            if (!string2.equals(string)) continue;
            return xModel2;
        }
        return null;
    }

    public static int getNodeCount(XModel xModel) {
        int n;
        int n2 = n = xModel.getNumChildren();
        for (int i = 0; i < n; ++i) {
            XModel xModel2 = xModel.get(i);
            n2 += XModelHelper.getNodeCount(xModel2);
        }
        return n2;
    }
}

