/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.data;

import java.util.Hashtable;
import java.util.Vector;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.data.XModel;

public abstract class XDataBinding {
    protected XProject currentProject;
    protected Object component;
    protected String sourcePath;
    protected String outputPath;
    protected XModel sourceModel;
    protected XModel outputModel;
    protected boolean reevaluate = true;
    public static final String DEFAULT_OUTPUT_PATH = "xui_state/";
    private static final String[] attribNames = new String[]{"sourcePath", "outputPath", "source", "output", "reeval"};

    public abstract void setup(XProject var1, Object var2, Hashtable var3, Hashtable var4);

    protected void setupHelper(XProject xProject, Object object, Hashtable hashtable, Hashtable hashtable2) {
        this.currentProject = xProject;
        this.component = object;
        this.sourcePath = (String)hashtable2.get("sourcePath");
        this.outputPath = (String)hashtable2.get("outputPath");
        XModel xModel = xProject.getModel();
        String string = (String)hashtable2.get("source");
        try {
            this.sourceModel = (XModel)xModel.get((String)hashtable2.get("source"));
        }
        catch (Exception exception) {
            DebugLogger.logError("Exception while setting up the binding data source node:" + string);
            DebugLogger.trace(exception.getMessage());
        }
        String string2 = (String)hashtable2.get("output");
        try {
            if (string2 != null && string2.length() > 0) {
                this.outputModel = (XModel)xModel.get(string2);
            }
        }
        catch (Exception exception) {
            DebugLogger.logError("Exception while setting up the binding data output node:" + string2);
            DebugLogger.trace(exception.getMessage());
        }
        string = (String)hashtable2.get("reeval");
        if (string != null) {
            this.reevaluate = "true".equals(string);
        }
    }

    public abstract void get();

    public abstract void set();

    public Object getComponent() {
        return this.component;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setSource(XModel xModel) {
        this.sourceModel = xModel;
    }

    public void setOutput(XModel xModel, String string) {
        this.outputModel = xModel;
        if (!this.reevaluate) {
            this.outputPath = string;
        }
    }

    public XModel getSource() {
        return this.sourceModel;
    }

    public XModel getOutput() {
        return this.outputModel;
    }

    public void setSourcePath(String string) {
        this.sourcePath = string;
    }

    public void setOutputPath(String string) {
        if (string != null && string.length() > 0) {
            this.outputPath = XModel.prefixOutputPath(string);
        }
    }

    public boolean getReevaluate() {
        return this.reevaluate;
    }

    public void setReevaluate(boolean bl) {
        this.reevaluate = bl;
    }

    private Vector getAttribs(boolean bl) {
        Vector<String> vector = new Vector<String>();
        int n = bl ? 3 : 5;
        for (int i = 0; i < n; ++i) {
            vector.add(attribNames[i]);
        }
        return vector;
    }

    public Vector getAttributes(boolean bl) {
        return this.getAttribs(bl);
    }

    protected Vector getAttributes(boolean bl, String[] stringArray) {
        Vector vector = this.getAttribs(bl);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            vector.add(stringArray[i]);
        }
        return vector;
    }

    public abstract String getType();
}

