/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui.build.conditional;

import java.util.Vector;
import net.xoetrope.xui.XLifeCycleListener;
import net.xoetrope.xui.XProject;

public class ShutdownHook {
    public static boolean forceShutdown = false;
    private Vector lifeCycleListeners;
    private XProject currentProject;

    public ShutdownHook(XProject xProject) {
        this.currentProject = xProject;
        try {
            this.lifeCycleListeners = new Vector();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    int n = ShutdownHook.this.lifeCycleListeners.size();
                    for (int i = 0; i < n; ++i) {
                        ((XLifeCycleListener)ShutdownHook.this.lifeCycleListeners.elementAt(i)).shutdown();
                    }
                    ShutdownHook.this.currentProject.setStatus(5);
                    if (forceShutdown) {
                        Runtime.getRuntime().halt(0);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Runtime.getRuntime().halt(0);
        }
    }

    public void addLifeCycleListener(XLifeCycleListener xLifeCycleListener) {
        this.lifeCycleListeners.add(xLifeCycleListener);
        xLifeCycleListener.initialize(this.currentProject);
    }

    public boolean canClose(XProject xProject) {
        boolean bl = true;
        int n = this.lifeCycleListeners.size();
        for (int i = 0; i < n; ++i) {
            bl &= ((XLifeCycleListener)this.lifeCycleListeners.elementAt(i)).canClose(xProject);
        }
        return bl;
    }
}

