/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.util.Vector;
import net.xoetrope.xui.XTextDecorator;

public class XTextRenderer {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int CENTER = 2;
    private int horizontalAlignment = 0;
    private int verticalAlignment = 0;
    private boolean transparent = false;
    private XTextDecorator textDecorator;

    public void setTextDecorator(XTextDecorator xTextDecorator) {
        this.textDecorator = xTextDecorator;
    }

    public void paintText(Component component, Graphics graphics, String string) {
        this.paintText(component, graphics, new Insets(0, 0, 0, 0), string);
    }

    public void paintText(Component component, Graphics graphics, Insets insets, String string) {
        int n;
        String string2;
        int n2;
        int n3;
        int n4 = component.getSize().width - insets.left - insets.right;
        int n5 = component.getSize().height - insets.top - insets.bottom;
        int n6 = component.getHeight() - insets.bottom;
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!this.transparent) {
            graphics.setColor(component.getBackground());
            graphics.fillRect(insets.left, insets.top, n4 + 1, n5 + 1);
        }
        if (string == null) {
            return;
        }
        Font font = component.getFont();
        if (font.getSize() == 0) {
            font = new Font(null, 0, 12);
        }
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setColor(component.getForeground());
        int n7 = 0;
        int n8 = 0;
        Vector<String> vector = new Vector<String>();
        do {
            n3 = 0;
            n2 = string.indexOf(10, n8 + 1);
            n8 = string.indexOf(32, n8 + 1);
            if (n2 > 0 && n2 < n8) {
                n3 = 1;
                n8 = n2;
            }
            if (n8 > 0) {
                string2 = string.substring(n7, n8);
            } else {
                string2 = string.substring(n7);
                n3 = 1;
            }
            if (fontMetrics.stringWidth(string2) > n4) {
                n = string2.lastIndexOf(32);
                n8 = n7 + n;
                if (n < 0) {
                    n8 += string2.length();
                } else {
                    string2 = n8 >= 0 ? string.substring(n7, n8) : string.substring(n7);
                }
                n3 = 1;
            }
            if (n3 == 0) continue;
            vector.add(string2);
            n7 = n8 + 1;
        } while (n8 >= 0);
        n3 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            string2 = (String)vector.elementAt(n2);
            n = vector.indexOf(string2) + 1;
            int n9 = insets.left;
            int n10 = insets.top;
            if (this.horizontalAlignment != 0) {
                n9 = this.horizontalAlignment == 1 ? (n9 += insets.left + n4 - fontMetrics.stringWidth(string2)) : (n9 += insets.left + (n4 - fontMetrics.stringWidth(string2)) / 2);
            }
            n10 = this.verticalAlignment == 0 ? (n10 += n * fontMetrics.getHeight() - fontMetrics.getDescent()) : (this.verticalAlignment == 1 ? n6 - insets.bottom - (n3 - n) * fontMetrics.getHeight() - fontMetrics.getDescent() : (n10 += (n5 - n3 * fontMetrics.getHeight()) / 2 + n * fontMetrics.getHeight() - fontMetrics.getDescent()));
            this.drawString(graphics, string2, n9, n10);
        }
    }

    public void drawString(Graphics graphics, String string, int n, int n2) {
        graphics.drawString(string, n, n2);
        if (this.textDecorator != null) {
            this.textDecorator.textPainted(graphics, string, n, n2);
        }
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public Dimension getPreferredSize(Component component, String string) {
        Font font = component.getFont();
        if (font == null || font.getSize() == 0) {
            font = new Font(null, 0, 12);
        }
        int n = font.getSize();
        int n2 = string == null ? 1 : string.length();
        Container container = component.getParent();
        if (container.getParent() != null) {
            container = container.getParent();
        }
        int n3 = container.getWidth();
        int n4 = 1;
        if (n3 == 0) {
            return new Dimension(n, n);
        }
        return new Dimension(Math.min(n3, n * n2 / 2 + n), n4 * n + n / 2);
    }
}

