/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui;

import java.applet.Applet;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.xml.XmlParserFactory;
import net.xoetrope.xui.LayoutHelper;
import net.xoetrope.xui.XApplicationContext;
import net.xoetrope.xui.XComponentFactory;
import net.xoetrope.xui.XImageHolder;
import net.xoetrope.xui.XPage;
import net.xoetrope.xui.XPageManager;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.XStartupObject;
import net.xoetrope.xui.data.XBaseModel;
import net.xoetrope.xui.data.XDataBindingFactory;
import net.xoetrope.xui.data.XModel;
import net.xoetrope.xui.events.XuiEventHandler;
import net.xoetrope.xui.exception.XExceptionHandler;
import net.xoetrope.xui.helper.MessageHelper;
import net.xoetrope.xui.helper.ReflectionHelper;
import net.xoetrope.xui.helper.ResourceBundleLoader;
import net.xoetrope.xui.helper.SwingWorker;
import net.xoetrope.xui.helper.XLayoutHelper;
import net.xoetrope.xui.helper.XTranslator;
import net.xoetrope.xui.helper.XuiUtilities;
import net.xoetrope.xui.style.XStyleManager;
import net.xoetrope.xui.validation.XValidationHandler;

public class XProject {
    public static final int UNKNOWN = 0;
    public static final int CREATED = 1;
    public static final int INITIALIZED = 2;
    public static final int STARTED = 3;
    public static final int CLOSING = 4;
    public static final int TERMINATED = 5;
    public static final int RESTARTING = 6;
    protected XStyleManager styleManager = null;
    protected XPageManager pageManager = null;
    protected XModel modelRoot = null;
    protected XmlParserFactory xmlParserFactory = null;
    protected MessageHelper messageHelper;
    protected Vector bindingFactories = new Vector();
    protected String startupFile;
    protected Properties startSettings;
    protected URL documentBase;
    protected Hashtable managerObjects = new Hashtable();
    protected Class defaultModelClass = XBaseModel.class;
    protected String eventHandlerClassName = "net.xoetrope.xui.XEventHandler";
    protected String defaultFile;
    protected String defaultEncoding = "UTF8";
    protected String basePackageName = "net.xoetrope.awt";
    protected String widgetPackageName = "net.xoetrope.awt";
    protected Applet app;
    protected Window appWindow;
    protected Frame appFrame;
    protected XStartupObject startupObject;
    protected Vector customClassLoaders = new Vector();
    protected ResourceBundleLoader resourceBundleLoader;
    protected Hashtable imageCache;
    protected XExceptionHandler exceptionHandler;
    protected int status = 1;

    protected XProject() {
        this.setObject("LayoutHelper", new XLayoutHelper());
        XProjectManager.addProject(null, this);
    }

    public void initialise(String string) {
        if (this.status < 2) {
            this.setStartupFile(string);
            this.pageManager = new XPageManager(this);
            DebugLogger.setDebugLevel(this.getStartupParam("LogLevel"));
            DebugLogger.readLoggerZones(this);
            this.setDefaultModel(this.getStartupParam("DefaultModelClass"));
            this.styleManager = this.createStyleManager();
            this.status = 2;
        }
    }

    private XStyleManager createStyleManager() {
        XStyleManager xStyleManager = null;
        String string = this.getStartupParam("DefaultStyleManager");
        if (string != null && string.length() > 0) {
            try {
                Class<?> clazz = Class.forName(string.trim());
                xStyleManager = (XStyleManager)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (xStyleManager == null) {
            xStyleManager = new XStyleManager(this, 10);
        }
        return xStyleManager;
    }

    public XStyleManager getStyleManager() {
        if (this.styleManager == null) {
            DebugLogger.logError("No XStyleManager instantiated, please check the startup sequence");
        }
        return this.styleManager;
    }

    public XPageManager getPageManager() {
        if (this.pageManager == null) {
            DebugLogger.logError("No XPageManager instantiated, please check the startup sequence");
            throw new UnsupportedOperationException();
        }
        return this.pageManager;
    }

    public XApplicationContext getApplicationContext() {
        Object object = this.getObject("AppContext");
        return (XApplicationContext)object;
    }

    public XModel getModel() {
        if (this.modelRoot == null) {
            try {
                this.modelRoot = (XModel)this.defaultModelClass.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            this.modelRoot.setId("base");
        }
        return this.modelRoot;
    }

    public void setDefaultModel(String string) {
        try {
            if (string != null) {
                this.defaultModelClass = Class.forName(string.trim());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void resetModel() {
        this.modelRoot = null;
    }

    public XmlParserFactory getXmlParserFactory() {
        if (this.xmlParserFactory == null) {
            this.xmlParserFactory = new XmlParserFactory();
        }
        return this.xmlParserFactory;
    }

    public XuiEventHandler createEventHandler(Object object, XValidationHandler xValidationHandler) {
        try {
            Class<?> clazz = Class.forName(this.eventHandlerClassName.trim());
            Class[] classArray = new Class[]{XProject.class, Object.class, XValidationHandler.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this, object, xValidationHandler};
            return (XuiEventHandler)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setEventHandlerClass(String string) {
        this.eventHandlerClassName = string;
    }

    public XExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(XExceptionHandler xExceptionHandler) {
        this.exceptionHandler = xExceptionHandler;
    }

    public MessageHelper getMessageHelper() {
        if (this.messageHelper == null) {
            this.messageHelper = new MessageHelper();
        }
        return this.messageHelper;
    }

    public Vector getBindingsFactories() {
        if (this.bindingFactories == null) {
            this.bindingFactories = new Vector();
        }
        return this.bindingFactories;
    }

    public void registerBindingFactory(XDataBindingFactory xDataBindingFactory, int n) {
        String string = xDataBindingFactory.getClass().getName();
        int n2 = this.bindingFactories.size();
        for (int i = 0; i < n2; ++i) {
            if (!this.bindingFactories.elementAt(i).getClass().getName().equals(string)) continue;
            return;
        }
        this.bindingFactories.add(Math.min(Math.max(n, 0), this.bindingFactories.size()), xDataBindingFactory);
    }

    public void registerBindingFactory(XDataBindingFactory xDataBindingFactory) {
        this.registerBindingFactory(xDataBindingFactory, -1);
    }

    public String getStartupFile() {
        return this.startupFile;
    }

    public void setStartupFile(String string) {
        Object object;
        Object object2;
        this.startupFile = string;
        int n = string.lastIndexOf(File.separatorChar);
        try {
            if (n > 0) {
                this.documentBase = new URL("file", "", this.slashify(string.substring(0, n + 1), true));
                this.startupFile = string.substring(n + 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            object2 = this.findResource(this.startupFile);
            this.startSettings = new Properties();
            if (object2 != null) {
                String string2;
                Object object3;
                if (this.documentBase == null) {
                    object3 = ((URL)object2).toString();
                    object3 = ((String)object3).substring(0, ((String)object3).lastIndexOf("/") + 1);
                    this.documentBase = new URL((String)object3);
                }
                object3 = ((URL)object2).openStream();
                this.startSettings.load((InputStream)object3);
                String string3 = this.getStartupParam("DefaultEncoding");
                if (string3 != null) {
                    this.defaultEncoding = string3;
                }
                if ((object = this.getStartupParam("AntiAlias")) != null) {
                    XPage.antiAlias = ((String)object).equals("true");
                }
                if ((string2 = ((URL)object2).getFile()).charAt(0) == '/') {
                    string2 = string2.substring(1);
                }
                if ((n = string2.indexOf("/resources")) > 0) {
                    string2 = string2.substring(0, n);
                } else {
                    n = string2.lastIndexOf("/");
                    if (n > 0) {
                        string2 = string2.substring(0, n);
                    }
                }
                this.startSettings.put("ProjectPath", string2);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        try {
            object2 = this.getStartupParam("NumClassLoaders");
            if (object2 != null) {
                int n2 = new Integer((String)object2);
                for (int i = 0; i < n2; ++i) {
                    object = (ClassLoader)Class.forName(this.getStartupParam("ClassLoader" + (i + 1)).trim()).newInstance();
                    this.customClassLoaders.addElement(object);
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        try {
            object2 = this.getStartupParam("LayoutHelper");
            if (object2 != null) {
                LayoutHelper layoutHelper = (LayoutHelper)Class.forName(((String)object2).trim()).newInstance();
                XComponentFactory.setLayoutHelper(layoutHelper);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = this.getStartupParam("CacheImages");
        if (object2 != null && !((String)object2).equals("false")) {
            this.imageCache = new Hashtable();
        }
    }

    public String getStartupParam(String string) {
        if (this.startSettings == null) {
            return null;
        }
        return this.startSettings.getProperty(string);
    }

    public boolean setStartupParam(String string, String string2) {
        if (string != null && string2 != null) {
            String string3;
            Object object = this.startSettings.get(string);
            String string4 = string3 = object == null ? null : object.toString();
            if (string3 == null || !string3.equals(string2)) {
                this.startSettings.setProperty(string, string2);
                return true;
            }
        }
        return false;
    }

    public int getStartupParamAsInt(String string) {
        String string2 = this.startSettings.getProperty(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return 0;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public Object getObject(String string) {
        return this.managerObjects.get(string);
    }

    public void setObject(String string, Object object) {
        Object v = this.managerObjects.get(string);
        if (v != null) {
            this.managerObjects.remove(string);
        }
        if (object != null) {
            this.managerObjects.put(string, object);
        }
    }

    public void removeObject(String string) {
        Object v = this.managerObjects.get(string);
        if (v != null) {
            this.managerObjects.remove(v);
        }
    }

    public Object getIcon(String string) {
        try {
            Image image = this.getImage(string);
            Class<?> clazz = Class.forName("javax.swing.ImageIcon");
            Constructor<?> constructor = clazz.getConstructor(Image.class);
            Object obj = constructor.newInstance(image);
            return obj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String string) {
        if (string == null) {
            return null;
        }
        URL uRL = XuiUtilities.checkUrl(this.getUrl(string));
        Image image = null;
        if (uRL != null) {
            image = Toolkit.getDefaultToolkit().getImage(uRL);
        }
        try {
            URL uRL2;
            if (image == null && (uRL2 = XuiUtilities.checkUrl(new URL(this.documentBase, string))) != null) {
                image = Toolkit.getDefaultToolkit().getImage(uRL2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            URL uRL3 = XuiUtilities.checkUrl(ClassLoader.getSystemResource(string));
            if (uRL3 != null) {
                image = Toolkit.getDefaultToolkit().getImage(uRL3);
            }
        }
        return image;
    }

    public synchronized void getImage(XImageHolder xImageHolder, String string) {
        if (string == null) {
            return;
        }
        final String string2 = string;
        SwingWorker swingWorker = new SwingWorker(){
            Image result = null;

            public Object construct() {
                if (XProject.this.imageCache != null) {
                    this.result = (Image)XProject.this.imageCache.get(string2);
                }
                if (this.result == null) {
                    this.result = XProject.this.createImage(XProject.this.getBufferedInputStream(string2));
                }
                if (this.result != null && XProject.this.imageCache != null) {
                    XProject.this.imageCache.put(string2, this.result);
                }
                return this.result;
            }

            public void finished() {
                Object object = this.getExtraValue();
                if (object != null) {
                    ((XImageHolder)object).setImage(this.result);
                }
            }
        };
        swingWorker.setExtraValue(xImageHolder);
        swingWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(String string) {
        InputStream inputStream;
        block20: {
            inputStream = null;
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader != null) {
                try {
                    int n = this.customClassLoaders.size();
                    if (n > 0) {
                        for (int i = 0; i < n; ++i) {
                            ClassLoader classLoader2 = (ClassLoader)this.customClassLoaders.elementAt(i);
                            if (this.canAccessDefaultPackage(classLoader2, string)) {
                                inputStream = classLoader2.getResourceAsStream(string);
                            }
                            if (inputStream != null) break;
                        }
                    }
                    if (inputStream == null) {
                        if (string.indexOf("http") == 0) {
                            try {
                                URL uRL = new URL(string);
                                inputStream = uRL.openStream();
                            }
                            catch (Exception exception) {
                                inputStream = null;
                            }
                        } else if (this.canAccessDefaultPackage(classLoader, string)) {
                            inputStream = classLoader.getResourceAsStream(string);
                        }
                    }
                }
                catch (Exception exception) {
                    inputStream = null;
                }
            }
            if (inputStream != null) break block20;
            try {
                inputStream = new FileInputStream(string);
            }
            catch (Exception exception) {
                try {
                    inputStream = new FileInputStream(new URL(this.documentBase, string).getFile());
                }
                catch (Exception exception2) {
                    try {
                        inputStream = ClassLoader.getSystemResourceAsStream(string);
                    }
                    catch (Exception exception3) {
                        inputStream = null;
                    }
                }
            }
        }
        return inputStream;
    }

    public String findResourceAsString(String string) {
        URL uRL = this.findResource(string);
        if (uRL != null) {
            String string2 = uRL.getFile();
            if ((string2 = URLDecoder.decode(string2)).charAt(0) == '/') {
                string2 = string2.substring(1);
            }
            return string2;
        }
        return null;
    }

    public URL findResource(String string) {
        URL uRL = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader != null) {
            try {
                int n = this.customClassLoaders.size();
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        ClassLoader classLoader2 = (ClassLoader)this.customClassLoaders.elementAt(i);
                        if (this.canAccessDefaultPackage(classLoader2, string)) {
                            uRL = classLoader2.getResource(string);
                        }
                        if (uRL == null) continue;
                        return uRL;
                    }
                }
                try {
                    if (this.canAccessDefaultPackage(classLoader, string)) {
                        uRL = classLoader.getResource(string);
                    }
                    if (uRL != null) {
                        return uRL;
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            return ClassLoader.getSystemResource(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BufferedInputStream getBufferedInputStream(String string) {
        return new BufferedInputStream(this.getInputStream(string));
    }

    public URL getUrl(String string) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = null;
        if (classLoader != null) {
            try {
                int n = this.customClassLoaders.size();
                for (int i = 0; i < n; ++i) {
                    ClassLoader classLoader2 = (ClassLoader)this.customClassLoaders.elementAt(i);
                    if (this.canAccessDefaultPackage(classLoader2, string)) {
                        uRL = classLoader2.getResource(string);
                    }
                    if (uRL != null) break;
                }
                if (uRL == null) {
                    uRL = classLoader.getResource(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            if (uRL == null) {
                uRL = new URL(this.documentBase, string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uRL;
    }

    public void addCustomClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.customClassLoaders.addElement(classLoader);
        }
    }

    public Vector getCustomerClassLoaders() {
        return this.customClassLoaders;
    }

    public ClassLoader getProjectClassLoader() {
        ClassLoader classLoader = null;
        Enumeration enumeration = this.customClassLoaders.elements();
        while (enumeration.hasMoreElements() && classLoader == null) {
            Object e = enumeration.nextElement();
            if (!e.getClass().getName().equals("net.xoetrope.optional.resources.XProjectClassLoader")) continue;
            classLoader = (ClassLoader)e;
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileInputStream = null;
        }
        return fileInputStream;
    }

    public BufferedInputStream getBufferedInputStream(File file) {
        return new BufferedInputStream(this.getInputStream(file));
    }

    public BufferedReader getBufferedReader(String string) throws Exception {
        BufferedReader bufferedReader = null;
        InputStream inputStream = this.getInputStream(string);
        if (inputStream != null) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        return bufferedReader;
    }

    public BufferedReader getBufferedReader(String string, String string2) throws Exception {
        if (string2 == null) {
            string2 = this.defaultEncoding;
        }
        BufferedReader bufferedReader = null;
        try {
            InputStream inputStream = this.getInputStream(string);
            if (inputStream != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
                bufferedReader = new BufferedReader(inputStreamReader);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Exception("Encoding " + string2 + " not supported for file '" + string + "'");
        }
        catch (Exception exception) {
            throw new Exception("Could not access file '" + string + "'");
        }
        return bufferedReader;
    }

    public BufferedReader getBufferedReader(File file, String string) throws Exception {
        if (string == null) {
            string = this.defaultEncoding;
        }
        BufferedReader bufferedReader = null;
        try {
            InputStream inputStream = this.getInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            bufferedReader = new BufferedReader(inputStreamReader);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Exception("Encoding " + string + " not supported for file '" + file + "'");
        }
        catch (Exception exception) {
            throw new Exception("Could not access file '" + file + "'");
        }
        return bufferedReader;
    }

    public OutputStream getOutputStream(String string) {
        return this.getOutputStream(string, true);
    }

    public BufferedOutputStream getBufferedOutputStream(String string) {
        return new BufferedOutputStream(this.getOutputStream(string));
    }

    public OutputStream getOutputStream(String string, boolean bl) {
        try {
            if (this.getClass().getClassLoader() == null) {
                return new FileOutputStream(string);
            }
            if (bl) {
                File file = new File(this.defaultFile);
                return new FileOutputStream(new File(file, string));
            }
            return new FileOutputStream(new File(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public BufferedOutputStream getBufferedOutputStream(String string, boolean bl) {
        return new BufferedOutputStream(this.getOutputStream(string, bl));
    }

    public void setPackageName(String string) {
        this.basePackageName = string;
    }

    public String getPackageName() {
        return this.basePackageName;
    }

    public void setWidgetPackageName(String string) {
        this.widgetPackageName = string;
    }

    public String getWidgetPackageName() {
        return this.widgetPackageName;
    }

    public URL getDocumentBase() {
        return this.documentBase;
    }

    public void setDocumentBase(URL uRL) {
        this.documentBase = uRL;
    }

    public void setApplet(Applet applet) {
        this.app = applet;
    }

    public void setStartupObject(XStartupObject xStartupObject) {
        this.startupObject = xStartupObject;
    }

    public void setAppFrame(Frame frame) {
        this.appFrame = frame;
    }

    public void setAppWindow(Window window) {
        this.appWindow = window;
    }

    public Applet getApplet() {
        return this.app;
    }

    public XStartupObject getStartupObject() {
        return this.startupObject;
    }

    public Frame getAppFrame() {
        return this.appFrame;
    }

    public Window getAppWindow() {
        return this.appWindow;
    }

    protected String slashify(String string, boolean bl) {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && bl) {
            string2 = string2 + "/";
        }
        return string2;
    }

    protected Image createImage(InputStream inputStream) {
        int n = 75000;
        int n2 = 0;
        if (inputStream != null) {
            byte[] byArray = new byte[n];
            try {
                n2 = inputStream.read(byArray);
            }
            catch (IOException iOException) {
                System.err.println("Couldn't read stream from file");
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Can't close file");
            }
            if (n2 <= 0) {
                System.err.println("Empty file");
                return null;
            }
            return Toolkit.getDefaultToolkit().createImage(byArray);
        }
        return null;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String string) {
        if (string != null) {
            this.defaultEncoding = string;
        }
    }

    public void setResourceBundleLoader(ResourceBundleLoader resourceBundleLoader) {
        this.resourceBundleLoader = resourceBundleLoader;
    }

    public ResourceBundleLoader getResourceBundleLoader() {
        return this.resourceBundleLoader;
    }

    public ResourceBundle getResourceBundle(String string) {
        Object object;
        Hashtable hashtable = (Hashtable)this.getObject("ResourceBundles");
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.setObject("ResourceBundles", hashtable);
        }
        if (string == null) {
            string = "unnamed";
        }
        if ((object = hashtable.get(string)) == null) {
            try {
                object = this.resourceBundleLoader != null ? this.resourceBundleLoader.getResourceBundle(string) : new PropertyResourceBundle(this.getInputStream(string + ".properties"));
            }
            catch (Exception exception) {
                return null;
            }
            hashtable.put(string, object);
        }
        return (ResourceBundle)object;
    }

    public XTranslator getTranslator() {
        return this.getTranslator("");
    }

    public XTranslator getTranslator(String string) {
        XTranslator xTranslator = (XTranslator)this.getObject("Translator" + string);
        if (xTranslator == null) {
            String string2 = this.getStartupParam("Translator");
            if (string2 == null || string2.length() == 0) {
                string2 = "net.xoetrope.xui.helper.XDefaultTranslator";
            }
            try {
                xTranslator = (XTranslator)ReflectionHelper.constructViaReflection(null, string2, XProject.class, this);
                this.setObject("Translator" + string, xTranslator);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return xTranslator;
    }

    public void setDefaultFile(String string) {
        this.defaultFile = string;
    }

    public boolean fixError(String string, Object object, Throwable throwable) {
        return this.fixError(this.getClass(), string, object, throwable);
    }

    public boolean fixError(Class clazz, String string, Object object, Throwable throwable) {
        return false;
    }

    public boolean canAccessDefaultPackage(ClassLoader classLoader, String string) {
        return true;
    }
}

