/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.xui.DialogSupport;
import net.xoetrope.xui.PageSupport;
import net.xoetrope.xui.WidgetAdapter;
import net.xoetrope.xui.XPage;
import net.xoetrope.xui.XPageDisplay;
import net.xoetrope.xui.XPageLoader;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.annotation.PageAnnotationProcessor;

public class XPageManager {
    private static final int CACHE_IGNORE = 0;
    private static final int CACHE_SAVE = 1;
    private static final int CACHE_CHECK_CLASS = 2;
    protected Hashtable pages;
    protected String packageName;
    protected Stack pageHistory;
    protected XPageDisplay pageDisplay;
    protected Vector secondaryLoaders;
    protected XProject currentProject;
    protected boolean triggerValidations;
    protected static PageAnnotationProcessor annotationProcessor;
    protected Hashtable pageNameMap;

    public XPageManager(XProject xProject) {
        this.currentProject = xProject;
        this.secondaryLoaders = new Vector();
        this.triggerValidations = false;
        String string = this.currentProject.getStartupParam("TriggerValidations");
        if (string != null && string.equals("true")) {
            this.triggerValidations = true;
        }
        try {
            if (annotationProcessor == null) {
                annotationProcessor = (PageAnnotationProcessor)Class.forName("net.xoetrope.optional.annotation.XPageAnnotationProcessor").newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pageNameMap = new Hashtable();
        this.reset();
    }

    public void setPackageName(String string) {
        if (string != null && string.length() > 0 && string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        this.packageName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageDisplay(XPageDisplay xPageDisplay) {
        this.pageDisplay = xPageDisplay;
        String string = null;
        String string2 = null;
        try {
            string = this.currentProject.getStartupParam("Frames");
            string2 = this.currentProject.getStartupParam("UseFrames");
        }
        catch (Exception exception) {
        }
        finally {
            if (string == null) {
                string = "frames";
            }
            if (string2 == null) {
                string2 = "true";
            }
        }
        this.loadFrames(string, string2.equals("true"));
    }

    public PageSupport loadPage(String string) {
        return this.doLoadPage(null, string, 2);
    }

    public PageSupport loadPage(String string, boolean bl) {
        return this.doLoadPage(null, string, bl ? 1 : 0);
    }

    public PageSupport loadPageAs(String string, String string2, boolean bl) {
        return this.doLoadPage(string, string2, bl ? 1 : 0);
    }

    private PageSupport doLoadPage(String string, String string2, int n) {
        string2 = this.lookupPageName(string2);
        XProjectManager.setCurrentProject(this.currentProject);
        PageSupport pageSupport = null;
        String string3 = this.packageName;
        int n2 = string2.lastIndexOf(46);
        if (n2 > 0) {
            string3 = string2.substring(0, n2);
        }
        String string4 = string2.substring(n2 + 1);
        if (string3 != null && string3.length() > 1) {
            string4 = string3 + (string3.endsWith(".") ? "" : ".") + string4;
        }
        if (string == null) {
            string = string4;
        }
        if (n != 0) {
            pageSupport = (PageSupport)this.pages.get(string);
        }
        if (pageSupport == null) {
            Object object;
            int n3 = this.secondaryLoaders.size();
            for (int i = 0; i < n3; ++i) {
                if (this.secondaryLoaders == null) continue;
                object = (XPageLoader)this.secondaryLoaders.elementAt(i);
                try {
                    pageSupport = object.loadPage(string3, string2, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pageSupport == null) continue;
                if (n == 2) {
                    int n4 = n = pageSupport instanceof XPage.IXDialog ? 0 : 1;
                }
                if (n != 1) break;
                this.pages.put(string, pageSupport);
                break;
            }
            if (pageSupport == null) {
                try {
                    pageSupport = (PageSupport)Class.forName(string4.trim()).newInstance();
                }
                catch (Exception exception) {
                    this.logPageCreationError(string2, "Unable to create the page: " + string4, exception);
                    object = this.currentProject.getStartupParam("DefaultClass");
                    if (object == null) {
                        pageSupport = new XPage();
                    }
                    try {
                        Class<?> clazz = Class.forName(((String)object).trim());
                        pageSupport = (PageSupport)clazz.newInstance();
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
                if (pageSupport != null) {
                    if (n == 2) {
                        int n5 = n = pageSupport instanceof XPage.IXDialog ? 0 : 1;
                    }
                    if (n == 1) {
                        this.pages.put(string, pageSupport);
                    }
                }
            }
            pageSupport.setName(string2);
            pageSupport.setStatus(2);
            try {
                if (annotationProcessor != null) {
                    annotationProcessor.setupComponents(pageSupport);
                }
                pageSupport.pageCreated();
            }
            catch (Exception exception) {
                this.logPageCreationError(string2, "The pageCreated method could not be invoked due to an exception", exception);
            }
        }
        return pageSupport;
    }

    public void unloadPage(String string) {
        int n = string.lastIndexOf(46);
        String string2 = this.packageName;
        String string3 = string.substring(n + 1);
        if (string2 != null && string2.length() > 1) {
            string3 = string2 + (string2.endsWith(".") ? "" : ".") + string3;
        }
        this.pages.remove(string3);
    }

    PageSupport attachPage(PageSupport pageSupport) {
        if (annotationProcessor == null) {
            return null;
        }
        String string = annotationProcessor.getPage(pageSupport);
        if (string != null) {
            int n = this.secondaryLoaders.size();
            for (int i = 0; i < n; ++i) {
                if (this.secondaryLoaders == null) continue;
                XPageLoader xPageLoader = (XPageLoader)this.secondaryLoaders.elementAt(i);
                try {
                    BufferedReader bufferedReader = this.currentProject.getBufferedReader(string);
                    if (bufferedReader == null) continue;
                    xPageLoader.setPage(pageSupport);
                    xPageLoader.readPage(bufferedReader, string, "xml", true);
                    pageSupport.setStatus(2);
                    annotationProcessor.setupComponents(pageSupport);
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return pageSupport;
        }
        return null;
    }

    protected void logPageCreationError(String string, String string2, Exception exception) {
        DebugLogger.logError(string2);
    }

    public void loadFrames(String string, boolean bl) {
        XPageLoader xPageLoader;
        int n = this.secondaryLoaders.size();
        for (int i = 0; !(i >= n || this.secondaryLoaders != null && (xPageLoader = (XPageLoader)this.secondaryLoaders.elementAt(i)) != null && xPageLoader.loadFrames(this.packageName, string, this.pageDisplay, bl)); ++i) {
        }
    }

    public PageSupport getPage(String string) {
        String string2 = this.packageName;
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        String string3 = string.substring(n + 1);
        if (string2 != null && string2.length() > 1) {
            string3 = string2 + (string2.endsWith(".") ? "" : ".") + string3;
        }
        return (PageSupport)this.pages.get(string3);
    }

    public PageSupport getCurrentPage(String string) {
        WidgetAdapter widgetAdapter = WidgetAdapter.getInstance();
        Object object = this.getTarget(string);
        if (object == null || widgetAdapter.getComponentCount(object) == 0) {
            return null;
        }
        Object object2 = widgetAdapter.getComponent(object, 0);
        if (object2 instanceof PageSupport) {
            return (PageSupport)object2;
        }
        int n = widgetAdapter.getComponentCount(object);
        for (int i = 1; i < n; ++i) {
            object2 = widgetAdapter.getComponent(object, i);
            if (object2 instanceof PageSupport) {
                return (PageSupport)object2;
            }
            int n2 = widgetAdapter.getComponentCount(object2);
            for (int j = 0; j < n2; ++j) {
                Object object3 = widgetAdapter.getComponent(object2, j);
                if (!(object3 instanceof PageSupport) || !widgetAdapter.isVisible(object3)) continue;
                return (PageSupport)object3;
            }
        }
        return null;
    }

    public PageSupport getPreviousPage() {
        int n = this.pageHistory.size();
        if (n > 1) {
            return this.getPage((String)this.pageHistory.elementAt(n - 2));
        }
        return null;
    }

    public PageSupport showPage(String string) {
        return this.showPage(string, null, null);
    }

    public PageSupport showPage(String string, String string2) {
        return this.showPage(string, string2, null);
    }

    public PageSupport showPage(String string, String string2, Hashtable hashtable) {
        if (!this.checkValidations(string2)) {
            return null;
        }
        PageSupport pageSupport = this.loadPage(string);
        if (pageSupport == null) {
            pageSupport = this.loadPage("ErrorPage");
        } else {
            this.pageHistory.push(string);
        }
        return (PageSupport)this.pageDisplay.displayPage(pageSupport, string2, hashtable);
    }

    public PageSupport showPrevious() {
        if (!this.checkValidations(null)) {
            return null;
        }
        if (this.pageHistory.size() > 1) {
            this.pageHistory.pop();
        }
        if (!this.pageHistory.empty()) {
            try {
                String string = (String)this.pageHistory.peek();
                if (string != null) {
                    PageSupport pageSupport = this.loadPage(string);
                    this.pageDisplay.displayPage(pageSupport);
                    return pageSupport;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public PageSupport showDialog(Object object, String string, String string2, int n, int n2) {
        DialogSupport dialogSupport = (DialogSupport)this.loadPage(string, false);
        dialogSupport.setCaption(string2);
        dialogSupport.pack();
        dialogSupport.setLocation(n, n2);
        dialogSupport.showDialog(object);
        return dialogSupport;
    }

    protected boolean checkValidations(String string) {
        int n;
        PageSupport pageSupport;
        return !this.triggerValidations || (pageSupport = this.getCurrentPage(string)) == null || (n = pageSupport.checkValidations()) == 0;
    }

    public void setTriggerValidations(boolean bl) {
        this.triggerValidations = bl;
    }

    public void addSecondaryLoader(XPageLoader xPageLoader) {
        this.secondaryLoaders.add(xPageLoader);
    }

    public Object getTarget(String string) {
        return this.pageDisplay.findTarget(string);
    }

    public int getNumTargets() {
        return this.pageDisplay.getNumTargets();
    }

    public Object getTarget(int n) {
        return this.pageDisplay.getTarget(n);
    }

    public void addHistory(String string) {
        this.pageHistory.push(string);
    }

    public void reset() {
        this.pages = new Hashtable(3);
        this.pageHistory = new Stack();
    }

    private String lookupPageName(String string) {
        String string2 = (String)this.pageNameMap.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public void mapPageName(String string, String string2) {
        this.pageNameMap.put(string, string2);
    }
}

