/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui;

import java.awt.Color;
import java.awt.Cursor;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xui.PageSupport;
import net.xoetrope.xui.WidgetAdapter;
import net.xoetrope.xui.XComponentFactory;
import net.xoetrope.xui.XDataBindingContext;
import net.xoetrope.xui.XMessageBoxSetup;
import net.xoetrope.xui.XPathEvaluator;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.data.XDataBinding;
import net.xoetrope.xui.events.XuiEventHandler;
import net.xoetrope.xui.exception.XExceptionHandler;
import net.xoetrope.xui.helper.ReflectionHelper;
import net.xoetrope.xui.style.XStyleFactory;
import net.xoetrope.xui.validation.XValidationFactory;
import net.xoetrope.xui.validation.XValidationHandler;
import net.xoetrope.xui.validation.XValidator;

public class XPageHelper {
    public static final Cursor hand = Cursor.getPredefinedCursor(12);
    public XStyleFactory componentFactory;
    public XDataBindingContext dataBindingContext;
    public XPathEvaluator pathEvaluator;
    public Vector hiddenComponents;
    public XuiEventHandler eventHandler;
    public Hashtable attribs;
    public int status;
    public boolean clearPage;
    public XProject currentProject;
    public WidgetAdapter adapter;
    public PageSupport page;
    protected XPathEvaluator evaluator;
    public String pageName;
    public String pageExtension;

    public XPageHelper(XProject xProject, PageSupport pageSupport) {
        Object object;
        this.page = pageSupport;
        this.currentProject = xProject;
        this.adapter = WidgetAdapter.getInstance();
        this.page.setBackground(Color.white);
        this.page.setLayout(null);
        this.status = 0;
        this.pathEvaluator = new XPathEvaluator(this.currentProject, this.page);
        this.dataBindingContext = null;
        String string = xProject.getStartupParam("XDataBindingContextClass");
        if (string != null) {
            try {
                object = Class.forName(string);
                if (XDataBindingContext.class.isAssignableFrom((Class<?>)object)) {
                    this.dataBindingContext = (XDataBindingContext)((Class)object).getConstructor(XPathEvaluator.class).newInstance(this.pathEvaluator);
                }
            }
            catch (Exception exception) {
                DebugLogger.logWarning("couldn't instantiate binding context class: " + string);
                this.dataBindingContext = null;
            }
        }
        if (this.dataBindingContext == null) {
            this.dataBindingContext = new XDataBindingContext(this.pathEvaluator);
        }
        this.hiddenComponents = null;
        object = new XValidationHandler(this.page);
        this.eventHandler = this.currentProject.createEventHandler(this.page, (XValidationHandler)object);
        this.componentFactory = new XStyleFactory(this.currentProject, this.currentProject.getWidgetPackageName());
        this.componentFactory.setParentComponent(this.page);
        this.attribs = new Hashtable();
        this.clearPage = true;
        try {
            String string2 = this.currentProject.getStartupParam("PageExceptionHandler");
            if (string2 == null || string2.toLowerCase().compareTo("true") == 0) {
                this.setExceptionHandler(this.page);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getPageExtension() {
        return this.pageExtension;
    }

    public void setPageName(String string) {
        this.pageName = string;
    }

    public void setPageExtension(String string) {
        this.pageExtension = string;
    }

    public void setClearPage(boolean bl) {
        this.clearPage = bl;
    }

    public void showComponents(Object object, boolean bl, int n) {
        if (bl) {
            if (this.hiddenComponents != null) {
                int n2 = this.hiddenComponents.size();
                for (int i = 0; i < n2; ++i) {
                    Object e = this.hiddenComponents.elementAt(i);
                    if (e == null) continue;
                    this.adapter.setVisible(e, true);
                }
                this.hiddenComponents = null;
            }
        } else {
            int n3 = this.adapter.getComponentCount(object);
            if (n == 0) {
                this.hiddenComponents = new Vector(n3, 4);
            }
            for (int i = 0; i < n3; ++i) {
                Object object2 = this.adapter.getComponent(object, i);
                if (this.adapter.isVisible(object2)) {
                    this.adapter.setVisible(object2, false);
                    this.hiddenComponents.addElement(object2);
                }
                if (!this.adapter.isContainer(object2)) continue;
                this.showComponents(object2, false, ++n);
            }
        }
    }

    public Object findComponent(String string) {
        Object object = this.findComponent(this.page, string);
        if (object == null) {
            // empty if block
        }
        return object;
    }

    public Object findComponent(Object object, String string) {
        int n = this.adapter.getComponentCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2;
            Object object3 = this.adapter.getComponent(object, i);
            String string2 = this.adapter.getName(object3);
            if (string2 != null && string2.compareTo(string) == 0) {
                return object3;
            }
            if (!this.adapter.isContainer(object3) || (object2 = this.findComponent(object3, string)) == null) continue;
            return object2;
        }
        return null;
    }

    public void setExceptionHandler(XExceptionHandler xExceptionHandler) {
        this.eventHandler.getValidationHandler().setExceptionHandler(xExceptionHandler);
    }

    public boolean handleException(Object object, Exception exception, Object object2) {
        exception.printStackTrace();
        return true;
    }

    public boolean handleEventHandlerException(XProject xProject, Object object, Throwable throwable) {
        return true;
    }

    public void clearValidations() {
        this.eventHandler.getValidationHandler().clearValidations();
    }

    public int checkValidations() {
        XValidationHandler xValidationHandler = this.eventHandler.getValidationHandler();
        xValidationHandler.accumulateMessages(true, 0);
        int n = xValidationHandler.checkValidations();
        n = xValidationHandler.accumulateMessages(false, n);
        return n;
    }

    public int accumulateMessages(boolean bl, int n) {
        return n;
    }

    public XValidator addValidation(Object object, String string, String string2, int n, XmlElement xmlElement) {
        return this.eventHandler.getValidationHandler().addValidation(this.eventHandler, object, string, string2, n, xmlElement);
    }

    public XValidator addValidation(Object object, String string, String string2) {
        return this.addValidation(object, string, string2, 1005, null);
    }

    public XValidator addValidation(Object object, String string) {
        return this.addValidation(object, string, null, 1005, null);
    }

    public void setValidationFactory(XValidationFactory xValidationFactory) {
        this.eventHandler.getValidationHandler().setValidationFactory(xValidationFactory);
    }

    public XValidationHandler getValidationHandler() {
        return this.eventHandler.getValidationHandler();
    }

    public int validationHandler(XuiEventHandler xuiEventHandler) {
        return xuiEventHandler.getValidationHandler().validationHandler(xuiEventHandler);
    }

    public XuiEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(XuiEventHandler xuiEventHandler) {
        this.eventHandler = xuiEventHandler;
    }

    public EventObject getCurrentEvent() {
        return this.eventHandler.getCurrentEvent();
    }

    public void addListener(Object object, String string, String string2, Object object2) {
        this.eventHandler.addListener(object, string, string2, object2);
    }

    public void addHandler(Object object, long l, String string) throws ClassNotFoundException, NoSuchMethodException {
        this.eventHandler.addHandler(object, l, string);
    }

    public boolean isFocusChangeSuppressed() {
        return this.eventHandler.isFocusChangeSuppressed();
    }

    public void addHandler(Object object, String string, String string2, String string3, long l, Object object2) {
        this.eventHandler.addHandler(object, string, string2, string3, l, object2);
    }

    public boolean wasMouseClicked() {
        return this.eventHandler.wasMouseClicked();
    }

    public boolean wasMouseDoubleClicked() {
        return this.eventHandler.wasMouseDoubleClicked();
    }

    public boolean wasMouseRightClicked() {
        return this.eventHandler.wasMouseRightClicked();
    }

    public void showHandCursor(Object object) {
        this.adapter.setCursor(object, hand);
    }

    public XDataBindingContext getDataBindingContext() {
        return this.dataBindingContext;
    }

    public Vector getBindings() {
        return this.dataBindingContext.getBindings();
    }

    public void addBinding(XDataBinding xDataBinding) {
        this.dataBindingContext.addBinding(xDataBinding, this.status == 2 || this.status == 3);
    }

    public void removeBinding(XDataBinding xDataBinding) {
        this.dataBindingContext.removeBinding(xDataBinding);
    }

    public void updateBindings() {
        this.dataBindingContext.updateBindings();
    }

    public void updateBinding(XDataBinding xDataBinding) {
        this.dataBindingContext.updateBinding(xDataBinding);
    }

    public void updateBoundComponentValues() {
        this.dataBindingContext.updateBoundComponentValues();
    }

    public void saveBoundComponentValues() {
        this.dataBindingContext.saveBoundComponentValues();
    }

    public XDataBinding getBinding(Object object) {
        return this.dataBindingContext.getBinding(object);
    }

    public XDataBinding getBinding(String string) {
        return this.dataBindingContext.getBinding(string);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void pageActivated() {
    }

    public void pageAdded() {
    }

    public void pageCreated() {
    }

    public void pageDeactivated() {
    }

    public void setAttribute(String string, String string2, Object object) {
        if (object != null) {
            this.attribs.put(string + (string2 != null ? "_" + string2 : ""), object);
        }
    }

    public Object getAttribute(String string) {
        EventObject eventObject = this.getCurrentEvent();
        return this.getAttribute(string, eventObject == null ? "" : this.adapter.getName(eventObject.getSource()));
    }

    public Object getAttribute(String string, String string2) {
        return this.attribs.get(string + (string2 != null ? "_" + string2 : ""));
    }

    public Object getAttributes() {
        return this.attribs;
    }

    public String getComponentName(Object object) {
        String string = this.adapter.getName(object);
        if (string == null || string.length() == 0) {
            string = new Integer(object.hashCode()).toString();
        }
        return string;
    }

    public Object getEventAttribute(Object object, String string) {
        return this.attribs.get(string);
    }

    public Object evaluateAttribute(String string) {
        return this.pathEvaluator.evaluateAttribute(string);
    }

    public String evaluatePath(String string) {
        return this.pathEvaluator.evaluatePath(string);
    }

    public String stripAttributeValues(String string) {
        return this.pathEvaluator.stripAttributeValues(string);
    }

    public XComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public void setComponentFactory(XStyleFactory xStyleFactory) {
        this.componentFactory = xStyleFactory;
        this.componentFactory.setParentComponent(this.page);
    }

    public String translate(String string) {
        return this.componentFactory.translate(string);
    }

    public void showMessage(String string, String string2) {
        this.showMessage(this.page.getOwner(), string, string2);
    }

    public void showMessage(Object object, String string, String string2) {
        if (!WidgetAdapter.getInstance().requiresParent()) {
            new MessageThread(object, string, string2).start();
        } else {
            try {
                XProjectManager.setCurrentProject(this.currentProject);
                this.eventHandler.suppressFocusEvents(true);
                XMessageBoxSetup xMessageBoxSetup = (XMessageBoxSetup)ReflectionHelper.constructViaReflection(null, this.currentProject.getPackageName() + ".XMessageBox", Object.class, this.currentProject.getObject("ClientShell"));
                xMessageBoxSetup.setup(this.translate(string), this.translate(string2), this.page.getPageSize(), this);
                this.eventHandler.suppressFocusEvents(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class MessageThread
    extends Thread {
        String msg;
        String caption;
        Object container;

        public MessageThread(Object object, String string, String string2) {
            this.container = object;
            this.msg = string2;
            this.caption = string;
            this.setPriority(5);
        }

        public void run() {
            XPageHelper.this.eventHandler.suppressFocusEvents(true);
            try {
                XMessageBoxSetup xMessageBoxSetup = (XMessageBoxSetup)Class.forName(XPageHelper.this.currentProject.getPackageName() + ".XMessageBox").newInstance();
                xMessageBoxSetup.setup(XPageHelper.this.translate(this.caption), XPageHelper.this.translate(this.msg), XPageHelper.this.page.getPageSize(), this.container);
            }
            catch (Exception exception) {
                // empty catch block
            }
            XPageHelper.this.eventHandler.suppressFocusEvents(false);
        }
    }
}

