/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui;

import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;
import net.xoetrope.xui.PageSupport;
import net.xoetrope.xui.XHashCode;
import net.xoetrope.xui.XMethodReference;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.evaluator.XAttributeEvaluator;
import net.xoetrope.xui.evaluator.XDefaultAttributeEvaluator;
import net.xoetrope.xui.events.XAction;
import net.xoetrope.xui.events.XActionManager;
import net.xoetrope.xui.events.XEventAdapter;
import net.xoetrope.xui.events.XListenerHelper;
import net.xoetrope.xui.events.XuiEventHandler;
import net.xoetrope.xui.exception.XExceptionHandler;
import net.xoetrope.xui.helper.ReflectionHelper;
import net.xoetrope.xui.helper.XuiUtilities;
import net.xoetrope.xui.validation.XValidationHandler;

public class XEventHandler
implements XuiEventHandler,
ActionListener,
FocusListener,
TextListener,
ItemListener,
KeyListener,
MouseListener,
MouseMotionListener {
    protected static Hashtable configFiles;
    protected static int changeCounter;
    protected static int localChangeCounter;
    protected static Hashtable registrations;
    protected static EventObject currentEvt;
    protected Object container;
    protected XProject currentProject;
    protected Hashtable handlers = new Hashtable(5);
    protected Object mouseDownComponent = null;
    protected boolean mouseEventInvoked = false;
    protected int suppressFocusEvents = 0;
    protected XValidationHandler xValidationHandler;

    public XEventHandler(XProject xProject, Object object, XValidationHandler xValidationHandler) {
        URL uRL;
        if (registrations == null) {
            registrations = new Hashtable();
        }
        this.currentProject = xProject;
        this.container = object;
        this.xValidationHandler = xValidationHandler;
        this.xValidationHandler.setupEventHandler(this);
        this.currentProject = xProject;
        XEventHandler.addConfigFile("XUI", "net/xoetrope/xui/events/events.xml", false);
        this.currentProject = xProject;
        String string = this.currentProject.getStartupParam("EventHandlers");
        if (string == null || string.length() == 0) {
            string = "events.xml";
        }
        if (string.indexOf(".xml") < 0) {
            string = string + ".xml";
        }
        if ((uRL = this.currentProject.findResource(string)) != null) {
            XEventHandler.addConfigFile("Project", uRL, false);
        }
    }

    public void removeHandlers(Object object) {
        long l = object.hashCode();
        if (object instanceof XHashCode) {
            l = ((XHashCode)object).getComponentHashCode();
        }
        long[] lArray = new long[]{128L, 4L, 1024L, 512L, 8L, 16L, 32L};
        String[] stringArray = new String[]{"ActionListener", "FocusListener", "TextListener", "ItemListener", "KeyListener", "MouseListener", "MouseMotionListener"};
        for (int i = 0; i < lArray.length; ++i) {
            Long l2 = new Long(lArray[i] * l);
            Object v = this.handlers.get(l2);
            if (v == null) continue;
            this.handlers.remove(l2);
            this.addListener(object, "remove" + stringArray[i], "java.awt.event." + stringArray[i], this);
        }
    }

    public XValidationHandler getValidationHandler() {
        return this.xValidationHandler;
    }

    public void invoke(long l, EventObject eventObject) {
        try {
            block11: {
                currentEvt = eventObject;
                if (this.xValidationHandler.validationHandler(this) > 1) {
                    return;
                }
                XMethodReference xMethodReference = (XMethodReference)this.handlers.get(new Long(l * (long)eventObject.getSource().hashCode()));
                if (xMethodReference == null) {
                    XAction xAction;
                    XActionManager xActionManager;
                    String string = (String)ReflectionHelper.getViaReflection("getActionCommand", eventObject.getSource(), false);
                    if (string != null && (xActionManager = (XActionManager)this.currentProject.getObject("ActionManager")) != null && (xAction = xActionManager.getAction(null, string)) != null) {
                        xAction.actionPerformed(eventObject);
                    }
                    return;
                }
                Method method = xMethodReference.method;
                try {
                    if (method != null && method.getName().compareTo("validationHandler") != 0) {
                        method.invoke(xMethodReference.instance, xMethodReference.args);
                    }
                }
                catch (Throwable throwable) {
                    XExceptionHandler xExceptionHandler;
                    DebugLogger.logWarning("error invoking '" + method.getName() + "' in XEventHandler");
                    boolean bl = false;
                    if (this.container instanceof XExceptionHandler) {
                        bl = ((XExceptionHandler)this.container).handleEventHandlerException(this.currentProject, this.container, throwable);
                    }
                    if (bl && this.xValidationHandler != this.container) {
                        bl = this.xValidationHandler.handleEventHandlerException(this.currentProject, this.container, throwable);
                    }
                    if (bl && (xExceptionHandler = this.currentProject.getExceptionHandler()) != null) {
                        bl = xExceptionHandler.handleEventHandlerException(this.currentProject, this.container, throwable);
                    }
                    if (!bl) break block11;
                    throwable.getCause().printStackTrace();
                }
            }
            currentEvt = null;
        }
        catch (Exception exception) {
            System.out.println("Error invoking");
        }
    }

    public Method findEvent(Object object, long l) {
        XMethodReference xMethodReference = (XMethodReference)this.handlers.get(new Long(l * (long)object.hashCode()));
        return xMethodReference.method;
    }

    public boolean isFocusChangeSuppressed() {
        return this.suppressFocusEvents > 0;
    }

    public EventObject getCurrentEvent() {
        return currentEvt;
    }

    public XMethodReference addHandler(Object object, long l, String string) throws ClassNotFoundException, NoSuchMethodException {
        String string2;
        String string3;
        if (string == null) {
            return null;
        }
        if (string.startsWith("${script.")) {
            string3 = "Script";
            string2 = string;
        } else {
            int n = string.lastIndexOf(".");
            if (n < 0) {
                string2 = string;
                string3 = null;
            } else {
                string3 = string.substring(0, n);
                string2 = string.substring(n + 1);
            }
        }
        XMethodReference xMethodReference = this.getMethodReference(this.container, string3, string2);
        long l2 = object.hashCode();
        if (object instanceof XHashCode) {
            l2 = ((XHashCode)object).getComponentHashCode();
        }
        this.handlers.put(new Long(l * l2), xMethodReference);
        return xMethodReference;
    }

    public void addListener(Object object, String string, String string2, Object object2) {
        try {
            Class[] classArray = new Class[]{Class.forName(string2.trim())};
            Method method = object.getClass().getMethod(string, classArray);
            Object[] objectArray = new Object[]{object2};
            method.invoke(object, objectArray);
        }
        catch (Error error) {
            error.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public XMethodReference addHandler(Object object, String string, String string2, String string3, long l, Object object2) {
        XMethodReference xMethodReference = null;
        if (object2 == null) {
            object2 = this;
        }
        this.addListener(object, string2, string3, object2);
        try {
            xMethodReference = this.addHandler(object, l, string);
        }
        catch (Error error) {
            error.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return xMethodReference;
    }

    public boolean wasMouseClicked() {
        AWTEvent aWTEvent;
        if (currentEvt != null && currentEvt instanceof AWTEvent && ((aWTEvent = (AWTEvent)currentEvt).getID() == 500 || aWTEvent.getID() == 502 && aWTEvent.getSource() == this.mouseDownComponent)) {
            this.mouseDownComponent = null;
            return true;
        }
        this.mouseEventInvoked = true;
        return false;
    }

    public boolean wasMouseDoubleClicked() {
        AWTEvent aWTEvent;
        if (currentEvt != null && currentEvt instanceof AWTEvent && ((aWTEvent = (AWTEvent)currentEvt).getID() == 500 || aWTEvent.getID() == 502 && aWTEvent.getSource() == this.mouseDownComponent && (((MouseEvent)aWTEvent).getModifiers() & 0x10) != 0 && ((MouseEvent)aWTEvent).getClickCount() == 2)) {
            this.mouseDownComponent = null;
            return true;
        }
        this.mouseEventInvoked = true;
        return false;
    }

    public boolean wasMouseRightClicked() {
        AWTEvent aWTEvent;
        if (currentEvt != null && currentEvt instanceof AWTEvent && ((aWTEvent = (AWTEvent)currentEvt).getID() == 500 || aWTEvent.getID() == 502 && aWTEvent.getSource() == this.mouseDownComponent && (((MouseEvent)aWTEvent).getModifiers() & 4) != 0)) {
            this.mouseDownComponent = null;
            return true;
        }
        this.mouseEventInvoked = true;
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.invoke(128L, actionEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.suppressFocusEvents < 2) {
            this.invoke(4L, focusEvent);
            if (this.suppressFocusEvents == 1) {
                ++this.suppressFocusEvents;
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.suppressFocusEvents == 0) {
            this.invoke(4L, focusEvent);
        } else {
            --this.suppressFocusEvents;
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.invoke(1024L, textEvent);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.invoke(512L, itemEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.invoke(8L, keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.invoke(8L, keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.invoke(8L, keyEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.mouseEventInvoked) {
            this.invoke(16L, mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.invoke(16L, mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.invoke(16L, mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDownComponent = mouseEvent.getComponent();
        this.mouseEventInvoked = false;
        this.invoke(16L, mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.invoke(16L, mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.invoke(32L, mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.invoke(32L, mouseEvent);
    }

    public void suppressFocusEvents(boolean bl) {
        this.suppressFocusEvents = bl ? ++this.suppressFocusEvents : Math.max(--this.suppressFocusEvents, 0);
    }

    private XMethodReference getMethodReference(Object object, String string, String string2) throws ClassNotFoundException, NoSuchMethodException {
        int n;
        Class<?> clazz = null;
        if (string == null) {
            clazz = object.getClass();
            string = clazz.getName();
        }
        if (string.startsWith("${")) {
            XAttributeEvaluator xAttributeEvaluator = (XAttributeEvaluator)this.currentProject.getObject("DefaultAttributeEvaluator");
            if (xAttributeEvaluator == null) {
                xAttributeEvaluator = new XDefaultAttributeEvaluator(this.currentProject);
                xAttributeEvaluator.setCurrentProject(this.currentProject);
                this.currentProject.setObject("DefaultAttributeEvaluator", xAttributeEvaluator);
            }
            XMethodReference xMethodReference = xAttributeEvaluator.getMethodReference(object, string + "." + string2);
            return xMethodReference;
        }
        if (string.startsWith("Script")) {
            XMethodReference xMethodReference = null;
            try {
                XAttributeEvaluator xAttributeEvaluator = (XAttributeEvaluator)this.currentProject.getObject("ScriptAttributeEvaluator");
                if (xAttributeEvaluator == null) {
                    xAttributeEvaluator = (XAttributeEvaluator)Class.forName("net.xoetrope.optional.scripts.ScriptAttributeEvaluator").newInstance();
                    xAttributeEvaluator.setCurrentProject(this.currentProject);
                    this.currentProject.setObject("ScriptAttributeEvaluator", xAttributeEvaluator);
                }
                xMethodReference = xAttributeEvaluator.getMethodReference(string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return xMethodReference;
        }
        Method method = null;
        if (clazz == null) {
            clazz = Class.forName(string.trim());
        }
        if (string2.endsWith("}")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.endsWith("()")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        if ((n = string2.indexOf("(")) > 0) {
            String string3 = string2.substring(n + 1, string2.indexOf(41));
            int n2 = 1 + XuiUtilities.count(string3, ',');
            Object[] objectArray = new Object[n2];
            Class[] classArray = new Class[n2];
            XuiUtilities.getArguments(string3, classArray, objectArray, ',');
            string2 = string2.substring(0, n);
            method = clazz.getMethod(string2, classArray);
            return new XMethodReference(clazz, object, method, objectArray);
        }
        method = clazz.getMethod(string2, null);
        return new XMethodReference(clazz, object, method, null);
    }

    public void addHandler(PageSupport pageSupport, Object object, String string, String string2) {
        this.checkRegistration();
        try {
            if ("Action".equals(string)) {
                ReflectionHelper.setViaReflection("setActionCommand", object, string2);
                return;
            }
            XEventRegistration xEventRegistration = (XEventRegistration)registrations.get(string);
            if (xEventRegistration != null) {
                if (string.indexOf(46) > 0) {
                    try {
                        XEventAdapter xEventAdapter = (XEventAdapter)Class.forName(xEventRegistration.interfaceName.trim()).newInstance();
                        xEventAdapter.setEventHandler(this);
                        this.addHandler(object, string2, xEventAdapter.getAddMethodName(), xEventAdapter.getListenerInterfaceName(), xEventAdapter.getEventMask(), xEventAdapter);
                        return;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                String string3 = "add" + xEventRegistration.interfaceName.substring(xEventRegistration.interfaceName.lastIndexOf(46) + 1);
                this.addHandler(object, string2, string3, xEventRegistration.interfaceName, xEventRegistration.mask, this);
                return;
            }
            if (string.indexOf(46) > 0) {
                try {
                    XEventAdapter xEventAdapter = (XEventAdapter)Class.forName(string.trim()).newInstance();
                    xEventAdapter.setEventHandler(this);
                    this.addHandler(object, string2, xEventAdapter.getAddMethodName(), xEventAdapter.getListenerInterfaceName(), xEventAdapter.getEventMask(), xEventAdapter);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                ((XListenerHelper)object).addHandler(pageSupport, string, string2);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static void addConfigFile(String string, Object object, boolean bl) {
        Object v;
        if (object == null) {
            return;
        }
        if (configFiles == null) {
            configFiles = new Hashtable();
        }
        if ((v = configFiles.get(string)) != null && object.equals(v)) {
            return;
        }
        ++changeCounter;
        if (v != null || bl) {
            configFiles.remove(string);
        }
        configFiles.put(string, object);
    }

    public void updateConfig() {
        ++changeCounter;
    }

    protected void read() {
        registrations.clear();
        Enumeration enumeration = configFiles.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("Project")) continue;
            this.doRead(string, configFiles.get(string));
        }
        this.doRead("Project", configFiles.get("Project"));
    }

    protected void read(String string, String string2) {
        XEventHandler.addConfigFile(string, string2, true);
        this.doRead(string, string2);
    }

    protected void doRead(String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof URL) {
            this.doRead(string, (URL)object);
        } else {
            this.doRead(string, (String)object);
        }
    }

    protected void doRead(String string, String string2) {
        try {
            BufferedReader bufferedReader;
            String string3 = string2;
            if (string3.indexOf(".xml") < 0) {
                string3 = string3 + ".xml";
            }
            if ((bufferedReader = this.currentProject.getBufferedReader(string3, null)) != null) {
                this.read(string, bufferedReader);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void doRead(String string, URL uRL) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            if (bufferedReader != null) {
                this.read(string, bufferedReader);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void read(String string, Reader reader) {
        try {
            XmlElement xmlElement = XmlSource.read(reader);
            Vector vector = xmlElement.getChildren();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
                String string2 = xmlElement2.getAttribute("name");
                XEventRegistration xEventRegistration = new XEventRegistration();
                xEventRegistration.interfaceName = xmlElement2.getAttribute("adapter");
                if (xEventRegistration.interfaceName == null || xEventRegistration.interfaceName.length() == 0) {
                    xEventRegistration.interfaceName = xmlElement2.getAttribute("interface");
                    xEventRegistration.mask = Long.parseLong(xmlElement2.getAttribute("mask"));
                }
                registrations.put(string2, xEventRegistration);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkRegistration() {
        if (localChangeCounter != changeCounter) {
            this.read();
            localChangeCounter = changeCounter;
        }
    }

    static {
        localChangeCounter = -1;
    }

    class XEventRegistration {
        public String interfaceName;
        long mask;

        XEventRegistration() {
        }
    }
}

