/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import net.xoetrope.registry.ComponentAdapter;
import net.xoetrope.xui.LayoutHelper;
import net.xoetrope.xui.MetaContentReader;
import net.xoetrope.xui.WidgetAdapter;
import net.xoetrope.xui.XComponentConstructor;
import net.xoetrope.xui.XImageHolder;
import net.xoetrope.xui.XModelHolder;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XTextHolder;
import net.xoetrope.xui.data.XModel;
import net.xoetrope.xui.helper.XLayoutHelper;
import net.xoetrope.xui.helper.XTranslator;

public class XComponentFactory {
    public static final int XUNKNOWN = -1;
    public static final int XPANEL = 0;
    public static final int XLABEL = 1;
    public static final int XRADIO = 2;
    public static final int XCHECK = 3;
    public static final int XCOMBO = 4;
    public static final int XLIST = 5;
    public static final int XIMAGE = 6;
    public static final int XEDIT = 7;
    public static final int XBUTTON = 8;
    public static final int XMETACONTENT = 9;
    public static final int XGROUP = 10;
    public static final int XSCROLLPANE = 11;
    public static final int XSCROLLABLEMETACONTENT = 12;
    public static final int XHOTSPOTIMAGE = 13;
    public static final int XTABLE = 14;
    public static final int XWMF = 15;
    public static final int XANNOTATEDIMAGE = 16;
    public static final int XMENUBAR = 17;
    public static final int XMENU = 18;
    public static final int XMENUITEM = 19;
    public static final int XTEXTAREA = 20;
    public static final int XPASSWORD = 21;
    public static final int XIMAGEMAP = 22;
    public static final int XTABPANEL = 23;
    public static final int XSPLITPANE = 24;
    protected static Hashtable componentFactories = new Hashtable();
    protected static Hashtable typeNames;
    protected static LayoutHelper layoutHelper;
    protected static boolean requiresParent;
    protected String basePackageName;
    protected XTranslator translator;
    protected XProject currentProject;
    protected WidgetAdapter adapter;
    protected Object currentMenuBar;
    protected Object currentMenu;
    protected Object parentPanel;
    protected int parentW;
    protected int parentH;

    public XComponentFactory(XProject xProject, String string) {
        this.currentProject = xProject;
        if (string == null) {
            string = "net.xoetrope.awt";
        }
        this.adapter = WidgetAdapter.getInstance();
        this.basePackageName = string + "." + "X";
        XComponentFactory.setupTypeNames();
        this.translator = this.currentProject.getTranslator();
    }

    public void setResourceBundle(String string) {
        if (this.translator == null) {
            this.translator = this.currentProject.getTranslator(string);
        }
        if (this.translator != null) {
            this.translator.setResourceBundle(this.currentProject.getResourceBundle(string));
        }
    }

    public Object constructComponent(String string, String string2) {
        int n = XComponentFactory.getTypeCode(string);
        if (n < 0) {
            return this.buildRegisteredComponent(string, string2);
        }
        Object object = null;
        try {
            switch (n) {
                case 0: {
                    object = this.instantiate(this.basePackageName + "Panel");
                    if (this.parentPanel != null) break;
                    this.parentPanel = object;
                    break;
                }
                case 1: {
                    object = this.instantiate(this.basePackageName + "Label");
                    if (string2 == null) break;
                    ((XTextHolder)object).setText(this.translate(string2));
                    break;
                }
                case 2: {
                    object = this.instantiate(this.basePackageName + "RadioButton");
                    if (string2 == null) break;
                    ((XTextHolder)object).setText(this.translate(string2));
                    break;
                }
                case 3: {
                    object = this.instantiate(this.basePackageName + "Checkbox");
                    ((XTextHolder)object).setText(this.translate(string2));
                    break;
                }
                case 4: {
                    object = this.instantiate(this.basePackageName + "ComboBox");
                    break;
                }
                case 5: {
                    object = this.instantiate(this.basePackageName + "List");
                    break;
                }
                case 6: {
                    object = this.instantiate(this.basePackageName + "Image");
                    this.currentProject.getImage((XImageHolder)object, string2);
                    break;
                }
                case 22: {
                    object = this.instantiate(this.basePackageName + "ImageMap");
                    ((XImageHolder)object).setImage(this.currentProject.getImage(string2));
                    break;
                }
                case 7: {
                    object = this.instantiate(this.basePackageName + "Edit");
                    if (string2 == null) break;
                    ((XTextHolder)object).setText(this.translate(string2));
                    break;
                }
                case 20: {
                    object = this.instantiate(this.basePackageName + "TextArea");
                    if (string2 == null) break;
                    ((XTextHolder)object).setText(this.translate(string2));
                    break;
                }
                case 21: {
                    object = this.instantiate(this.basePackageName + "Password");
                    if (string2 == null) break;
                    ((XTextHolder)object).setText(this.translate(string2));
                    break;
                }
                case 8: {
                    object = this.instantiate(this.basePackageName + "Button");
                    if (string2 == null) break;
                    ((XTextHolder)object).setText(this.translate(string2));
                    break;
                }
                case 9: {
                    object = this.instantiate(this.basePackageName + "MetaContent");
                    if (string2 == null) break;
                    this.setMetaContent(object, string2);
                    break;
                }
                case 11: {
                    object = this.instantiate(this.basePackageName + "ScrollPane");
                    break;
                }
                case 12: {
                    object = this.instantiate(this.basePackageName + "ScrollableMetaContent");
                    this.setMetaContent(object, string2);
                    break;
                }
                case 13: {
                    object = this.instantiate(this.basePackageName + "HotspotImage");
                    ((XImageHolder)object).setImage(this.currentProject.getImage(string2));
                    break;
                }
                case 14: {
                    object = this.instantiate(this.basePackageName + "Table");
                    this.setTableContent(object, string2);
                    break;
                }
                case 15: {
                    object = this.instantiate("net.xoetrope.xui.wmf.XWmf");
                    if (string2 == null) break;
                    ((XTextHolder)object).setText(this.translate(string2));
                    break;
                }
                case 23: {
                    object = this.instantiate(this.basePackageName + "TabPanel");
                    break;
                }
                case 24: {
                    object = this.instantiate(this.basePackageName + "SplitPane");
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    protected Object instantiate(String string) {
        try {
            Class<?> clazz = Class.forName(string.trim());
            if (!requiresParent) {
                return clazz.newInstance();
            }
            Class[] classArray = new Class[]{Object.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.parentPanel};
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String translate(String string) {
        if (this.translator != null) {
            return this.translator.translate(string);
        }
        return string;
    }

    public Object addComponent(String string, int n, int n2, int n3, int n4, String string2) {
        Object object = null;
        try {
            String string3;
            object = this.constructComponent(string, string2);
            if (object == null) {
                object = this.buildRegisteredComponent(string, string2);
            }
            if (object == null) {
                string3 = string.trim();
                if (string.indexOf(".") <= 0) {
                    string3 = this.basePackageName + string3;
                }
                if ((object = Class.forName(string3).newInstance()) instanceof XTextHolder) {
                    ((XTextHolder)object).setText(string2);
                }
            }
            if (object == null) {
                return null;
            }
            if (this.parentW > 0 && n3 > 0) {
                string3 = this.parentPanel.getClass().getName();
                if (string3.indexOf("ScrollPane") < 0) {
                    this.adapter.setBounds(object, n, n2, Math.min(n3, this.parentW - n), Math.min(n4, this.parentH));
                } else if (string3.indexOf(".swt.") > 0) {
                    this.adapter.setBounds(object, n, n2, n3, n4);
                }
            } else if (n3 > 0) {
                this.adapter.setBounds(object, n, n2, n3, n4);
            }
            if (object != null) {
                this.addComponent(object);
                return object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public Object addComponent(String string, Object object, String string2) {
        Object object2 = null;
        try {
            object2 = this.constructComponent(string, string2);
            if (object2 == null) {
                object2 = this.buildRegisteredComponent(string, string2);
            }
            if (object2 != null) {
                if (object != null) {
                    this.addComponent(object2, object);
                } else {
                    this.addComponent(object2);
                }
                return object2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object2;
    }

    protected Object buildRegisteredComponent(String string, String string2) {
        Enumeration enumeration = componentFactories.keys();
        while (enumeration.hasMoreElements()) {
            XComponentConstructor xComponentConstructor = (XComponentConstructor)componentFactories.get(enumeration.nextElement());
            Object object = xComponentConstructor.constructComponent(this, string, string2);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public ComponentAdapter getComponentAdapter(String string) {
        Enumeration enumeration = componentFactories.keys();
        while (enumeration.hasMoreElements()) {
            XComponentConstructor xComponentConstructor = (XComponentConstructor)componentFactories.get(enumeration.nextElement());
            ComponentAdapter componentAdapter = xComponentConstructor.getComponentAdapter(string);
            if (componentAdapter == null) continue;
            return componentAdapter;
        }
        return null;
    }

    public static void registerComponentFactory(String string, XComponentConstructor xComponentConstructor) {
        if (componentFactories.get(string) == null) {
            componentFactories.put(string, xComponentConstructor);
        }
    }

    public static void updateComponentFactories() {
        Enumeration enumeration = componentFactories.keys();
        while (enumeration.hasMoreElements()) {
            XComponentConstructor xComponentConstructor = (XComponentConstructor)componentFactories.get(enumeration.nextElement());
            xComponentConstructor.update();
        }
    }

    public static Hashtable getFactories() {
        return componentFactories;
    }

    public Object addElement(String string, String string2, String string3, Hashtable hashtable) {
        Enumeration enumeration = componentFactories.keys();
        while (enumeration.hasMoreElements()) {
            XComponentConstructor xComponentConstructor = (XComponentConstructor)componentFactories.get(enumeration.nextElement());
            Object object = xComponentConstructor.addElement(this, string, string2, string3, hashtable);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public void addComponent(Object object) {
        if (object != this.parentPanel && this.parentPanel != null) {
            this.adapter.add(this.parentPanel, object);
        }
    }

    public void addComponent(Object object, Object object2) {
        if (object != this.parentPanel) {
            this.adapter.add(this.parentPanel, object, object2);
        }
    }

    public Object addLayout(Object object, int n) {
        if (object == null) {
            object = this.parentPanel;
        }
        return layoutHelper.addLayout(object, n);
    }

    public void setParentComponent(Object object) {
        this.parentPanel = object;
        if (this.parentPanel != null) {
            int n = this.adapter.getWidth(this.parentPanel);
            int n2 = this.adapter.getHeight(this.parentPanel);
            this.parentW = n;
            this.parentH = n2;
        }
    }

    public Object getParentComponent() {
        return this.parentPanel;
    }

    public static LayoutHelper getLayoutHelper() {
        return layoutHelper;
    }

    public static void setLayoutHelper(LayoutHelper layoutHelper) {
        XComponentFactory.layoutHelper = layoutHelper;
    }

    private void setMetaContent(Object object, String string) {
        Object object2;
        if (string == null) {
            return;
        }
        boolean bl = false;
        if (string.indexOf("<?xml") != 0) {
            object2 = this.translate(string);
            if (((String)object2).compareTo(string) != 0) {
                string = object2;
                bl = true;
            }
        } else {
            bl = true;
        }
        object2 = new MetaContentReader(this.currentProject, object, string, bl);
        ((Thread)object2).start();
    }

    private void setTableContent(Object object, String string) {
        if (string != null) {
            XModel xModel = (XModel)this.currentProject.getModel().get(string);
            ((XModelHolder)object).setModel(xModel);
        }
    }

    protected static int getTypeCode(String string) {
        String string2;
        Object v;
        XComponentFactory.setupTypeNames();
        if (string.indexOf(46) > 0) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        if ((v = typeNames.get((string2 = string.charAt(0) == 'X' ? string.substring(1, string.length()) : string).toUpperCase())) == null) {
            return -1;
        }
        return (Integer)v;
    }

    protected static void setupTypeNames() {
        if (typeNames == null) {
            typeNames = new Hashtable(34);
            XComponentFactory.addTypeName("Panel", 0);
            XComponentFactory.addTypeName("Label", 1);
            XComponentFactory.addTypeName("RadioButton", 2);
            XComponentFactory.addTypeName("RADIOBUTTON", 2);
            XComponentFactory.addTypeName("Checkbox", 3);
            XComponentFactory.addTypeName("CHECK", 3);
            XComponentFactory.addTypeName("ComboBox", 4);
            XComponentFactory.addTypeName("COMBO", 4);
            XComponentFactory.addTypeName("List", 5);
            XComponentFactory.addTypeName("Image", 6);
            XComponentFactory.addTypeName("ImageMap", 22);
            XComponentFactory.addTypeName("Edit", 7);
            XComponentFactory.addTypeName("TextArea", 20);
            XComponentFactory.addTypeName("Button", 8);
            XComponentFactory.addTypeName("MetaContent", 9);
            XComponentFactory.addTypeName("Group", 10);
            XComponentFactory.addTypeName("ScrollPane", 11);
            XComponentFactory.addTypeName("ScrollableMetaContent", 12);
            XComponentFactory.addTypeName("HotspotImage", 13);
            XComponentFactory.addTypeName("HOTSPOT", 13);
            XComponentFactory.addTypeName("Table", 14);
            XComponentFactory.addTypeName("Wmf", 15);
            XComponentFactory.addTypeName("MenuBar", 17);
            XComponentFactory.addTypeName("Menu", 18);
            XComponentFactory.addTypeName("MenuItem", 19);
            XComponentFactory.addTypeName("Password", 21);
            XComponentFactory.addTypeName("Unknown", -1);
            XComponentFactory.addTypeName("TabPanel", 23);
            XComponentFactory.addTypeName("SplitPane", 24);
        }
    }

    private static void addTypeName(String string, int n) {
        typeNames.put(string.toUpperCase(), new Integer(n));
    }

    public static void setRequiresParent(boolean bl) {
        requiresParent = bl;
    }

    static {
        layoutHelper = new XLayoutHelper();
        requiresParent = false;
    }
}

